/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.persist.wurblet.CodeGenerator;
import org.tentackle.persist.wurblet.ComponentInfo;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.persist.wurblet.WurbletArgument;
import org.tentackle.persist.wurblet.WurbletArgumentExpression;
import org.tentackle.persist.wurblet.WurbletArgumentOperator;
import org.wurbelizer.wurbel.WurbelException;

public class DbSelectList
extends DbModelWurblet {
    public DbSelectList() {
        this.setConfiguration("pathAllowed");
    }

    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            this.wurbel();
        }
        catch (Throwable t) {
            if (t instanceof WurbelException) {
                throw (WurbelException)t;
            }
            throw new WurbelException("wurblet " + this + " failed", t);
        }
    }

    private void wurbel() throws WurbelException {
        String orderByStr;
        String className = this.getClassName();
        String methodName = this.getMethodName();
        String scope = "public";
        Object classVar = null;
        boolean sort = false;
        boolean lock = false;
        String append = null;
        boolean limit = false;
        boolean offset = false;
        boolean bounded = false;
        boolean resultSet = false;
        for (String arg : this.getOptionArgs()) {
            if (arg.equals("private")) {
                scope = "private";
                this.setRemote(false);
                continue;
            }
            if (arg.equals("sort")) {
                if (this.isWithDefaultSorting()) {
                    if (this.isWithSorting()) {
                        throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
                    }
                    sort = true;
                    continue;
                }
                throw new WurbelException("no sorting configured in model for " + this.getEntity());
            }
            if (arg.equals("lock")) {
                lock = true;
                continue;
            }
            if (arg.equals("limit")) {
                limit = true;
                continue;
            }
            if (arg.equals("offset")) {
                offset = true;
                continue;
            }
            if (arg.equals("bounded")) {
                bounded = true;
                continue;
            }
            if (arg.equals("resultset")) {
                resultSet = true;
                continue;
            }
            if (arg.startsWith("append=")) {
                append = arg.substring(7);
                continue;
            }
            if (!arg.startsWith("classvar=")) continue;
            classVar = arg.substring(9);
        }
        if (resultSet) {
            this.setRemote(false);
        }
        classVar = classVar == null ? "" : (String)classVar + ".";
        String params = this.buildMethodParameters(limit, offset);
        String iparms = this.buildInvocationParameters(limit, offset);
        String statementId = this.createStatementId();
        String listType = resultSet ? "ResultSetWrapper" : (this.isTracked() ? "TrackedArrayList" : "List") + "<" + (bounded ? "? extends " : "") + className + ">";
        String varListType = (this.isTracked() ? "TrackedArrayList" : "List") + "<" + className + ">";
        String rmiListType = (this.isTracked() ? "TrackedArrayList" : "List") + "<" + (bounded ? "? extends " : "") + (this.isGenerified() ? "P" : className) + ">";
        this.out.print(this.source[0]);
        this.out.print(scope);
        this.out.print(this.source[1]);
        this.out.print(listType);
        this.out.print(this.source[2]);
        this.out.print(methodName);
        this.out.print(this.source[3]);
        this.out.print(params);
        this.out.print(this.source[4]);
        if (this.isRemote()) {
            RemoteIncludes genInc = new RemoteIncludes(this);
            PrintStream implOut = genInc.getImplStream();
            PrintStream remoteOut = genInc.getRemoteStream();
            this.out.print(this.source[5]);
            remoteOut.print(this.source[6]);
            remoteOut.print(rmiListType);
            remoteOut.print(this.source[7]);
            remoteOut.print(methodName);
            remoteOut.print(this.source[8]);
            remoteOut.print(params);
            remoteOut.print(this.source[9]);
            implOut.print(this.source[10]);
            implOut.print(rmiListType);
            implOut.print(this.source[11]);
            implOut.print(methodName);
            implOut.print(this.source[12]);
            implOut.print(params);
            implOut.print(this.source[13]);
            implOut.print(methodName);
            implOut.print(this.source[14]);
            implOut.print(iparms);
            implOut.print(this.source[15]);
            this.out.print(this.source[16]);
            this.out.print(listType);
            this.out.print(this.source[17]);
            this.out.print(methodName);
            this.out.print(this.source[18]);
            this.out.print(iparms);
            this.out.print(this.source[19]);
        }
        this.out.print(this.source[20]);
        this.out.print((String)classVar);
        this.out.print(statementId);
        this.out.print(this.source[21]);
        if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
            this.out.print(this.source[22]);
        }
        boolean andPrepended = false;
        if (this.getContextAttribute() != null) {
            andPrepended = true;
            this.out.print(this.source[23]);
            this.out.print(this.getContextAttribute().getName().toUpperCase());
            this.out.print(this.source[24]);
        }
        boolean needParentheses = false;
        if (!this.getExpressionArguments().isEmpty()) {
            needParentheses = this.getExpression().needParenthesesAfterAndOperator();
            if (andPrepended || needParentheses) {
                this.out.print(this.source[25]);
            } else {
                this.out.print(this.source[26]);
                if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                    this.out.print(this.source[27]);
                }
            }
            CodeGenerator<Object> generator = new CodeGenerator<Object>(){

                @Override
                public String generate(Object t) throws WurbelException {
                    if (t instanceof WurbletArgumentOperator) {
                        return "        sql.append(Backend." + ((WurbletArgumentOperator)((Object)t)).getSql() + ");\n";
                    }
                    if (t instanceof WurbletArgumentExpression) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
                        buf.append(((WurbletArgumentExpression)t).toCode(this));
                        buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                        return buf.toString();
                    }
                    if (t instanceof WurbletArgument) {
                        StringBuilder buf = new StringBuilder();
                        WurbletArgument arg = (WurbletArgument)t;
                        Attribute attr = arg.getAttribute();
                        if (arg.isPath()) {
                            Set<Relation> existsRels = arg.getExistsRelations();
                            if (existsRels != null) {
                                String rightClass;
                                ComponentInfo ci;
                                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                                String comma = "";
                                for (Entity component : arg.getExistsComponents()) {
                                    ci = DbSelectList.this.createComponentInfo(component);
                                    rightClass = ci.getRootIdClassName();
                                    buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                                    comma = "Backend.SQL_COMMA).append(";
                                    if (!ci.isExtraJoinNecessary()) continue;
                                    buf.append("           .append(").append(comma).append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableAlias())\n");
                                }
                                for (Relation rel : existsRels) {
                                    rightClass = DbSelectList.this.deriveClassNameForEntity(rel.getForeignEntity());
                                    buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                                    comma = "Backend.SQL_COMMA).append(";
                                }
                                buf.append("           .append(Backend.SQL_WHERE)\n");
                                for (Entity component : arg.getExistsComponents()) {
                                    ci = DbSelectList.this.createComponentInfo(component);
                                    rightClass = ci.getRootIdClassName();
                                    buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(").append(ci.getRootIdColumnName()).append("))\n").append("           .append(Backend.SQL_AND)\n");
                                    if (!ci.isExtraJoinNecessary()) continue;
                                    buf.append("           .append(").append(ci.getRootIdClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID))\n").append("           .append(Backend.SQL_AND)\n");
                                }
                                for (Relation rel : existsRels) {
                                    Object rightAttribute;
                                    Object leftAttribute;
                                    if (rel.getRelationType() == RelationType.OBJECT) {
                                        leftAttribute = "CN_" + rel.getAttribute().getName().toUpperCase();
                                        rightAttribute = "CN_ID";
                                    } else {
                                        leftAttribute = "CN_ID";
                                        rightAttribute = "CN_" + rel.getForeignAttribute().getName().toUpperCase();
                                    }
                                    String leftClass = rel.getEntity().equals(DbSelectList.this.getEntity()) ? "" : DbSelectList.this.deriveClassNameForEntity(rel.getEntity()) + ".";
                                    Object leftClassVariables = leftClass.isEmpty() ? "" : leftClass + "CLASSVARIABLES.";
                                    rightClass = rel.getForeignEntity().equals(DbSelectList.this.getEntity()) ? "" : DbSelectList.this.deriveClassNameForEntity(rel.getForeignEntity()) + ".";
                                    buf.append("           .append(").append((String)leftClassVariables).append("getColumnName(").append((String)leftAttribute).append(")).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append((String)rightAttribute).append("))\n").append("           .append(Backend.SQL_AND)\n");
                                    List methodArgs = rel.getMethodArgs();
                                    for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                                        Attribute mattr = methodArg.getForeignAttribute();
                                        buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append("CN_").append(mattr.getName().toUpperCase()).append("))\n");
                                        if (methodArg.isValue()) {
                                            buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                            for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                                String name = attr.getName().toUpperCase() + sp.getPostfix();
                                                boolean mainColumn = sp.getPostfix().isEmpty();
                                                if (mainColumn) continue;
                                                buf.append("           .append(Backend.SQL_AND)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append("CN_").append(name).append("))\n").append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                            }
                                        } else {
                                            buf.append("           .append(Backend.SQL_EQUAL).append(").append((String)leftClassVariables).append("getColumnName(").append((String)leftClassVariables).append("CN_").append(methodArg.getAttribute().getName().toUpperCase()).append("))\n");
                                        }
                                        buf.append("           .append(Backend.SQL_AND)\n");
                                    }
                                }
                                buf.deleteCharAt(buf.length() - 1);
                                buf.append(";\n");
                            }
                            String compKeyClass = DbSelectList.this.deriveClassNameForEntity(attr.getEntity());
                            for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                String name = attr.getName().toUpperCase() + sp.getPostfix();
                                boolean mainColumn = sp.getPostfix().isEmpty();
                                if (!mainColumn) {
                                    buf.append("        sql.append(Backend.SQL_AND);\n");
                                }
                                buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(").append(compKeyClass).append(".CN_").append(name).append("))\n");
                                if (mainColumn) {
                                    buf.append("           .append(").append(arg.getRelop()).append(");\n");
                                    continue;
                                }
                                buf.append("           .append(Backend.SQL_EQUAL_PAR);\n");
                            }
                        } else {
                            for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                String name = attr.getName().toUpperCase() + sp.getPostfix();
                                boolean mainColumn = sp.getPostfix().isEmpty();
                                if (!mainColumn) {
                                    buf.append("        sql.append(Backend.SQL_AND);\n");
                                }
                                if (DbSelectList.this.isPathAllowed()) {
                                    if (DbSelectList.this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                                        buf.append("        sql.append(");
                                        buf.append(DbSelectList.this.deriveClassNameForEntity(attr.getEntity()));
                                        buf.append(".CLASSVARIABLES.getColumnName(CN_");
                                        buf.append(name).append("));\n");
                                    } else if (DbSelectList.this.isPdo()) {
                                        buf.append("        sql.append(getColumnName(CN_").append(name).append("));\n");
                                    } else {
                                        buf.append("        sql.append(CN_").append(name).append(");\n");
                                    }
                                } else {
                                    buf.append("        sql.append(CN_").append(name).append(");\n");
                                }
                                if (mainColumn) {
                                    buf.append("        sql.append(").append(arg.getRelop()).append(");\n");
                                    continue;
                                }
                                buf.append("        sql.append(Backend.SQL_EQUAL_PAR);\n");
                            }
                        }
                        if (arg.isEndOfExistsClause()) {
                            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                        }
                        return buf.toString();
                    }
                    return "        sql.append(" + t + ");\n";
                }
            };
            String code = this.getExpression().toCode(generator);
            if (code.endsWith("\n")) {
                code = code.substring(0, code.length() - 1);
            }
            this.out.print(code);
            this.out.print(this.source[28]);
            if (andPrepended || needParentheses) {
                this.out.print(this.source[29]);
            } else if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[30]);
            }
        }
        if ((orderByStr = this.createOrderBy()) != null) {
            this.out.print(this.source[31]);
            this.out.print(orderByStr);
            this.out.print(this.source[32]);
        }
        this.out.print(this.source[33]);
        this.out.print(lock ? "true" : "false");
        this.out.print(this.source[34]);
        this.out.print(limit ? "limit" : "0");
        this.out.print(this.source[35]);
        this.out.print(offset ? "offset" : "0");
        this.out.print(this.source[36]);
        if (sort) {
            this.out.print(this.source[37]);
        }
        if (append != null) {
            this.out.print(this.source[38]);
            this.out.print(append);
            this.out.print(this.source[39]);
        }
        this.out.print(this.source[40]);
        if (limit || offset) {
            this.out.print(this.source[41]);
            this.out.print(limit ? "limit" : "0");
            this.out.print(this.source[42]);
            this.out.print(offset ? "offset" : "0");
            this.out.print(this.source[43]);
        } else {
            this.out.print(this.source[44]);
        }
        if (this.isWithJoins()) {
            this.out.print(this.createJoinSetPars());
        }
        if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
            this.out.print(this.source[45]);
        }
        if (this.getContextAttribute() != null) {
            this.out.print(this.source[46]);
            this.out.print(this.createJdbcSetterName(this.getContextAttribute()));
            this.out.print(this.source[47]);
            this.out.print(this.getContextAttribute().getName());
            this.out.print(this.source[48]);
        }
        for (WurbletArgument par : this.getMethodArguments()) {
            Set<Relation> existsRels;
            if (par.isPath() && (existsRels = par.getExistsRelations()) != null) {
                for (Relation rel : existsRels) {
                    List methodArgs = rel.getMethodArgs();
                    for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                        if (!methodArg.isValue()) continue;
                        Attribute attr = methodArg.getForeignAttribute();
                        if (attr.getOptions().isMapNull()) {
                            this.out.print(this.source[49]);
                            this.out.print(this.createJdbcSetterName(attr));
                            this.out.print(this.source[50]);
                            this.out.print(this.getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                            this.out.print(this.source[51]);
                        } else {
                            this.out.print(this.source[52]);
                            this.out.print(this.createJdbcSetterName(attr));
                            this.out.print(this.source[53]);
                            this.out.print(this.getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                            this.out.print(this.source[54]);
                        }
                        for (int p = 1; p < attr.getDataType().getSqlTypes().length; ++p) {
                            this.out.print(this.source[55]);
                        }
                    }
                }
            }
            if (par.isValueLiterally()) continue;
            Attribute attr = par.getAttribute();
            if (attr.getOptions().isMapNull()) {
                this.out.print(this.source[56]);
                this.out.print(this.createJdbcSetterName(attr));
                this.out.print(this.source[57]);
                this.out.print(this.getJdbcCode(attr, par.getJdbcValue()));
                this.out.print(this.source[58]);
            } else {
                this.out.print(this.source[59]);
                this.out.print(this.createJdbcSetterName(attr));
                this.out.print(this.source[60]);
                this.out.print(this.getJdbcCode(attr, par.getJdbcValue()));
                this.out.print(this.source[61]);
            }
            for (int p = 1; p < attr.getDataType().getSqlTypes().length; ++p) {
                this.out.print(this.source[62]);
            }
        }
        if (limit || offset) {
            this.out.print(this.source[63]);
            this.out.print(limit ? "limit" : "0");
            this.out.print(this.source[64]);
            this.out.print(offset ? "offset" : "0");
            this.out.print(this.source[65]);
        }
        if (resultSet) {
            this.out.print(this.source[66]);
        } else {
            this.out.print(this.source[67]);
            if (this.isTracked()) {
                this.out.print(this.source[68]);
                this.out.print(varListType);
                this.out.print(this.source[69]);
            } else {
                this.out.print(this.source[70]);
                this.out.print(varListType);
                this.out.print(this.source[71]);
            }
            this.out.print(this.source[72]);
            this.out.print(className);
            this.out.print(this.source[73]);
            this.out.print(className);
            this.out.print(this.source[74]);
            this.out.print(className);
            this.out.print(this.source[75]);
            if (this.isTracked()) {
                this.out.print(this.source[76]);
            }
            this.out.print(this.source[77]);
        }
        this.out.print(this.source[78]);
        if (((String)classVar).length() == 0) {
            this.out.print(this.source[79]);
            this.out.print(statementId);
            this.out.print(this.source[80]);
        }
    }

    public String process(String code) {
        int ref = code.lastIndexOf("ndx");
        int pos = code.lastIndexOf("(ndx++,");
        if (pos >= 0 && ref == pos + 1) {
            return code.substring(0, pos + 4) + code.substring(pos + 6);
        }
        return code;
    }
}

