/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.persist.wurblet.CodeGenerator;
import org.tentackle.persist.wurblet.ComponentInfo;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.persist.wurblet.WurbletArgument;
import org.tentackle.persist.wurblet.WurbletArgumentExpression;
import org.tentackle.persist.wurblet.WurbletArgumentOperator;
import org.wurbelizer.wurbel.WurbelException;

public class PdoSelectList
extends DbModelWurblet {
    public PdoSelectList() {
        this.setConfiguration("pathAllowed");
    }

    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            this.wurbel();
        }
        catch (Throwable t) {
            if (t instanceof WurbelException) {
                throw (WurbelException)t;
            }
            throw new WurbelException("wurblet " + this + " failed", t);
        }
    }

    private void wurbel() throws WurbelException {
        String orderByStr;
        String varListType;
        String listType;
        String pdoName;
        this.assertEntityIsPersistable();
        String className = this.getClassName();
        String methodName = this.getMethodName();
        String pdoType = pdoName = this.getPdoClassName();
        String poType = className;
        if (this.isGenerified()) {
            pdoType = "T";
            poType = "P";
        }
        boolean sort = false;
        boolean lock = false;
        String append = null;
        boolean limit = false;
        boolean offset = false;
        boolean bounded = false;
        String cursor = null;
        boolean resultSet = false;
        boolean noif = false;
        String scope = "public";
        for (String arg : this.getOptionArgs()) {
            if (arg.equals("private")) {
                scope = "private";
                continue;
            }
            if (arg.equals("sort")) {
                if (this.isWithDefaultSorting()) {
                    if (this.isWithSorting()) {
                        throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
                    }
                    sort = true;
                    continue;
                }
                throw new WurbelException("no sorting configured in model for " + this.getEntity());
            }
            if (arg.equals("noif")) {
                noif = true;
                continue;
            }
            if (arg.equals("lock")) {
                lock = true;
                continue;
            }
            if (arg.equals("limit")) {
                limit = true;
                continue;
            }
            if (arg.equals("offset")) {
                offset = true;
                continue;
            }
            if (arg.equals("bounded")) {
                bounded = true;
                continue;
            }
            if (arg.equals("resultset")) {
                resultSet = true;
                continue;
            }
            if (arg.equals("cursor")) {
                cursor = "ScrollableResource<" + pdoName + ">";
                continue;
            }
            if (!arg.startsWith("append=")) continue;
            append = arg.substring(7);
        }
        if (scope.equals("private")) {
            this.setRemote(false);
            noif = true;
        }
        if (resultSet) {
            this.setRemote(false);
        }
        if (cursor != null) {
            List<WurbletArgument> sortKeys;
            if (resultSet) {
                throw new WurbelException("resultset not allowed with cursor");
            }
            if (this.isTracked()) {
                throw new WurbelException("tracked not available with cursors!");
            }
            if (this.isWithJoins() && ((sortKeys = this.getSortingArguments()).isEmpty() || !sortKeys.get(0).getAttribute().getColumnName().equals("id"))) {
                throw new WurbelException("cursors with joins must be sorted by ID");
            }
        }
        String params = this.buildMethodParameters(limit, offset);
        String iparms = this.buildInvocationParameters(limit, offset);
        String statementId = this.createStatementId();
        String reflMethod = this.getGuardName() + "Method";
        String poImpl = this.deriveClassNameForEntity(this.getEntity());
        Object object = resultSet ? "ResultSetWrapper" : (cursor != null ? "ScrollableResource<" + (bounded ? "? extends " : "") + pdoType + ">" : (listType = (this.isTracked() ? "TrackedList" : "List") + "<" + (bounded ? "? extends " : "") + pdoType + ">"));
        String string = cursor != null ? cursor : (varListType = (this.isTracked() ? "TrackedList" : "List") + "<" + pdoType + ">");
        String rmiListType = cursor != null ? cursor : (this.isTracked() ? "TrackedList" : "List") + "<" + (bounded ? "? extends " : "") + pdoType + ">";
        String alias = this.getEntity().getTopSuperEntity().getTableAlias();
        this.out.print(this.source[0]);
        this.out.print(statementId);
        this.out.print(this.source[1]);
        if (!noif) {
            this.out.print(this.source[2]);
        }
        this.out.print(this.source[3]);
        this.out.print(scope);
        this.out.print(this.source[4]);
        this.out.print(listType);
        this.out.print(this.source[5]);
        this.out.print(methodName);
        this.out.print(this.source[6]);
        this.out.print(this.as(params));
        this.out.print(this.source[7]);
        if (this.isRemote()) {
            RemoteIncludes genInc = new RemoteIncludes(this);
            PrintStream implOut = genInc.getImplStream();
            PrintStream remoteOut = genInc.getRemoteStream();
            if (this.isPdoProvidingArguments()) {
                this.out.print(this.source[8]);
                if (cursor != null) {
                    remoteOut.print(this.source[9]);
                    remoteOut.print(methodName);
                    remoteOut.print(this.source[10]);
                    remoteOut.print(this.pcs(params, pdoType + " obj"));
                    remoteOut.print(this.source[11]);
                    implOut.print(this.source[12]);
                    implOut.print(methodName);
                    implOut.print(this.source[13]);
                    implOut.print(this.pcs(params, pdoType + " obj"));
                    implOut.print(this.source[14]);
                    implOut.print(methodName);
                    implOut.print(this.source[15]);
                    implOut.print(iparms);
                    implOut.print(this.source[16]);
                    this.out.print(this.source[17]);
                    this.out.print(methodName);
                    this.out.print(this.source[18]);
                    this.out.print(this.pcs(iparms, "me()"));
                    this.out.print(this.source[19]);
                } else {
                    remoteOut.print(this.source[20]);
                    remoteOut.print(rmiListType);
                    remoteOut.print(this.source[21]);
                    remoteOut.print(methodName);
                    remoteOut.print(this.source[22]);
                    remoteOut.print(this.pcs(params, pdoType + " obj"));
                    remoteOut.print(this.source[23]);
                    implOut.print(this.source[24]);
                    implOut.print(rmiListType);
                    implOut.print(this.source[25]);
                    implOut.print(methodName);
                    implOut.print(this.source[26]);
                    implOut.print(this.pcs(params, pdoType + " obj"));
                    implOut.print(this.source[27]);
                    implOut.print(methodName);
                    implOut.print(this.source[28]);
                    implOut.print(iparms);
                    implOut.print(this.source[29]);
                    this.out.print(this.source[30]);
                    this.out.print(listType);
                    this.out.print(this.source[31]);
                    this.out.print(methodName);
                    this.out.print(this.source[32]);
                    this.out.print(this.pcs(iparms, "me()"));
                    this.out.print(this.source[33]);
                }
                this.out.print(this.source[34]);
            } else {
                this.out.print(this.source[35]);
                if (cursor != null) {
                    remoteOut.print(this.source[36]);
                    remoteOut.print(methodName);
                    remoteOut.print(this.source[37]);
                    remoteOut.print(this.pcs(params, "DomainContext context"));
                    remoteOut.print(this.source[38]);
                    implOut.print(this.source[39]);
                    implOut.print(methodName);
                    implOut.print(this.source[40]);
                    implOut.print(this.pcs(params, "DomainContext context"));
                    implOut.print(this.source[41]);
                    implOut.print(methodName);
                    implOut.print(this.source[42]);
                    implOut.print(iparms);
                    implOut.print(this.source[43]);
                    this.out.print(this.source[44]);
                    this.out.print(methodName);
                    this.out.print(this.source[45]);
                    this.out.print(this.pcs(iparms, "getDomainContext()"));
                    this.out.print(this.source[46]);
                } else {
                    remoteOut.print(this.source[47]);
                    remoteOut.print(rmiListType);
                    remoteOut.print(this.source[48]);
                    remoteOut.print(methodName);
                    remoteOut.print(this.source[49]);
                    remoteOut.print(this.pcs(params, "DomainContext context"));
                    remoteOut.print(this.source[50]);
                    implOut.print(this.source[51]);
                    implOut.print(rmiListType);
                    implOut.print(this.source[52]);
                    implOut.print(methodName);
                    implOut.print(this.source[53]);
                    implOut.print(this.pcs(params, "DomainContext context"));
                    implOut.print(this.source[54]);
                    implOut.print(methodName);
                    implOut.print(this.source[55]);
                    implOut.print(iparms);
                    implOut.print(this.source[56]);
                    this.out.print(this.source[57]);
                    this.out.print(listType);
                    this.out.print(this.source[58]);
                    this.out.print(methodName);
                    this.out.print(this.source[59]);
                    this.out.print(this.pcs(iparms, "getDomainContext()"));
                    this.out.print(this.source[60]);
                }
                this.out.print(this.source[61]);
            }
        }
        if (this.isWithJoins()) {
            this.out.print(this.createJoins());
        }
        if (lock) {
            this.out.print(this.source[62]);
        }
        this.out.print(this.source[63]);
        this.out.print(statementId);
        this.out.print(this.source[64]);
        if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
            this.out.print(this.source[65]);
        }
        boolean andPrepended = false;
        if (this.getContextAttribute() != null) {
            andPrepended = true;
            this.out.print(this.source[66]);
            this.out.print(this.getContextAttribute().getName().toUpperCase());
            this.out.print(this.source[67]);
        }
        boolean needParentheses = false;
        if (!this.getExpressionArguments().isEmpty()) {
            needParentheses = this.getExpression().needParenthesesAfterAndOperator();
            if (andPrepended || needParentheses) {
                this.out.print(this.source[68]);
            } else {
                this.out.print(this.source[69]);
                if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                    this.out.print(this.source[70]);
                }
            }
            CodeGenerator<Object> generator = new CodeGenerator<Object>(){

                @Override
                public String generate(Object t) throws WurbelException {
                    if (t instanceof WurbletArgumentOperator) {
                        return "        sql.append(Backend." + ((WurbletArgumentOperator)((Object)t)).getSql() + ");\n";
                    }
                    if (t instanceof WurbletArgumentExpression) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
                        buf.append(((WurbletArgumentExpression)t).toCode(this));
                        buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                        return buf.toString();
                    }
                    if (t instanceof WurbletArgument) {
                        StringBuilder buf = new StringBuilder();
                        WurbletArgument arg = (WurbletArgument)t;
                        Attribute attr = arg.getAttribute();
                        if (arg.isPath()) {
                            Set<Relation> existsRels = arg.getExistsRelations();
                            if (existsRels != null) {
                                String rightClass;
                                ComponentInfo ci;
                                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                                String comma = "";
                                for (Entity component : arg.getExistsComponents()) {
                                    ci = PdoSelectList.this.createComponentInfo(component);
                                    rightClass = ci.getRootIdClassName();
                                    buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                                    comma = "Backend.SQL_COMMA).append(";
                                    if (!ci.isExtraJoinNecessary()) continue;
                                    buf.append("           .append(").append(comma).append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableAlias())\n");
                                }
                                for (Relation rel : existsRels) {
                                    rightClass = PdoSelectList.this.deriveClassNameForEntity(rel.getForeignEntity());
                                    buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                                    comma = "Backend.SQL_COMMA).append(";
                                }
                                buf.append("           .append(Backend.SQL_WHERE)\n");
                                for (Entity component : arg.getExistsComponents()) {
                                    ci = PdoSelectList.this.createComponentInfo(component);
                                    rightClass = ci.getRootIdClassName();
                                    buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(").append(ci.getRootIdColumnName()).append("))\n").append("           .append(Backend.SQL_AND)\n");
                                    if (!ci.isExtraJoinNecessary()) continue;
                                    buf.append("           .append(").append(ci.getRootIdClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID))\n").append("           .append(Backend.SQL_AND)\n");
                                }
                                for (Relation rel : existsRels) {
                                    Object rightAttribute;
                                    Object leftAttribute;
                                    if (rel.getRelationType() == RelationType.OBJECT) {
                                        leftAttribute = "CN_" + rel.getAttribute().getName().toUpperCase();
                                        rightAttribute = "CN_ID";
                                    } else {
                                        leftAttribute = "CN_ID";
                                        rightAttribute = "CN_" + rel.getForeignAttribute().getName().toUpperCase();
                                    }
                                    String leftClass = rel.getEntity().equals(PdoSelectList.this.getEntity()) ? "" : PdoSelectList.this.deriveClassNameForEntity(rel.getEntity()) + ".";
                                    Object leftClassVariables = leftClass.isEmpty() ? "" : leftClass + "CLASSVARIABLES.";
                                    rightClass = rel.getForeignEntity().equals(PdoSelectList.this.getEntity()) ? "" : PdoSelectList.this.deriveClassNameForEntity(rel.getForeignEntity()) + ".";
                                    buf.append("           .append(").append((String)leftClassVariables).append("getColumnName(").append((String)leftAttribute).append(")).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append((String)rightAttribute).append("))\n").append("           .append(Backend.SQL_AND)\n");
                                    List methodArgs = rel.getMethodArgs();
                                    for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                                        Attribute mattr = methodArg.getForeignAttribute();
                                        buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append("CN_").append(mattr.getName().toUpperCase()).append("))\n");
                                        if (methodArg.isValue()) {
                                            buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                            for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                                String name = attr.getName().toUpperCase() + sp.getPostfix();
                                                boolean mainColumn = sp.getPostfix().isEmpty();
                                                if (mainColumn) continue;
                                                buf.append("           .append(Backend.SQL_AND)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append("CN_").append(name).append("))\n").append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                            }
                                        } else {
                                            buf.append("           .append(Backend.SQL_EQUAL).append(").append((String)leftClassVariables).append("getColumnName(").append((String)leftClassVariables).append("CN_").append(methodArg.getAttribute().getName().toUpperCase()).append("))\n");
                                        }
                                        buf.append("           .append(Backend.SQL_AND)\n");
                                    }
                                }
                                buf.deleteCharAt(buf.length() - 1);
                                buf.append(";\n");
                            }
                            String compKeyClass = PdoSelectList.this.deriveClassNameForEntity(attr.getEntity());
                            for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                String name = attr.getName().toUpperCase() + sp.getPostfix();
                                boolean mainColumn = sp.getPostfix().isEmpty();
                                if (!mainColumn) {
                                    buf.append("        sql.append(Backend.SQL_AND);\n");
                                }
                                buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(").append(compKeyClass).append(".CN_").append(name).append("))\n");
                                if (mainColumn) {
                                    buf.append("           .append(").append(arg.getRelop()).append(");\n");
                                    continue;
                                }
                                buf.append("           .append(Backend.SQL_EQUAL_PAR);\n");
                            }
                        } else {
                            for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                String name = attr.getName().toUpperCase() + sp.getPostfix();
                                boolean mainColumn = sp.getPostfix().isEmpty();
                                if (!mainColumn) {
                                    buf.append("        sql.append(Backend.SQL_AND);\n");
                                }
                                if (PdoSelectList.this.isPathAllowed()) {
                                    if (PdoSelectList.this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                                        buf.append("        sql.append(");
                                        buf.append(PdoSelectList.this.deriveClassNameForEntity(attr.getEntity()));
                                        buf.append(".CLASSVARIABLES.getColumnName(CN_");
                                        buf.append(name).append("));\n");
                                    } else if (PdoSelectList.this.isPdo()) {
                                        buf.append("        sql.append(getColumnName(CN_").append(name).append("));\n");
                                    } else {
                                        buf.append("        sql.append(CN_").append(name).append(");\n");
                                    }
                                } else {
                                    buf.append("        sql.append(CN_").append(name).append(");\n");
                                }
                                if (mainColumn) {
                                    buf.append("        sql.append(").append(arg.getRelop()).append(");\n");
                                    continue;
                                }
                                buf.append("        sql.append(Backend.SQL_EQUAL_PAR);\n");
                            }
                        }
                        if (arg.isEndOfExistsClause()) {
                            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                        }
                        return buf.toString();
                    }
                    return "        sql.append(" + t + ");\n";
                }
            };
            String code = this.getExpression().toCode(generator);
            if (code.endsWith("\n")) {
                code = code.substring(0, code.length() - 1);
            }
            this.out.print(code);
            this.out.print(this.source[71]);
            if (andPrepended || needParentheses) {
                this.out.print(this.source[72]);
            } else if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[73]);
            }
        }
        if ((orderByStr = this.createOrderBy()) != null) {
            this.out.print(this.source[74]);
            this.out.print(orderByStr);
            this.out.print(this.source[75]);
        }
        this.out.print(this.source[76]);
        this.out.print(lock ? "true" : "false");
        this.out.print(this.source[77]);
        this.out.print(limit ? "limit" : "0");
        this.out.print(this.source[78]);
        this.out.print(offset ? "offset" : "0");
        this.out.print(this.source[79]);
        if (sort) {
            this.out.print(this.source[80]);
        }
        if (append != null) {
            this.out.print(this.source[81]);
            this.out.print(append);
            this.out.print(this.source[82]);
        }
        if (this.isWithJoins()) {
            this.out.print(this.source[83]);
        }
        this.out.print(this.source[84]);
        if (limit || offset) {
            this.out.print(this.source[85]);
            this.out.print(limit ? "limit" : "0");
            this.out.print(this.source[86]);
            this.out.print(offset ? "offset" : "0");
            this.out.print(this.source[87]);
        } else {
            this.out.print(this.source[88]);
        }
        if (this.isWithJoins()) {
            this.out.print(this.createJoinSetPars());
        }
        if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
            this.out.print(this.source[89]);
        }
        if (this.getContextAttribute() != null) {
            this.out.print(this.source[90]);
            this.out.print(this.createJdbcSetterName(this.getContextAttribute()));
            this.out.print(this.source[91]);
            this.out.print(this.getContextAttribute().getName());
            this.out.print(this.source[92]);
        }
        for (WurbletArgument par : this.getMethodArguments()) {
            Set<Relation> existsRels;
            if (par.isPath() && (existsRels = par.getExistsRelations()) != null) {
                for (Relation rel : existsRels) {
                    List methodArgs = rel.getMethodArgs();
                    for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                        if (!methodArg.isValue()) continue;
                        Attribute attr = methodArg.getForeignAttribute();
                        if (attr.getOptions().isMapNull()) {
                            this.out.print(this.source[93]);
                            this.out.print(this.createJdbcSetterName(attr));
                            this.out.print(this.source[94]);
                            this.out.print(this.getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                            this.out.print(this.source[95]);
                        } else {
                            this.out.print(this.source[96]);
                            this.out.print(this.createJdbcSetterName(attr));
                            this.out.print(this.source[97]);
                            this.out.print(this.getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                            this.out.print(this.source[98]);
                        }
                        for (int p = 1; p < attr.getDataType().getSqlTypes().length; ++p) {
                            this.out.print(this.source[99]);
                        }
                    }
                }
            }
            if (par.isValueLiterally()) continue;
            Attribute attr = par.getAttribute();
            if (attr.getOptions().isMapNull()) {
                this.out.print(this.source[100]);
                this.out.print(this.createJdbcSetterName(attr));
                this.out.print(this.source[101]);
                this.out.print(this.getJdbcCode(attr, par.getJdbcValue()));
                this.out.print(this.source[102]);
            } else {
                this.out.print(this.source[103]);
                this.out.print(this.createJdbcSetterName(attr));
                this.out.print(this.source[104]);
                this.out.print(this.getJdbcCode(attr, par.getJdbcValue()));
                this.out.print(this.source[105]);
            }
            for (int p = 1; p < attr.getDataType().getSqlTypes().length; ++p) {
                this.out.print(this.source[106]);
            }
        }
        if (limit || offset) {
            this.out.print(this.source[107]);
            this.out.print(limit ? "limit" : "0");
            this.out.print(this.source[108]);
            this.out.print(offset ? "offset" : "0");
            this.out.print(this.source[109]);
        }
        if (resultSet) {
            this.out.print(this.source[110]);
        } else if (cursor != null) {
            this.out.print(this.source[111]);
            if (this.isWithJoins()) {
                this.out.print(this.source[112]);
            } else {
                this.out.print(this.source[113]);
            }
        } else if (this.isTracked()) {
            if (this.isWithJoins()) {
                this.out.print(this.source[114]);
            } else {
                this.out.print(this.source[115]);
            }
        } else if (this.isWithJoins()) {
            this.out.print(this.source[116]);
        } else {
            this.out.print(this.source[117]);
        }
        this.out.print(this.source[118]);
    }

    public String process(String code) {
        int ref = code.lastIndexOf("ndx");
        int pos = code.lastIndexOf("(ndx++,");
        if (pos >= 0 && ref == pos + 1) {
            return code.substring(0, pos + 4) + code.substring(pos + 6);
        }
        return code;
    }
}

