/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.ComponentInfo;
import org.tentackle.wurblet.WurbletArgument;
import org.tentackle.wurblet.WurbletArgumentExpression;
import org.tentackle.wurblet.WurbletArgumentOperator;
import org.wurbelizer.wurbel.WurbelException;

public class PdoIsReferencing
extends DbModelWurblet {
    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            this.wurbel();
        }
        catch (Throwable t) {
            if (t instanceof WurbelException) {
                throw (WurbelException)t;
            }
            throw new WurbelException("wurblet " + this + " failed", t);
        }
    }

    private void wurbel() throws WurbelException, ModelException {
        String orderByStr;
        this.assertEntityIsPersistable();
        String className = this.getClassName();
        String methodName = this.getMethodName();
        String pdoName = this.getPdoClassName();
        Object classVar = null;
        String append = null;
        String scope = "public";
        for (String arg : this.getOptionArgs()) {
            if (arg.equals("private")) {
                scope = "private";
                continue;
            }
            if (arg.startsWith("append=")) {
                append = arg.substring(7);
                continue;
            }
            if (!arg.startsWith("classvar=")) continue;
            classVar = arg.substring(9);
        }
        if (scope.equals("private")) {
            this.setRemote(false);
        }
        classVar = classVar == null ? "" : (String)classVar + ".";
        if (methodName == null) {
            throw new WurbelException("can't determine <methodname>");
        }
        if (className == null) {
            throw new WurbelException("can't determine <classname>");
        }
        if (pdoName == null) {
            throw new WurbelException("can't determine PDO interface");
        }
        if (this.getExpressionArguments().isEmpty()) {
            throw new WurbelException("no keys given");
        }
        String params = this.buildMethodParameters();
        String iparms = this.buildInvocationParameters();
        String statementId = this.createStatementId();
        Entity selectingEntity = null;
        for (WurbletArgument key : this.getExpressionArguments()) {
            if (selectingEntity == null) {
                selectingEntity = key.getAttribute().getEntity();
                continue;
            }
            if (selectingEntity.equals(key.getAttribute().getEntity())) continue;
            throw new WurbelException("all keys must belong to the same entity");
        }
        this.out.print(this.source[0]);
        this.out.print(scope);
        this.out.print(this.source[1]);
        this.out.print(methodName);
        this.out.print(this.source[2]);
        this.out.print(params);
        this.out.print(this.source[3]);
        if (this.isRemote()) {
            RemoteIncludes genInc = new RemoteIncludes(this);
            PrintStream implOut = genInc.getImplStream();
            PrintStream remoteOut = genInc.getRemoteStream();
            this.out.print(this.source[4]);
            if (this.getContextAttribute() != null) {
                remoteOut.print(this.source[5]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[6]);
                remoteOut.print(this.pcs(params, "DomainContext context"));
                remoteOut.print(this.source[7]);
                implOut.print(this.source[8]);
                implOut.print(methodName);
                implOut.print(this.source[9]);
                implOut.print(this.pcs(params, "DomainContext context"));
                implOut.print(this.source[10]);
                implOut.print(methodName);
                implOut.print(this.source[11]);
                implOut.print(iparms);
                implOut.print(this.source[12]);
                this.out.print(this.source[13]);
                this.out.print(methodName);
                this.out.print(this.source[14]);
                this.out.print(this.pcs(iparms, "getDomainContext()"));
                this.out.print(this.source[15]);
            } else {
                remoteOut.print(this.source[16]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[17]);
                remoteOut.print(params);
                remoteOut.print(this.source[18]);
                implOut.print(this.source[19]);
                implOut.print(methodName);
                implOut.print(this.source[20]);
                implOut.print(params);
                implOut.print(this.source[21]);
                implOut.print(this.source[22]);
                implOut.print(methodName);
                implOut.print(this.source[23]);
                implOut.print(iparms);
                implOut.print(this.source[24]);
                this.out.print(this.source[25]);
                this.out.print(methodName);
                this.out.print(this.source[26]);
                this.out.print(iparms);
                this.out.print(this.source[27]);
            }
            this.out.print(this.source[28]);
        }
        Object cvars = "false";
        if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
            cvars = this.deriveClassNameForEntity(selectingEntity) + ".CLASSVARIABLES, false";
        }
        this.out.print(this.source[29]);
        this.out.print((String)classVar);
        this.out.print(statementId);
        this.out.print(this.source[30]);
        this.out.print((String)cvars);
        this.out.print(this.source[31]);
        if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
            this.out.print(this.source[32]);
        }
        boolean andPrepended = false;
        if (this.getContextAttribute() != null) {
            andPrepended = true;
            this.out.print(this.source[33]);
            this.out.print(this.getColumnNameConstant(this.getContextAttribute(), 0));
            this.out.print(this.source[34]);
        }
        boolean needParentheses = false;
        if (!this.getExpressionArguments().isEmpty()) {
            needParentheses = this.getExpression().needParenthesesAfterAndOperator();
            if (andPrepended || needParentheses) {
                this.out.print(this.source[35]);
            } else {
                this.out.print(this.source[36]);
                if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                    this.out.print(this.source[37]);
                }
            }
            CodeGenerator<Object> generator = new CodeGenerator<Object>(){

                public String generate(Object t) throws WurbelException {
                    if (t instanceof WurbletArgumentOperator) {
                        return "        sql.append(Backend." + ((WurbletArgumentOperator)t).getSql() + ");\n";
                    }
                    if (t instanceof WurbletArgumentExpression) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
                        buf.append(((WurbletArgumentExpression)t).toCode((CodeGenerator)this));
                        buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                        return buf.toString();
                    }
                    if (t instanceof WurbletArgument) {
                        StringBuilder buf = new StringBuilder();
                        WurbletArgument arg = (WurbletArgument)t;
                        Attribute attr = arg.getAttribute();
                        if (arg.isPath()) {
                            Set existsRels = arg.getExistsRelations();
                            if (existsRels != null) {
                                String rightClass;
                                ComponentInfo ci;
                                buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                                String comma = "";
                                for (Entity component : arg.getExistsComponents()) {
                                    ci = PdoIsReferencing.this.createComponentInfo(component);
                                    rightClass = ci.getRootIdClassName();
                                    buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                                    comma = "Backend.SQL_COMMA).append(";
                                    if (!ci.isExtraJoinNecessary()) continue;
                                    buf.append("           .append(").append(comma).append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableAlias())\n");
                                }
                                for (Relation rel : existsRels) {
                                    rightClass = PdoIsReferencing.this.deriveClassNameForEntity(rel.getForeignEntity());
                                    buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                                    comma = "Backend.SQL_COMMA).append(";
                                }
                                buf.append("           .append(Backend.SQL_WHERE)\n");
                                for (Entity component : arg.getExistsComponents()) {
                                    ci = PdoIsReferencing.this.createComponentInfo(component);
                                    rightClass = ci.getRootIdClassName();
                                    buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(").append(ci.getRootIdColumnName()).append("))\n").append("           .append(Backend.SQL_AND)\n");
                                    if (!ci.isExtraJoinNecessary()) continue;
                                    buf.append("           .append(").append(ci.getRootIdClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID))\n").append("           .append(Backend.SQL_AND)\n");
                                }
                                for (Relation rel : existsRels) {
                                    String rightAttribute;
                                    String leftAttribute;
                                    if (rel.getRelationType() == RelationType.OBJECT) {
                                        leftAttribute = PdoIsReferencing.this.getColumnNameConstant(rel.getAttribute(), 0);
                                        rightAttribute = "CN_ID";
                                    } else {
                                        leftAttribute = "CN_ID";
                                        rightAttribute = PdoIsReferencing.this.getColumnNameConstant(rel.getForeignAttribute(), 0);
                                    }
                                    String leftClass = rel.getEntity().equals(PdoIsReferencing.this.getEntity()) ? "" : PdoIsReferencing.this.deriveClassNameForEntity(rel.getEntity()) + ".";
                                    Object leftClassVariables = leftClass.isEmpty() ? "" : leftClass + "CLASSVARIABLES.";
                                    rightClass = rel.getForeignEntity().equals(PdoIsReferencing.this.getEntity()) ? "" : PdoIsReferencing.this.deriveClassNameForEntity(rel.getForeignEntity()) + ".";
                                    buf.append("           .append(").append((String)leftClassVariables).append("getColumnName(").append(leftAttribute).append(")).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(rightAttribute).append("))\n").append("           .append(Backend.SQL_AND)\n");
                                    List methodArgs = rel.getMethodArgs();
                                    for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                                        Attribute mattr = methodArg.getForeignAttribute();
                                        buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(PdoIsReferencing.this.getColumnNameConstant(mattr, 0)).append("))\n");
                                        if (methodArg.isValue()) {
                                            buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                            for (int columnIndex = 1; columnIndex < PdoIsReferencing.this.getEffectiveDataType(attr).getColumnCount(); ++columnIndex) {
                                                buf.append("           .append(Backend.SQL_AND)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(PdoIsReferencing.this.getColumnNameConstant(attr, columnIndex)).append("))\n").append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                            }
                                        } else {
                                            buf.append("           .append(Backend.SQL_EQUAL).append(").append((String)leftClassVariables).append("getColumnName(").append((String)leftClassVariables).append(PdoIsReferencing.this.getColumnNameConstant(methodArg.getAttribute(), 0)).append("))\n");
                                        }
                                        buf.append("           .append(Backend.SQL_AND)\n");
                                    }
                                }
                                buf.deleteCharAt(buf.length() - 1);
                                buf.append(";\n");
                            }
                            String compKeyClass = PdoIsReferencing.this.deriveClassNameForEntity(attr.getEntity());
                            for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(); ++columnIndex) {
                                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                                    buf.append("        sql.append(Backend.SQL_AND);\n");
                                }
                                if (arg.getColumnIndex() != null && columnIndex != arg.getColumnIndex()) continue;
                                buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(").append(compKeyClass).append('.').append(PdoIsReferencing.this.getColumnNameConstant(attr, columnIndex)).append("))\n").append("           ").append(PdoIsReferencing.this.createRelopCode(arg)).append(";\n");
                            }
                        } else {
                            for (int columnIndex = 0; columnIndex < arg.getDataType().getColumnCount(); ++columnIndex) {
                                if (columnIndex > 0 && arg.getColumnIndex() == null) {
                                    buf.append("        sql.append(Backend.SQL_AND);\n");
                                }
                                if (arg.getColumnIndex() != null && columnIndex != arg.getColumnIndex()) continue;
                                if (PdoIsReferencing.this.isPathAllowed()) {
                                    if (PdoIsReferencing.this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                                        buf.append("        sql.append(");
                                        buf.append(PdoIsReferencing.this.deriveClassNameForEntity(attr.getEntity()));
                                        buf.append(".CLASSVARIABLES.getColumnName(");
                                        buf.append(PdoIsReferencing.this.getColumnNameConstant(attr, columnIndex)).append("));\n");
                                    } else if (PdoIsReferencing.this.isPdo()) {
                                        buf.append("        sql.append(getColumnName(").append(PdoIsReferencing.this.getColumnNameConstant(attr, columnIndex)).append("));\n");
                                    } else {
                                        buf.append("        sql.append(").append(PdoIsReferencing.this.getColumnNameConstant(attr, columnIndex)).append(");\n");
                                    }
                                } else {
                                    buf.append("        sql.append(").append(PdoIsReferencing.this.getColumnNameConstant(attr, columnIndex)).append(");\n");
                                }
                                buf.append("        sql").append(PdoIsReferencing.this.createRelopCode(arg)).append(";\n");
                            }
                        }
                        if (arg.isEndOfExistsClause()) {
                            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                        }
                        return buf.toString();
                    }
                    return "        sql.append(" + t + ");\n";
                }
            };
            String code = this.getExpression().toCode((CodeGenerator)generator);
            if (code.endsWith("\n")) {
                code = code.substring(0, code.length() - 1);
            }
            this.out.print(code);
            this.out.print(this.source[38]);
            if (andPrepended || needParentheses) {
                this.out.print(this.source[39]);
            } else if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[40]);
            }
        }
        if ((orderByStr = this.createOrderBy()) != null) {
            this.out.print(this.source[41]);
            this.out.print(orderByStr);
            this.out.print(this.source[42]);
        }
        this.out.print(this.source[43]);
        if (append != null) {
            this.out.print(this.source[44]);
            this.out.print(append);
            this.out.print(this.source[45]);
        }
        this.out.print(this.source[46]);
        if (this.isWithJoins()) {
            this.out.print(this.createJoinSetPars());
        }
        if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
            this.out.print(this.source[47]);
        }
        if (this.getContextAttribute() != null) {
            this.out.print(this.source[48]);
            this.out.print(this.createJdbcSetterName(this.getContextAttribute().getDataType()));
            this.out.print(this.source[49]);
            this.out.print(this.getContextAttribute().getName());
            this.out.print(this.source[50]);
        }
        for (WurbletArgument par : this.getMethodArguments()) {
            Set existsRels;
            if (par.isPath() && (existsRels = par.getExistsRelations()) != null) {
                for (Relation rel : existsRels) {
                    List methodArgs = rel.getMethodArgs();
                    for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                        if (!methodArg.isValue()) continue;
                        Attribute attr = methodArg.getForeignAttribute();
                        this.out.print(this.source[51]);
                        this.out.print(this.createWhereSetPars(attr, attr.toMethodArgument(methodArg.getValue())));
                        this.out.print(this.source[52]);
                    }
                }
            }
            if (par.isValueLiterally()) continue;
            Attribute attr = par.getAttribute();
            if (par.getColumnIndex() == null) {
                this.out.print(this.source[53]);
                this.out.print(this.createWhereSetPars(attr, attr.toMethodArgument(par.getJdbcValue())));
                this.out.print(this.source[54]);
                continue;
            }
            this.out.print(this.source[55]);
            this.out.print(this.createWhereSetPars(par));
            this.out.print(this.source[56]);
        }
        this.out.print(this.source[57]);
        if (((String)classVar).length() == 0) {
            this.out.print(this.source[58]);
            this.out.print(statementId);
            this.out.print(this.source[59]);
        }
    }

    public String process(String code) {
        int ref = ((String)code).lastIndexOf("ndx");
        int pos = ((String)code).lastIndexOf("(ndx++,");
        if (pos >= 0 && ref == pos + 1) {
            code = ((String)code).substring(0, pos + 4) + ((String)code).substring(pos + 6);
        } else {
            pos = ((String)code).lastIndexOf("ndx += st.set(");
            if (pos >= 0 && ref > pos) {
                code = ((String)code).substring(0, pos) + ((String)code).substring(pos + 7);
            } else {
                pos = ((String)code).lastIndexOf(", ndx++, ");
                if (pos >= 0 && ref > pos) {
                    code = ((String)code).substring(0, pos + 5) + ((String)code).substring(pos + 7);
                }
            }
        }
        return code;
    }
}

