/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeSorting;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.SortType;
import org.tentackle.model.TrackType;
import org.tentackle.sql.DataType;
import org.tentackle.wurblet.Join;
import org.tentackle.wurblet.JoinPath;
import org.tentackle.wurblet.ModelWurblet;
import org.tentackle.wurblet.WurbletArgument;
import org.tentackle.wurblet.WurbletArgumentExpression;
import org.tentackle.wurblet.WurbletArgumentParser;
import org.wurbelizer.wurbel.WurbelException;

public class DbModelWurblet
extends ModelWurblet {
    private boolean argumentGroupingEnabled;
    private boolean pathAllowed;
    private boolean tracked;
    private boolean attracked;
    private boolean fullTracked;
    private Attribute contextAttribute;
    private List<JoinPath> joinPaths;
    private WurbletArgumentParser parser;

    public boolean isArgumentGroupingEnabled() {
        return this.argumentGroupingEnabled;
    }

    public boolean isPathAllowed() {
        return this.pathAllowed;
    }

    public void run() throws WurbelException {
        String wurbletOptions = this.getConfiguration();
        if (wurbletOptions != null) {
            if (wurbletOptions.contains("groupArgs")) {
                this.argumentGroupingEnabled = true;
            } else if (wurbletOptions.contains("pathAllowed")) {
                this.pathAllowed = true;
            }
        }
        super.run();
        Entity entity = this.getEntity();
        if (entity != null) {
            this.tracked = entity.getOptions().getTrackType().isTracked();
            this.attracked = entity.getOptions().getTrackType().isAttracked();
            this.fullTracked = entity.getOptions().getTrackType() == TrackType.FULLTRACKED;
            this.contextAttribute = entity.getContextIdAttribute();
            for (String arg : this.getOptionArgs()) {
                if ("tracked".equals(arg)) {
                    this.tracked = true;
                    this.attracked = false;
                    this.fullTracked = false;
                    continue;
                }
                if ("attracked".equals(arg)) {
                    this.tracked = true;
                    this.attracked = true;
                    this.fullTracked = false;
                    continue;
                }
                if ("fulltracked".equals(arg)) {
                    this.tracked = true;
                    this.attracked = true;
                    this.fullTracked = true;
                    continue;
                }
                if ("untracked".equals(arg)) {
                    this.tracked = false;
                    this.attracked = false;
                    this.fullTracked = false;
                    continue;
                }
                if (!arg.startsWith("context=")) continue;
                String ctx = arg.substring(8);
                if (ctx.length() == 0) {
                    this.contextAttribute = null;
                    continue;
                }
                this.contextAttribute = entity.getAttributeByJavaName(arg.substring(8), false);
            }
            this.parser = new WurbletArgumentParser(entity, this.argumentGroupingEnabled, this.getWurbletArgs());
            if (!this.pathAllowed) {
                for (String arg : this.parser.getAllArguments()) {
                    if (!arg.isPath()) continue;
                    throw new WurbelException("relation paths not allowed in wurblet " + this);
                }
            }
            if (this.isRemote()) {
                for (WurbletArgument joinArgument : this.parser.getJoinArguments()) {
                    for (Relation relation : joinArgument.getRelations()) {
                        if (!relation.isComposite() && !relation.isSerialized() && relation.getSelectionType() != SelectionType.EAGER) {
                            throw new WurbelException("joined non-composite relation '" + relation.getName() + "' must be serialized for remote access");
                        }
                        Relation opRel = relation.getForeignRelation();
                        if (opRel == null || opRel.isSerialized() || opRel.isComposite()) continue;
                        throw new WurbelException("joined opposite relation '" + opRel.getEntity() + "." + opRel.getName() + "' must be serialized for remote access");
                    }
                }
            }
        }
    }

    public boolean isTracked() {
        return this.tracked;
    }

    public boolean isAttracked() {
        return this.attracked;
    }

    public boolean isFullTracked() {
        return this.fullTracked;
    }

    public Attribute getContextAttribute() {
        return this.contextAttribute;
    }

    public boolean isClassIdRequiredInWhereClause(Entity entity) {
        return !entity.isAbstract() && entity.getSuperEntity() != null && entity.getHierarchyInheritanceType().isMappingToSuperTable();
    }

    public boolean isClassIdRequiredInWhereClause() {
        return this.isClassIdRequiredInWhereClause(this.getEntity());
    }

    public boolean isEntityPersistable() {
        return !this.getEntity().isAbstract() || !this.getEntity().getHierarchyInheritanceType().isMappingToNoTable();
    }

    public void assertEntityIsPersistable() throws WurbelException {
        if (!this.isEntityPersistable()) {
            throw new WurbelException(this.getEntity() + " does not map to any table and is not persistable");
        }
    }

    public List<WurbletArgument> getMethodArguments() {
        return this.parser.getMethodArguments();
    }

    public List<WurbletArgument> getExpressionArguments() {
        return this.parser.getExpressionArguments();
    }

    public List<WurbletArgument> getExtraArguments() {
        return this.parser.getExtraArguments();
    }

    public WurbletArgumentExpression getExpression() {
        return this.parser.getExpression();
    }

    public List<WurbletArgument> getSortingArguments() {
        return this.parser.getSortingArguments();
    }

    public boolean isWithSorting() {
        return !this.getSortingArguments().isEmpty();
    }

    public List<AttributeSorting> getDefaultSorting() {
        for (Entity entity = this.getEntity(); entity != null; entity = entity.getSuperEntity()) {
            List sorting = entity.getSorting();
            if (sorting == null || sorting.isEmpty()) continue;
            return sorting;
        }
        return null;
    }

    public List<WurbletArgument> getDefaultSortKeys() throws WurbelException {
        ArrayList<WurbletArgument> sortKeys = new ArrayList<WurbletArgument>();
        List<AttributeSorting> sorting = this.getDefaultSorting();
        if (sorting != null) {
            for (AttributeSorting as : sorting) {
                WurbletArgument key = this.parser.createArgument(as.toString(), true, false);
                sortKeys.add(key);
            }
        }
        return sortKeys;
    }

    public boolean isWithDefaultSorting() {
        return this.getDefaultSorting() != null;
    }

    public List<JoinPath> getJoinPaths() {
        if (this.joinPaths == null) {
            this.joinPaths = this.parser.getJoinPaths();
            for (JoinPath path : this.joinPaths) {
                path.normalize();
            }
        }
        return this.joinPaths;
    }

    public boolean isWithJoins() {
        return !this.getJoinPaths().isEmpty();
    }

    public String createRelopCode(WurbletArgument arg) throws WurbelException {
        if (arg.isArray()) {
            String op = arg.getArrayOperator();
            this.assertSupportedByBackends("array operator '" + op + "'", b -> b.isArrayOperatorSupported(op));
        }
        Object value = arg.getValue();
        if (arg.isValueLiterally() && !((String)value).startsWith("\"")) {
            value = "\"" + (String)value + "\"";
        }
        Object str = switch (arg.getRelop()) {
            case "=" -> {
                if (arg.isValueLiterally()) {
                    yield "Backend.SQL_EQUAL).append(" + (String)value;
                }
                yield arg.isArray() ? "Backend.SQL_EQUAL" : "Backend.SQL_EQUAL_PAR";
            }
            case "<>", "!=" -> {
                if (arg.isValueLiterally()) {
                    yield "Backend.SQL_NOTEQUAL).append(" + (String)value;
                }
                yield arg.isArray() ? "Backend.SQL_NOTEQUAL" : "Backend.SQL_NOTEQUAL_PAR";
            }
            case "<" -> {
                if (arg.isValueLiterally()) {
                    yield "Backend.SQL_LESS).append(" + (String)value;
                }
                yield arg.isArray() ? "Backend.SQL_LESS" : "Backend.SQL_LESS_PAR";
            }
            case ">" -> {
                if (arg.isValueLiterally()) {
                    yield "Backend.SQL_GREATER).append(" + (String)value;
                }
                yield arg.isArray() ? "Backend.SQL_GREATER" : "Backend.SQL_GREATER_PAR";
            }
            case "<=" -> {
                if (arg.isValueLiterally()) {
                    yield "Backend.SQL_LESSOREQUAL).append(" + (String)value;
                }
                yield arg.isArray() ? "Backend.SQL_LESSOREQUAL" : "Backend.SQL_LESSOREQUAL_PAR";
            }
            case ">=" -> {
                if (arg.isValueLiterally()) {
                    yield "Backend.SQL_GREATEROREQUAL).append(" + (String)value;
                }
                yield arg.isArray() ? "Backend.SQL_GREATEROREQUAL" : "Backend.SQL_GREATEROREQUAL_PAR";
            }
            case " LIKE " -> {
                if (arg.isValueLiterally()) {
                    yield "Backend.SQL_LIKE).append(" + (String)value;
                }
                yield "Backend.SQL_LIKE_PAR";
            }
            case " NOT LIKE " -> {
                if (arg.isValueLiterally()) {
                    yield "Backend.SQL_NOTLIKE).append(" + (String)value;
                }
                yield "Backend.SQL_NOTLIKE_PAR";
            }
            case " IS NULL" -> "Backend.SQL_ISNULL";
            case " IS NOT NULL" -> "Backend.SQL_ISNOTNULL";
            default -> arg.isArray() ? "" : "\"" + arg.getRelop() + (String)(arg.isValueLiterally() ? value : "?") + "\"";
        };
        if (!((String)str).isEmpty()) {
            str = ".append(" + (String)str + ")";
        }
        if (arg.isArray()) {
            switch (arg.getArrayOperator()) {
                case "ANY": {
                    str = (String)str + ".append(Backend.SQL_ARRAY_ANY_PAR)";
                    break;
                }
                case "ALL": {
                    str = (String)str + ".append(Backend.SQL_ARRAY_ALL_PAR)";
                    break;
                }
                case "NOT IN": {
                    str = ".append(Backend.SQL_ARRAY_NOT_IN_PAR)";
                    break;
                }
                default: {
                    str = ".append(Backend.SQL_ARRAY_IN_PAR)";
                }
            }
        }
        return str;
    }

    public String createOrderBy(List<WurbletArgument> sortKeys) throws WurbelException {
        if (!sortKeys.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            boolean needComma = false;
            for (WurbletArgument key : sortKeys) {
                Attribute attr = key.getAttribute();
                for (int columnIndex = 0; columnIndex < this.getEffectiveDataType(attr).getColumnCount(); ++columnIndex) {
                    if (needComma) {
                        buf.append("\n           .append(Backend.SQL_COMMA)");
                    }
                    String name = this.getColumnNameConstant(attr, columnIndex);
                    buf.append(".append(");
                    if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                        buf.append(this.deriveClassNameForEntity(this.getEntity().getTopSuperEntity())).append(".CLASSVARIABLES.getColumnName(").append(name).append(')');
                    } else if (!this.getEntity().equals(attr.getEntity())) {
                        boolean joinFound = false;
                        for (JoinPath joinPath : this.getJoinPaths()) {
                            Join join = joinPath.findJoin(key.getRelations());
                            if (join == null) continue;
                            buf.append('\"').append(join.getName()).append('.').append(attr.getColumnName()).append('\"');
                            joinFound = true;
                            break;
                        }
                        if (!joinFound) {
                            throw new WurbelException("missing join for sort key: " + key);
                        }
                    } else if (this.isPdo()) {
                        buf.append("getColumnName(").append(name).append(')');
                    } else {
                        buf.append(name);
                    }
                    buf.append(").append(").append(SortType.ASC == key.getSortType() ? "Backend.SQL_SORTASC" : "Backend.SQL_SORTDESC").append(')');
                    needComma = true;
                }
            }
            return buf.toString();
        }
        return null;
    }

    public String createOrderBy() throws WurbelException {
        return this.createOrderBy(this.getSortingArguments());
    }

    public String createJoins() throws WurbelException {
        StringBuilder buf = new StringBuilder();
        String pdoType = this.getPdoClassName();
        if (this.isGenerified()) {
            pdoType = "T";
        }
        buf.append("    JoinedSelect<").append(pdoType).append("> js = new JoinedSelect<").append(pdoType).append(">()\n");
        this.createJoinsImpl(buf, "      ", this.getJoinPaths(), pdoType, null);
        buf.replace(buf.length() - 1, buf.length(), ";\n");
        return buf.toString();
    }

    private void createJoinsImpl(StringBuilder buf, String inset, List<JoinPath> paths, String pdoType, String parentName) throws WurbelException {
        for (JoinPath path : paths) {
            List subPaths;
            String lastJoinName = null;
            if (!path.getElements().isEmpty()) {
                Join join = (Join)path.getElements().get(0);
                Relation relation = join.getRelation();
                lastJoinName = join.getName();
                String poImpl = this.deriveClassNameForEntity(relation.getEntity());
                String alias = relation.getEntity().getTopSuperEntity().getTableAlias();
                String leftClass = relation.getEntity().equals(this.getEntity()) ? pdoType : relation.getEntity().getName();
                String joinClass = relation.getForeignEntity().getName();
                String joinAlias = relation.getForeignEntity().getTableProvidingEntity().getTableAlias();
                buf.append(inset).append(".addJoin(\n");
                if (relation.getRelationType() == RelationType.LIST) {
                    buf.append(inset).append("  new Join<>(JoinType.LEFT, ");
                    if (parentName == null) {
                        buf.append("getColumnName(CN_ID), \"");
                    } else {
                        buf.append('\"').append(parentName).append(".id\", \"");
                    }
                    buf.append(join.getName()).append('.').append(relation.getForeignAttribute().getColumnName()).append("\", ").append(joinClass).append(".class, \"").append(join.getName()).append("\",\n");
                    String extraSql = this.createOptionalWhereForJoin(relation, parentName, join.getName());
                    if (!extraSql.isEmpty()) {
                        buf.append(inset).append("             ").append(extraSql).append(",\n");
                    }
                    buf.append(inset).append("    (").append(leftClass).append(" ").append(alias).append(", ").append(joinClass).append(" ").append(joinAlias).append(") -> {\n");
                    if (relation.isReversed()) {
                        buf.append(inset).append("      ((").append(poImpl).append(") ").append(alias).append(".getPersistenceDelegate()).").append(relation.getSetterName());
                        if (relation.isSerialized()) {
                            buf.append("Blunt");
                        }
                        buf.append("(").append(joinAlias).append(");\n");
                    } else {
                        buf.append(inset).append("      ((").append(poImpl).append(") ").append(alias).append(".getPersistenceDelegate()).").append(relation.getGetterName()).append("Blunt().addBlunt(").append(joinAlias).append(");\n");
                        if (relation.getLinkMethodName() != null) {
                            String joinImpl = this.deriveClassNameForEntity(relation.getForeignEntity());
                            buf.append(inset).append("      ((").append(joinImpl).append(") ").append(joinAlias).append(".getPersistenceDelegate()).").append(this.createRelationUpdateReferenceCode(relation, alias, true)).append(";\n");
                        }
                    }
                } else {
                    buf.append(inset).append("  new Join<>(JoinType.LEFT, ");
                    if (parentName == null) {
                        buf.append("getColumnName(CN_").append(relation.getAttribute().getName().toUpperCase()).append("), \"");
                    } else {
                        buf.append('\"').append(parentName).append('.').append(relation.getAttribute().getColumnName()).append("\", \"");
                    }
                    buf.append(join.getName()).append(".id\", ").append(joinClass).append(".class, \"").append(join.getName()).append("\",\n").append(inset).append("    (").append(leftClass).append(" ").append(alias).append(", ").append(joinClass).append(" ").append(joinAlias).append(") -> {\n").append(inset).append("      ((").append(poImpl).append(") ").append(alias).append(".getPersistenceDelegate()).").append(relation.getSetterName());
                    if (relation.isSerialized()) {
                        buf.append("Blunt");
                    }
                    buf.append("(").append(joinAlias).append(");\n");
                }
                buf.append(inset).append("    }\n").append(inset).append("  )\n");
            }
            if (!(subPaths = path.getPaths()).isEmpty()) {
                Entity subEntity = ((Join)((JoinPath)subPaths.get(0)).getElements().get(0)).getRelation().getEntity();
                this.createJoinsImpl(buf, inset + "  ", subPaths, subEntity.getName(), lastJoinName);
            }
            buf.append(inset).append(")\n");
        }
    }

    private String createOptionalWhereForJoin(Relation relation, String parentName, String joinName) throws WurbelException {
        StringBuilder buf = new StringBuilder();
        List methodArgs = relation.getMethodArgs();
        if (methodArgs.size() > 1) {
            for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                Attribute attr = methodArg.getForeignAttribute();
                buf.append("\" AND ").append(joinName).append('.').append(attr.getColumnName()).append('=');
                if (methodArg.isValue()) {
                    buf.append('?');
                    for (int columnIndex = 1; columnIndex < this.getEffectiveDataType(attr).getColumnCount(); ++columnIndex) {
                        buf.append(" AND ").append(joinName).append('.').append(this.getColumnName(attr, columnIndex)).append("=?");
                    }
                    buf.append('\"');
                    continue;
                }
                attr = methodArg.getAttribute();
                if (parentName == null) {
                    buf.append("\" + getColumnName(").append(this.getColumnNameConstant(attr, 0)).append(")");
                    continue;
                }
                buf.append('\"').append(parentName).append('.').append(attr.getColumnName()).append("\"");
            }
        }
        return buf.toString();
    }

    public String createWhereSetPars(WurbletArgument arg) throws WurbelException, ModelException {
        Attribute attr = arg.getAttribute();
        int columnIndex = 0;
        if (arg.isArray()) {
            String javaType;
            if (attr.isConvertible()) {
                javaType = attr.getInnerTypeName();
                columnIndex = -1;
            } else {
                javaType = attr.getDataType().toNonPrimitive().getJavaType();
                if (arg.getColumnIndex() != null) {
                    columnIndex = arg.getColumnIndex();
                }
            }
            return "st.setArray(ndx++, " + javaType + ".class, " + columnIndex + ", " + attr.toMethodArgument(arg.getJdbcValue()) + ", Backend.SQL_ARRAY_" + arg.getArrayOperator().replace(' ', '_') + ")";
        }
        if (arg.getColumnIndex() == null) {
            return this.createWhereSetPars(attr, attr.toMethodArgument(arg.getJdbcValue()));
        }
        columnIndex = arg.getColumnIndex();
        StringBuilder buf = new StringBuilder();
        if (arg.getDataType().isPredefined()) {
            buf.append("st.set(SqlType.").append(arg.getDataType().getSqlType(columnIndex)).append(", ndx++, ").append(arg.getJdbcValue());
            if (arg.isMethodArgument()) {
                buf.append(".").append(arg.getDataType().getColumnGetter(columnIndex)).append("()");
            }
            buf.append(")");
        } else {
            buf.append("ndx += st.set(");
            if (!attr.getEntity().equals(this.getEntity())) {
                buf.append(this.deriveClassNameForEntity(attr.getEntity())).append('.');
            }
            buf.append(arg.getDataType().getDataTypeConstant()).append(", ndx, ").append(arg.getJdbcValue()).append(", ").append(columnIndex).append(", ").append(attr.getOptions().isMapNull()).append(", ").append(attr.getSize()).append(")");
        }
        return buf.toString();
    }

    public String createWhereSetPars(Attribute attr, String argument) throws WurbelException {
        StringBuilder buf = new StringBuilder();
        DataType dataType = this.getEffectiveDataType(attr);
        if (dataType.isPredefined()) {
            buf.append("st.").append(this.createJdbcSetterName(dataType)).append("(ndx++, ").append(this.getJdbcCode(attr, argument));
            if (attr.getOptions().isMapNull()) {
                buf.append(", true)");
            } else {
                buf.append(")");
            }
            int diff = dataType.getColumnCount() - 1;
            if (diff == 1) {
                buf.append(";\n    ndx++");
            } else if (diff > 1) {
                buf.append(";\n    ndx += ").append(diff);
            }
        } else {
            buf.append("ndx += st.set(");
            if (!attr.getEntity().equals(this.getEntity())) {
                buf.append(this.deriveClassNameForEntity(attr.getEntity())).append('.');
            }
            buf.append(dataType.getDataTypeConstant()).append(", ndx, ").append(this.getJdbcCode(attr, argument)).append(", ").append(attr.getOptions().isMapNull()).append(", ").append(attr.getSize()).append(")");
        }
        return buf.toString();
    }

    public String createJoinSetPars() throws WurbelException, ModelException {
        StringBuilder buf = new StringBuilder();
        for (JoinPath path : this.getJoinPaths()) {
            this.createJoinSetPars(buf, path);
        }
        return buf.toString();
    }

    private void createJoinSetPars(StringBuilder buf, JoinPath path) throws WurbelException, ModelException {
        if (!path.getElements().isEmpty()) {
            List methodArgs;
            Join join = (Join)path.getElements().get(0);
            Relation relation = join.getRelation();
            if (this.isClassIdRequiredInWhereClause(relation.getForeignEntity())) {
                buf.append("    st.setInt(ndx++, ").append(relation.getForeignEntity().getClassId()).append(");\n");
            }
            if ((methodArgs = relation.getMethodArgs()).size() > 1) {
                for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                    if (!methodArg.isValue()) continue;
                    Attribute attr = methodArg.getForeignAttribute();
                    buf.append("    ").append(this.createWhereSetPars(attr, attr.toMethodArgument(methodArg.getValue()))).append(";\n");
                }
            }
            for (JoinPath subPath : path.getPaths()) {
                this.createJoinSetPars(buf, subPath);
            }
        }
    }

    public String createStatementId() throws WurbelException {
        StringBuilder buf = new StringBuilder();
        String id = this.getGuardName();
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isUpperCase(c) && buf.length() > 0) {
                buf.append('_');
            }
            buf.append(Character.toUpperCase(c));
        }
        buf.append("_STMT");
        return buf.toString();
    }

    public String buildMethodParameters(boolean limit, boolean offset) throws WurbelException {
        StringBuilder params = new StringBuilder();
        if (limit) {
            this.appendCommaSeparated(params, "int limit");
        }
        if (offset) {
            this.appendCommaSeparated(params, "int offset");
        }
        HashSet<String> argSet = new HashSet<String>();
        for (WurbletArgument key : this.getMethodArguments()) {
            String arg;
            if (!key.isMethodArgument() || !argSet.add(arg = key.getMethodArgumentName())) continue;
            Attribute attr = key.getAttribute();
            try {
                Object javaType;
                if (key.isArray()) {
                    String elementType = attr.isConvertible() ? attr.getApplicationTypeName() : attr.getDataType().toNonPrimitive().getJavaType();
                    javaType = "Collection<" + elementType + ">";
                } else {
                    javaType = attr.getJavaType();
                }
                this.appendCommaSeparated(params, (String)javaType);
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java type for key " + key, (Throwable)me);
            }
            params.append(' ');
            params.append(arg);
        }
        return params.toString();
    }

    public String buildMethodParameters() throws WurbelException {
        return this.buildMethodParameters(false, false);
    }

    public String buildInvocationParameters(boolean limit, boolean offset) throws WurbelException {
        StringBuilder params = new StringBuilder();
        if (limit) {
            this.appendCommaSeparated(params, "limit");
        }
        if (offset) {
            this.appendCommaSeparated(params, "offset");
        }
        HashSet<String> argSet = new HashSet<String>();
        for (WurbletArgument key : this.getMethodArguments()) {
            String arg;
            if (!key.isMethodArgument() || !argSet.add(arg = key.getMethodArgumentName())) continue;
            this.appendCommaSeparated(params, arg);
        }
        return params.toString();
    }

    public boolean isPdoProvidingArguments() {
        for (WurbletArgument key : this.getMethodArguments()) {
            String arg;
            if (key.isMethodArgument() || key.isValueLiterally() || (arg = key.getValue()) == null || !arg.endsWith("()")) continue;
            return true;
        }
        return false;
    }

    public String buildInvocationParameters() throws WurbelException {
        return this.buildInvocationParameters(false, false);
    }

    public String acs(String str, String appendStr) {
        StringBuilder builder = new StringBuilder(str);
        this.appendCommaSeparated(builder, appendStr);
        return builder.toString();
    }

    public String pcs(String str, String prependStr) {
        StringBuilder builder = new StringBuilder(str);
        this.prependCommaSeparated(builder, prependStr);
        return builder.toString();
    }

    public String aas(String str) {
        if (str != null && str.length() > 0) {
            return ", " + str;
        }
        return "";
    }

    public String as(String str) {
        return str == null ? "" : str;
    }

    public String createJdbcSetterName(DataType<?> dataType) {
        StringBuilder buf = new StringBuilder("set");
        if (dataType.isPrimitive()) {
            buf.append(StringHelper.firstToUpper((String)dataType.getJavaType()));
        } else if ("String".equals(dataType.getJavaType()) && "Large".equals(dataType.getVariant())) {
            buf.append("LargeString");
        } else {
            buf.append(dataType.getJavaType());
        }
        return buf.toString();
    }

    public String createJdbcGetterName(Attribute attribute) throws WurbelException {
        StringBuilder buf = new StringBuilder("get");
        DataType dataType = this.getEffectiveDataType(attribute);
        if (dataType.isPrimitive()) {
            buf.append(StringHelper.firstToUpper((String)dataType.getJavaType()));
        } else {
            switch (dataType.getJavaType()) {
                case "Boolean": 
                case "Byte": 
                case "Short": 
                case "Long": 
                case "Float": 
                case "Double": {
                    buf.append('A');
                    break;
                }
                case "String": {
                    if (!"Large".equals(dataType.getVariant())) break;
                    buf.append("Large");
                }
            }
            buf.append(dataType.getJavaType());
        }
        return buf.toString();
    }

    public String getModelCode(Attribute attribute, String jdbcCode) throws WurbelException {
        if (attribute.isConvertible()) {
            try {
                return attribute.getJavaType() + ".toInternal(" + jdbcCode + ")";
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java model-side code for " + attribute + ": " + jdbcCode, (Throwable)me);
            }
        }
        return jdbcCode;
    }

    public String getJdbcCode(Attribute attribute, String modelCode) throws WurbelException {
        Object jdbcCode = modelCode;
        if (attribute.isConvertible()) {
            try {
                String applicationType = attribute.getApplicationTypeName();
                jdbcCode = modelCode.startsWith(applicationType + ".") ? modelCode + ".toExternal()" : (attribute.getInnerDataType().isPrimitive() ? modelCode + " == null ? " + applicationType + ".getDefault().toExternal() : " + modelCode + ".toExternal()" : modelCode + " == null ? null : " + modelCode + ".toExternal()");
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java jdbc-side code for " + attribute + ": " + modelCode, (Throwable)me);
            }
        }
        return jdbcCode;
    }

    public boolean isRelationTransient(Relation relation) {
        return relation.getSelectionType() == SelectionType.LAZY && !relation.isComposite() && !relation.isSerialized();
    }

    public String createRelationArgString(Relation relation) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        List args = relation.getMethodArgs();
        boolean first = true;
        for (MethodArgument arg : args) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(arg.getMethodArgument());
        }
        buf.append(')');
        return buf.toString();
    }

    public String createRelationWurbletArgString(Relation relation) {
        StringBuilder buf = new StringBuilder();
        List args = relation.getMethodArgs();
        for (MethodArgument arg : args) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(arg.getForeignAttribute().getName());
        }
        return buf.toString();
    }

    public String createRelationSelectCode(Relation relation) {
        StringBuilder text = new StringBuilder();
        if (relation.getForeignEntity().isAbstract() && relation.getRelationType() == RelationType.OBJECT && relation.getMethodName() == null) {
            text.append("(").append(relation.getClassName()).append("<?>) ");
        }
        text.append("on(").append(relation.getClassName()).append(".class).").append(this.createRelationSelectMethodName(relation)).append(this.createRelationArgString(relation));
        return text.toString();
    }

    public String createRelationUpdateReferenceCode(Relation relation, String pdo, boolean blunt) {
        Relation foreignRel = relation.getForeignRelation();
        if (blunt && (foreignRel == null || foreignRel.getRelationType() != RelationType.OBJECT || !foreignRel.isSerialized() || foreignRel.getSelectionType() != SelectionType.LAZY && foreignRel.getSelectionType() != SelectionType.EAGER)) {
            blunt = false;
        }
        if (!blunt && relation.getLinkMethodName() != null) {
            return relation.getLinkMethodName() + (relation.getLinkMethodIndex() != null ? "(" + pdo + ", ndx++)" : "(" + pdo + ")");
        }
        if (foreignRel != null) {
            return foreignRel.getSetterName() + (blunt ? "Blunt" : "") + "(" + pdo + ")";
        }
        return "set" + relation.getForeignEntity() + "(" + pdo + ")";
    }

    public String createRelationUpdateReferenceCode(Relation relation) {
        return this.createRelationUpdateReferenceCode(relation, "me()", false);
    }

    public String createRelationSetFirstArgMethodName(Relation relation) throws WurbelException {
        if (relation.getMethodArgs().size() > 1) {
            throw new WurbelException("more than one method argument in relation " + relation);
        }
        MethodArgument methodArg = (MethodArgument)relation.getMethodArgs().get(0);
        Attribute attribute = methodArg.getAttribute();
        if (attribute == null) {
            throw new WurbelException("missing attribute for method argument " + methodArg + " in relation " + relation);
        }
        return "set" + StringHelper.firstToUpper((String)attribute.getName());
    }

    public String createRelationDeleteCode(Relation relation) {
        return "on(" + relation.getClassName() + ".class)." + this.createListRelationDeleteMethodName(relation) + this.createRelationArgString(relation);
    }

    public String createRelationLinkCode(Relation relation) {
        if (relation.getLinkMethodName() != null) {
            return relation.getLinkMethodName() + (relation.getLinkMethodIndex() != null ? "(me(), ndx++)" : "(me())");
        }
        Object text = "set";
        text = relation.getMethodName() != null ? (String)text + relation.getMethodName() : (String)text + relation.getEntity().getName() + "Id";
        return (String)text + this.createRelationArgString(relation);
    }

    public List<Relation> getEagerRelations() {
        ArrayList<Relation> eagerRelations = new ArrayList<Relation>();
        block0: for (Relation relation : this.getEntity().getRelations()) {
            if (relation.getSelectionType() != SelectionType.EAGER) continue;
            for (Relation rel : this.getEntity().getSubEntityRelations()) {
                if (rel.getSelectionType() != SelectionType.EAGER) continue;
                break block0;
            }
            for (Entity component : relation.getForeignEntity().getComponentsIncludingInherited()) {
                for (Relation rel : component.getAllRelations()) {
                    if (rel.getSelectionType() != SelectionType.EAGER) continue;
                    break block0;
                }
            }
            eagerRelations.add(relation);
        }
        return eagerRelations.isEmpty() ? null : eagerRelations;
    }
}

