/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Entity;
import org.tentackle.wurblet.ModelWurblet;
import org.wurbelizer.wurbel.HeapStream;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurbel.Wurbler;

public class RemoteIncludes {
    private final Wurbler container;
    private final Entity entity;
    private final String className;
    private final String packageName;
    private final String superClassName;
    private final String type;
    private final boolean isOperation;
    private final String remotePrefixBasename;
    private final HeapStream remoteStream;
    private final HeapStream implStream;
    private String pdoClassName;
    private String pdoPackageName;
    private String rmiDirName;
    private String remotePrefix;
    private boolean importSuperDelegate;

    public RemoteIncludes(ModelWurblet wurblet) throws WurbelException {
        int ndx;
        this.container = wurblet.getContainer();
        this.className = wurblet.getClassName();
        this.entity = wurblet.getEntity();
        this.superClassName = StringHelper.getPlainClassName((String)wurblet.getSuperClassName());
        this.packageName = wurblet.getPackageName();
        this.remotePrefix = this.container.getProperty("extra", "remoteprefix");
        try {
            this.pdoClassName = wurblet.getPdoClassName();
        }
        catch (WurbelException wurbelException) {
            // empty catch block
        }
        if (this.remotePrefix == null) {
            this.pdoPackageName = this.packageName.replace(".persistence.", ".pdo.").replace(".persist.", ".pdo.");
            switch (this.superClassName) {
                case "AbstractPersistentObject": {
                    this.remotePrefix = "org.tentackle.persist.rmi." + this.superClassName;
                    this.importSuperDelegate = true;
                    break;
                }
                case "AbstractDbObject": {
                    this.remotePrefix = "org.tentackle.dbms.rmi." + this.superClassName;
                    this.importSuperDelegate = true;
                    break;
                }
                default: {
                    String tail;
                    this.remotePrefix = this.superClassName;
                    if (this.pdoClassName == null || !this.className.startsWith(this.pdoClassName) || (tail = this.className.substring(this.pdoClassName.length())).length() <= 0 || !this.remotePrefix.endsWith(tail)) break;
                    this.remotePrefix = this.remotePrefix.substring(0, this.remotePrefix.length() - tail.length());
                }
            }
        }
        this.remotePrefixBasename = (ndx = this.remotePrefix.lastIndexOf(46)) < 0 ? this.remotePrefix : this.remotePrefix.substring(ndx + 1);
        this.isOperation = this.remotePrefix.endsWith("Operation");
        this.type = this.isOperation ? "operation" : (this.pdoClassName != null ? "pdo" : "object");
        this.rmiDirName = this.container.getProperty("wurblet", "dirname");
        this.rmiDirName = this.rmiDirName + "/rmi";
        String remoteName = (this.pdoClassName != null ? this.pdoClassName : this.className) + "RemoteDelegate";
        this.remoteStream = new HeapStream(this.container, remoteName + "/methods");
        this.checkFile(remoteName, false);
        this.implStream = new HeapStream(this.container, remoteName + "Impl/methods");
        this.checkFile(remoteName, true);
    }

    public void discard() {
        this.implStream.discard();
        this.remoteStream.discard();
    }

    private boolean isAbstract() {
        return this.entity != null && this.entity.isAbstract();
    }

    private void checkFile(String name, boolean impl) throws WurbelException {
        block33: {
            new File(this.rmiDirName).mkdirs();
            String fileName = name + (impl ? "Impl" : "") + ".java";
            String pathName = this.rmiDirName + "/" + fileName;
            File file = new File(pathName);
            if (!file.exists()) {
                if (this.pdoClassName != null) {
                    try (PrintStream s = new PrintStream(file);){
                        s.println("/*\n * " + fileName + " (generated " + new Date() + ")\n */\n\npackage " + this.packageName + ".rmi;\n\nimport " + this.pdoPackageName + "." + this.pdoClassName + ";\nimport " + this.packageName + "." + this.className + ";\nimport java.rmi.RemoteException;\nimport java.util.List;\nimport org.tentackle.common.BMoney;\nimport org.tentackle.common.Binary;\nimport org.tentackle.common.DMoney;\nimport org.tentackle.common.Date;\nimport org.tentackle.common.Time;\nimport org.tentackle.common.Timestamp;\nimport org.tentackle.misc.TrackedList;\nimport org.tentackle.persist.rmi.RemoteResultSetCursor;");
                        s.println("import org.tentackle.pdo.DomainContext;");
                        if (impl) {
                            if (this.importSuperDelegate) {
                                s.println("import " + this.remotePrefix + "RemoteDelegateImpl;");
                            }
                            s.println("import org.tentackle.dbms.rmi.RemoteDbSessionImpl;\n\n");
                            s.println("/**");
                            s.println(" * Remote delegate implementation for {@link " + this.className + "}.");
                            if (this.isAbstract()) {
                                s.println(" * ");
                                s.println(" * @param <T> the " + this.type + " interface");
                                s.println(" * @param <P> the persistence implementation");
                            }
                            s.println(" */");
                            if (this.isAbstract()) {
                                s.println("public class " + name + "Impl<T extends " + this.pdoClassName + "<T>, P extends " + this.className + "<T,P>>");
                                s.println("       extends " + this.remotePrefixBasename + "RemoteDelegateImpl<T,P>");
                                s.println("       implements " + name + "<T,P>  {\n\n");
                            } else {
                                s.println("public class " + name + "Impl");
                                s.println("       extends " + this.remotePrefixBasename + "RemoteDelegateImpl<" + this.pdoClassName + "," + this.className + ">");
                                s.println("       implements " + name + " {\n\n");
                            }
                            s.println("  /**");
                            s.println("   * Creates the remote delegate for {@link " + this.className + "}.");
                            s.println("   *");
                            s.println("   * @param session the RMI session");
                            s.println("   * @param persistenceClass the persistence implementation class");
                            s.println("   * @param " + this.type + "Class the " + this.type + " interface class");
                            s.println("   */");
                            if (this.isAbstract()) {
                                s.println("  public " + name + "Impl(RemoteDbSessionImpl session, Class<P> persistenceClass, Class<T> " + this.type + "Class) {");
                            } else {
                                s.println("  public " + name + "Impl(RemoteDbSessionImpl session, Class<" + this.className + "> persistenceClass, Class<" + this.pdoClassName + "> " + this.type + "Class) {");
                            }
                            s.println("    super(session, persistenceClass, " + this.type + "Class);");
                            s.println("  }");
                        } else {
                            if (this.importSuperDelegate) {
                                s.println("import " + this.remotePrefix + "RemoteDelegate;");
                            }
                            s.println("\n\n/**");
                            s.println(" * Remote delegate for {@link " + this.className + "}.");
                            if (this.isAbstract()) {
                                s.println(" * ");
                                s.println(" * @param <T> the " + this.type + " interface");
                                s.println(" * @param <P> the persistence implementation");
                            }
                            s.println(" */");
                            if (this.isAbstract()) {
                                s.println("public interface " + name + "<T extends " + this.pdoClassName + "<T>, P extends " + this.className + "<T,P>>");
                                s.println("       extends " + this.remotePrefixBasename + "RemoteDelegate<T,P> {\n");
                            } else {
                                s.println("public interface " + name);
                                s.println("       extends " + this.remotePrefixBasename + "RemoteDelegate<" + this.pdoClassName + "," + this.className + "> {\n");
                            }
                        }
                        s.println("\n  // @wurblet inclrmi Include --missingok .$classname/methods\n}");
                        break block33;
                    }
                    catch (IOException ex) {
                        throw new WurbelException("printing to " + pathName + " failed", (Throwable)ex);
                    }
                }
                if (this.superClassName != null && this.superClassName.equals("AbstractDbObject")) {
                    try (PrintStream s = new PrintStream(file);){
                        s.println("/*\n * " + fileName + " (generated " + new Date() + ")\n */\n\npackage " + this.packageName + ".rmi;\n\nimport " + this.packageName + "." + this.className + ";\nimport java.rmi.RemoteException;\nimport java.util.List;\nimport org.tentackle.persist.AbstractDbObject;\nimport org.tentackle.misc.TrackedList;");
                        if (impl) {
                            if (this.importSuperDelegate) {
                                s.println("import " + this.remotePrefix + "RemoteDelegateImpl;");
                            }
                            s.println("import org.tentackle.persist.rmi.RemoteDbSessionImpl;\n\n");
                            s.println("/**");
                            s.println(" * Remote delegate implementation for {@link " + this.className + "}.");
                            s.println(" * ");
                            s.println(" * @param <P> the persistence implementation");
                            s.println(" */");
                            s.println("public class " + name + "Impl<P extends " + this.className + ">");
                            s.println("             extends " + this.remotePrefixBasename + "RemoteDelegateImpl<P>");
                            s.println("             implements " + name + "<P>  {\n\n");
                            s.println("  /**");
                            s.println("   * Creates the remote delegate for {@link " + this.className + "}.");
                            s.println("   *");
                            s.println("   * @param session the RMI session");
                            s.println("   * @param persistenceClass the persistence implementation class");
                            s.println("   */");
                            s.println("  public " + name + "Impl(RemoteDbSessionImpl session, Class<P> persistenceClass) {");
                            s.println("    super(session, persistenceClass);");
                            s.println("  }");
                        } else {
                            if (this.importSuperDelegate) {
                                s.println("import " + this.remotePrefix + "RemoteDelegate;");
                            }
                            s.println("\n\n/**");
                            s.println(" * Remote delegate for {@link " + this.className + "}.");
                            s.println(" * ");
                            s.println(" * @param <P> the persistence implementation");
                            s.println(" */");
                            s.println("public interface " + name + "<P extends " + this.className + ">");
                            s.println("       extends " + this.remotePrefixBasename + "RemoteDelegate<P> {\n");
                        }
                        s.println("\n  // @wurblet inclrmi Include --missingok .$classname/methods\n}");
                        break block33;
                    }
                    catch (IOException ex) {
                        throw new WurbelException("printing to " + pathName + " failed", (Throwable)ex);
                    }
                }
                this.container.getLogger().warning(pathName + " cannot be generated because " + this.type + " class is unknown (missing service annotation?)");
            }
        }
    }

    public void appendRemote(String text) {
        this.remoteStream.append(text);
    }

    public void appendImpl(String text) {
        this.implStream.append(text);
    }

    public PrintStream getRemoteStream() {
        return this.remoteStream.getStream();
    }

    public PrintStream getImplStream() {
        return this.implStream.getStream();
    }
}

