/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.PrintStream;
import java.util.List;
import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.persist.wurblet.ComponentJoin;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.WurbletParameter;
import org.tentackle.wurblet.WurbletParameterExpression;
import org.tentackle.wurblet.WurbletParameterOperator;
import org.wurbelizer.wurbel.WurbelException;

public class PdoSelectList
extends DbModelWurblet {
    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            String orderByStr;
            String varListType;
            String listType;
            String pdoName;
            this.assertEntityIsPersistable();
            if (!this.getExtraParameters().isEmpty()) {
                String msg = "unexpected extra parameters:";
                for (WurbletParameter par : this.getExtraParameters()) {
                    msg = msg + " " + par;
                }
                throw new WurbelException(msg);
            }
            String className = this.getClassName();
            String methodName = this.getMethodName();
            String pdoType = pdoName = this.getPdoClassName();
            String poType = className;
            if (this.isGenerified()) {
                pdoType = "T";
                poType = "P";
            }
            boolean sort = false;
            boolean lock = false;
            String append = null;
            boolean limit = false;
            boolean offset = false;
            boolean bounded = false;
            String cursor = null;
            boolean resultSet = false;
            boolean noif = false;
            String scope = "public";
            for (String arg : this.getOptionArgs()) {
                if (arg.equals("private")) {
                    scope = "private";
                    continue;
                }
                if (arg.equals("sort")) {
                    if (this.isWithDefaultSorting()) {
                        if (this.isWithSorting()) {
                            throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
                        }
                        sort = true;
                        continue;
                    }
                    throw new WurbelException("no sorting configured in model for " + this.getEntity());
                }
                if (arg.equals("noif")) {
                    noif = true;
                    continue;
                }
                if (arg.equals("lock")) {
                    lock = true;
                    continue;
                }
                if (arg.equals("limit")) {
                    limit = true;
                    continue;
                }
                if (arg.equals("offset")) {
                    offset = true;
                    continue;
                }
                if (arg.equals("bounded")) {
                    bounded = true;
                    continue;
                }
                if (arg.equals("resultset")) {
                    resultSet = true;
                    continue;
                }
                if (arg.equals("cursor")) {
                    cursor = "ScrollableResource<" + pdoName + ">";
                    continue;
                }
                if (!arg.startsWith("append=")) continue;
                append = arg.substring(7);
            }
            if (scope.equals("private")) {
                this.setRemote(false);
                noif = true;
            }
            if (resultSet) {
                this.setRemote(false);
            }
            if (cursor != null) {
                List sortKeys;
                if (resultSet) {
                    throw new WurbelException("resultset not allowed with cursor");
                }
                if (this.isTracked()) {
                    throw new WurbelException("tracked not available with cursors!");
                }
                if (!(this.getJoins().isEmpty() || !(sortKeys = this.getSortingParameters()).isEmpty() && ((WurbletParameter)sortKeys.get(0)).getAttribute().getColumnName().equals("id"))) {
                    throw new WurbelException("cursors with joins must be sorted by ID");
                }
            }
            String params = this.buildMethodParameters(limit, offset);
            String iparms = this.buildInvocationParameters(limit, offset);
            String statementId = this.createStatementId();
            String reflMethod = this.getGuardName() + "Method";
            String poImpl = this.deriveClassNameForEntity(this.getEntity());
            String string = resultSet ? "ResultSetWrapper" : (cursor != null ? "ScrollableResource<" + (bounded ? "? extends " : "") + pdoType + ">" : (listType = (this.isTracked() ? "TrackedList" : "List") + "<" + (bounded ? "? extends " : "") + pdoType + ">"));
            String string2 = cursor != null ? cursor : (varListType = (this.isTracked() ? "TrackedList" : "List") + "<" + pdoType + ">");
            String rmiListType = cursor != null ? cursor : (this.isTracked() ? "TrackedList" : "List") + "<" + (bounded ? "? extends " : "") + pdoType + ">";
            final boolean whereWithAliases = true;
            String alias = this.getEntity().getTopSuperEntity().getTableAlias();
            this.out.print(this.source[0]);
            this.out.print(statementId);
            this.out.print(this.source[1]);
            if (!noif) {
                this.out.print(this.source[2]);
            }
            this.out.print(this.source[3]);
            this.out.print(scope);
            this.out.print(this.source[4]);
            this.out.print(listType);
            this.out.print(this.source[5]);
            this.out.print(methodName);
            this.out.print(this.source[6]);
            this.out.print(this.as(params));
            this.out.print(this.source[7]);
            if (this.isRemote()) {
                RemoteIncludes genInc = new RemoteIncludes(this);
                PrintStream implOut = genInc.getImplStream();
                PrintStream remoteOut = genInc.getRemoteStream();
                this.out.print(this.source[8]);
                if (cursor != null) {
                    remoteOut.print(this.source[9]);
                    remoteOut.print(methodName);
                    remoteOut.print(this.source[10]);
                    remoteOut.print(this.pcs(params, "DomainContext context"));
                    remoteOut.print(this.source[11]);
                    implOut.print(this.source[12]);
                    implOut.print(methodName);
                    implOut.print(this.source[13]);
                    implOut.print(this.pcs(params, "DomainContext context"));
                    implOut.print(this.source[14]);
                    implOut.print(methodName);
                    implOut.print(this.source[15]);
                    implOut.print(iparms);
                    implOut.print(this.source[16]);
                    this.out.print(this.source[17]);
                    this.out.print(methodName);
                    this.out.print(this.source[18]);
                    this.out.print(this.pcs(iparms, "getDomainContext()"));
                    this.out.print(this.source[19]);
                } else {
                    remoteOut.print(this.source[20]);
                    remoteOut.print(rmiListType);
                    remoteOut.print(this.source[21]);
                    remoteOut.print(methodName);
                    remoteOut.print(this.source[22]);
                    remoteOut.print(this.pcs(params, "DomainContext context"));
                    remoteOut.print(this.source[23]);
                    implOut.print(this.source[24]);
                    implOut.print(rmiListType);
                    implOut.print(this.source[25]);
                    implOut.print(methodName);
                    implOut.print(this.source[26]);
                    implOut.print(this.pcs(params, "DomainContext context"));
                    implOut.print(this.source[27]);
                    implOut.print(methodName);
                    implOut.print(this.source[28]);
                    implOut.print(iparms);
                    implOut.print(this.source[29]);
                    this.out.print(this.source[30]);
                    this.out.print(listType);
                    this.out.print(this.source[31]);
                    this.out.print(methodName);
                    this.out.print(this.source[32]);
                    this.out.print(this.pcs(iparms, "getDomainContext()"));
                    this.out.print(this.source[33]);
                }
                this.out.print(this.source[34]);
            }
            if (!this.getJoins().isEmpty()) {
                this.out.print(this.source[35]);
                this.out.print(pdoType);
                this.out.print(this.source[36]);
                int joinCount = 0;
                for (Relation join : this.getJoins()) {
                    ++joinCount;
                    String joinClass = join.getForeignEntity().getName();
                    String joinAlias = join.getForeignEntity().getTopSuperEntity().getTableAlias();
                    if (join.getRelationType() == RelationType.LIST) {
                        this.out.print(this.source[37]);
                        this.out.print(joinCount);
                        this.out.print(this.source[38]);
                        this.out.print(join.getForeignAttribute().getColumnName());
                        this.out.print(this.source[39]);
                        this.out.print(joinClass);
                        this.out.print(this.source[40]);
                        this.out.print(joinCount);
                        this.out.print(this.source[41]);
                        this.out.print(alias);
                        this.out.print(this.source[42]);
                        this.out.print(joinAlias);
                        this.out.print(this.source[43]);
                        this.out.print(poImpl);
                        this.out.print(this.source[44]);
                        this.out.print(poImpl);
                        this.out.print(this.source[45]);
                        this.out.print(alias);
                        this.out.print(this.source[46]);
                        if (join.isReversed()) {
                            this.out.print(this.source[47]);
                            this.out.print(join.getSetterName());
                            this.out.print(this.source[48]);
                            this.out.print(joinAlias);
                            this.out.print(this.source[49]);
                        } else {
                            this.out.print(this.source[50]);
                            this.out.print(join.getGetterName());
                            this.out.print(this.source[51]);
                            this.out.print(joinAlias);
                            this.out.print(this.source[52]);
                        }
                        this.out.print(this.source[53]);
                        continue;
                    }
                    this.out.print(this.source[54]);
                    this.out.print(join.getAttribute().getJavaName().toUpperCase());
                    this.out.print(this.source[55]);
                    this.out.print(joinCount);
                    this.out.print(this.source[56]);
                    this.out.print(joinClass);
                    this.out.print(this.source[57]);
                    this.out.print(joinCount);
                    this.out.print(this.source[58]);
                    this.out.print(alias);
                    this.out.print(this.source[59]);
                    this.out.print(joinAlias);
                    this.out.print(this.source[60]);
                    this.out.print(alias);
                    this.out.print(this.source[61]);
                    this.out.print(join.getSetterName());
                    this.out.print(this.source[62]);
                    this.out.print(joinAlias);
                    this.out.print(this.source[63]);
                }
            }
            this.out.print(this.source[64]);
            this.out.print(statementId);
            this.out.print(this.source[65]);
            if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[66]);
            }
            boolean andPrepended = false;
            if (this.getContextAttribute() != null) {
                andPrepended = true;
                this.out.print(this.source[67]);
                this.out.print(this.getContextAttribute().getJavaName().toUpperCase());
                this.out.print(this.source[68]);
            }
            boolean needParentheses = false;
            if (!this.getExpressionParameters().isEmpty()) {
                needParentheses = this.getExpression().needParenthesesAfterAndOperator();
                if (andPrepended || needParentheses) {
                    this.out.print(this.source[69]);
                } else {
                    this.out.print(this.source[70]);
                    if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                        this.out.print(this.source[71]);
                    }
                }
                CodeGenerator<Object> generator = new CodeGenerator<Object>(){

                    public String generate(Object t) throws WurbelException {
                        if (t instanceof WurbletParameterOperator) {
                            return "        sql.append(Backend." + ((WurbletParameterOperator)t).getSql() + ");\n";
                        }
                        if (t instanceof WurbletParameterExpression) {
                            StringBuilder buf = new StringBuilder();
                            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
                            buf.append(((WurbletParameterExpression)t).toCode((CodeGenerator)this));
                            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                            return buf.toString();
                        }
                        if (t instanceof WurbletParameter) {
                            StringBuilder buf = new StringBuilder();
                            WurbletParameter par = (WurbletParameter)t;
                            Attribute attr = par.getAttribute();
                            if (par.isComponentKey() || par.isRelationKey()) {
                                String compKeyClass = PdoSelectList.this.deriveClassNameForEntity(attr.getEntity());
                                for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                    String name = attr.getJavaName().toUpperCase() + sp.getPostfix();
                                    boolean mainColumn = sp.getPostfix().isEmpty();
                                    if (!mainColumn) {
                                        buf.append("        sql.append(Backend.SQL_AND);\n");
                                    }
                                    buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(").append(compKeyClass).append(".CN_").append(name).append(")).\n");
                                    if (mainColumn) {
                                        buf.append("            append(").append(par.getRelop()).append(");\n");
                                        continue;
                                    }
                                    buf.append("            append(Backend.SQL_EQUAL_PAR);\n");
                                }
                            } else {
                                for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                    String name = attr.getJavaName().toUpperCase() + sp.getPostfix();
                                    boolean mainColumn = sp.getPostfix().isEmpty();
                                    if (!mainColumn) {
                                        buf.append("        sql.append(Backend.SQL_AND);\n");
                                    }
                                    if (whereWithAliases) {
                                        if (PdoSelectList.this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                                            buf.append("        sql.append(");
                                            buf.append(PdoSelectList.this.deriveClassNameForEntity(attr.getEntity()));
                                            buf.append(".CLASSVARIABLES.getColumnName(CN_");
                                            buf.append(name).append("));\n");
                                        } else if (PdoSelectList.this.isPdo()) {
                                            buf.append("        sql.append(getColumnName(CN_").append(name).append("));\n");
                                        } else {
                                            buf.append("        sql.append(CN_").append(name).append(");\n");
                                        }
                                    } else {
                                        buf.append("        sql.append(CN_").append(name).append(");\n");
                                    }
                                    if (mainColumn) {
                                        buf.append("        sql.append(").append(par.getRelop()).append(");\n");
                                        continue;
                                    }
                                    buf.append("        sql.append(Backend.SQL_EQUAL_PAR);\n");
                                }
                            }
                            return buf.toString();
                        }
                        return "        sql.append(" + t + ");\n";
                    }
                };
                String code = this.getExpression().toCode((CodeGenerator)generator);
                if (code.endsWith("\n")) {
                    code = code.substring(0, code.length() - 1);
                }
                this.out.print(code);
                this.out.print(this.source[72]);
                if (andPrepended || needParentheses) {
                    this.out.print(this.source[73]);
                } else if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                    this.out.print(this.source[74]);
                }
            }
            if ((orderByStr = this.createOrderBy()) != null) {
                this.out.print(this.source[75]);
                this.out.print(orderByStr);
                this.out.print(this.source[76]);
            }
            this.out.print(this.source[77]);
            this.out.print(lock ? "true" : "false");
            this.out.print(this.source[78]);
            this.out.print(limit ? "limit" : "0");
            this.out.print(this.source[79]);
            this.out.print(offset ? "offset" : "0");
            this.out.print(this.source[80]);
            if (sort) {
                this.out.print(this.source[81]);
            }
            if (append != null) {
                this.out.print(this.source[82]);
                this.out.print(append);
                this.out.print(this.source[83]);
            }
            for (Relation relation : this.getJoinedRelations()) {
                String rightAttribute;
                String leftAttribute;
                if (relation.getRelationType() == RelationType.OBJECT) {
                    leftAttribute = "CN_" + relation.getAttribute().getJavaName().toUpperCase();
                    rightAttribute = "CN_ID";
                } else {
                    leftAttribute = "CN_ID";
                    rightAttribute = "CN_" + relation.getForeignAttribute().getJavaName().toUpperCase();
                }
                String leftClass = relation.getEntity().equals(this.getEntity()) ? "" : this.deriveClassNameForEntity(relation.getEntity()) + ".";
                String leftClassVariables = leftClass.isEmpty() ? "" : leftClass + "CLASSVARIABLES.";
                String rightClass = relation.getForeignEntity().equals(this.getEntity()) ? "" : this.deriveClassNameForEntity(relation.getForeignEntity()) + ".";
                this.out.print(this.source[84]);
                this.out.print(rightClass);
                this.out.print(this.source[85]);
                this.out.print(rightClass);
                this.out.print(this.source[86]);
                this.out.print(leftClassVariables);
                this.out.print(this.source[87]);
                this.out.print(leftClass);
                this.out.print(leftAttribute);
                this.out.print(this.source[88]);
                this.out.print(rightClass);
                this.out.print(this.source[89]);
                this.out.print(rightClass);
                this.out.print(rightAttribute);
                this.out.print(this.source[90]);
            }
            for (ComponentJoin cj : this.getComponentJoins()) {
                String leftClassVariables = "";
                if (!cj.getEntity().equals(this.getEntity())) {
                    leftClassVariables = this.deriveClassNameForEntity(cj.getEntity()) + ".CLASSVARIABLES.";
                }
                this.out.print(this.source[91]);
                this.out.print(cj.getRootIdClassName());
                this.out.print(this.source[92]);
                this.out.print(cj.getRootIdClassName());
                this.out.print(this.source[93]);
                this.out.print(leftClassVariables);
                this.out.print(this.source[94]);
                this.out.print(cj.getRootIdClassName());
                this.out.print(this.source[95]);
                this.out.print(cj.getRootIdColumnName());
                this.out.print(this.source[96]);
                if (!cj.isExtraJoinNecessary()) continue;
                this.out.print(this.source[97]);
                this.out.print(cj.getExtraClassName());
                this.out.print(this.source[98]);
                this.out.print(cj.getExtraClassName());
                this.out.print(this.source[99]);
                this.out.print(cj.getRootIdClassName());
                this.out.print(this.source[100]);
                this.out.print(cj.getExtraClassName());
                this.out.print(this.source[101]);
            }
            if (!this.getJoins().isEmpty()) {
                this.out.print(this.source[102]);
            }
            this.out.print(this.source[103]);
            if (limit || offset) {
                this.out.print(this.source[104]);
                this.out.print(limit ? "limit" : "0");
                this.out.print(this.source[105]);
                this.out.print(offset ? "offset" : "0");
                this.out.print(this.source[106]);
            } else {
                this.out.print(this.source[107]);
            }
            if (!this.getJoins().isEmpty()) {
                this.out.print(this.source[108]);
            }
            if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[109]);
            }
            if (this.getContextAttribute() != null) {
                this.out.print(this.source[110]);
                this.out.print(this.createJdbcSetterName(this.getContextAttribute()));
                this.out.print(this.source[111]);
                this.out.print(this.getContextAttribute().getJavaName());
                this.out.print(this.source[112]);
            }
            for (WurbletParameter par : this.getMethodParameters()) {
                if (!par.isSqlArg()) continue;
                Attribute attr = par.getAttribute();
                if (attr.getOptions().isMapNull()) {
                    this.out.print(this.source[113]);
                    this.out.print(this.createJdbcSetterName(attr));
                    this.out.print(this.source[114]);
                    this.out.print(this.getJdbcCode(attr, par.getSqlArg()));
                    this.out.print(this.source[115]);
                } else {
                    this.out.print(this.source[116]);
                    this.out.print(this.createJdbcSetterName(attr));
                    this.out.print(this.source[117]);
                    this.out.print(this.getJdbcCode(attr, par.getSqlArg()));
                    this.out.print(this.source[118]);
                }
                for (int p = 1; p < attr.getDataType().getSqlTypes().length; ++p) {
                    this.out.print(this.source[119]);
                }
            }
            if (limit || offset) {
                this.out.print(this.source[120]);
                this.out.print(limit ? "limit" : "0");
                this.out.print(this.source[121]);
                this.out.print(offset ? "offset" : "0");
                this.out.print(this.source[122]);
            }
            if (resultSet) {
                this.out.print(this.source[123]);
            } else if (cursor != null) {
                this.out.print(this.source[124]);
                if (this.getJoins().isEmpty()) {
                    this.out.print(this.source[125]);
                } else {
                    this.out.print(this.source[126]);
                }
            } else if (this.isTracked()) {
                if (this.getJoins().isEmpty()) {
                    this.out.print(this.source[127]);
                } else {
                    this.out.print(this.source[128]);
                }
            } else if (this.getJoins().isEmpty()) {
                this.out.print(this.source[129]);
            } else {
                this.out.print(this.source[130]);
            }
            this.out.print(this.source[131]);
        }
        catch (Exception ex) {
            throw new WurbelException("wurblet " + (Object)((Object)this) + " failed", (Throwable)ex);
        }
    }
}

