/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.Objects;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.wurbelizer.wurbel.WurbelException;

public class ComponentJoin {
    private final Entity entity;
    private final Entity joinedEntity;
    private final String rootIdColumnName;
    private final String rootIdClassName;
    private final String extraClassName;

    public ComponentJoin(DbModelWurblet wurblet, Entity entity, Entity joinedEntity) throws WurbelException {
        this.entity = entity;
        this.joinedEntity = joinedEntity;
        Entity topEntity = joinedEntity.getHierarchyInheritanceType() == InheritanceType.PLAIN ? joinedEntity : joinedEntity.getTopSuperEntity();
        Attribute rootAttribute = null;
        if (topEntity.equals(joinedEntity)) {
            this.extraClassName = null;
            for (topEntity = joinedEntity; topEntity != null && (rootAttribute = topEntity.getRootAttribute()) == null; topEntity = topEntity.getSuperEntity()) {
            }
        } else {
            this.extraClassName = wurblet.deriveClassNameForEntity(joinedEntity);
            rootAttribute = topEntity.getRootAttribute();
        }
        if (rootAttribute != null) {
            Entity rootAttributeEntity = rootAttribute.getEntity().getInheritanceType() == InheritanceType.PLAIN ? joinedEntity : rootAttribute.getEntity();
            this.rootIdClassName = wurblet.deriveClassNameForEntity(rootAttributeEntity);
            this.rootIdColumnName = this.rootIdClassName + ".CN_" + rootAttribute.getJavaName().toUpperCase();
        } else {
            this.rootIdClassName = wurblet.deriveClassNameForEntity(joinedEntity);
            this.rootIdColumnName = "CN_ROOTID";
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Entity getJoinedEntity() {
        return this.joinedEntity;
    }

    public boolean isExtraJoinNecessary() {
        return this.extraClassName != null;
    }

    public String getExtraClassName() {
        return this.extraClassName;
    }

    public String getRootIdClassName() {
        return this.rootIdClassName;
    }

    public String getRootIdColumnName() {
        return this.rootIdColumnName;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.rootIdClassName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentJoin other = (ComponentJoin)obj;
        return Objects.equals(this.rootIdClassName, other.rootIdClassName);
    }
}

