/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeSorting;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.TrackType;
import org.tentackle.persist.wurblet.ComponentJoin;
import org.tentackle.wurblet.ModelWurblet;
import org.tentackle.wurblet.WurbletParameter;
import org.wurbelizer.wurbel.WurbelException;

public class DbModelWurblet
extends ModelWurblet {
    private boolean tracked;
    private boolean attracked;
    private boolean fullTracked;
    private Attribute contextAttribute;
    private Set<ComponentJoin> componentJoins;
    private List<Relation> joinedRelations;

    public void run() throws WurbelException {
        super.run();
        this.tracked = this.getEntity().getOptions().getTrackType().isTracked();
        this.attracked = this.getEntity().getOptions().getTrackType().isAttracked();
        this.fullTracked = this.getEntity().getOptions().getTrackType() == TrackType.FULLTRACKED;
        this.contextAttribute = this.getEntity().getContextIdAttribute();
        for (String arg : this.getOptionArgs()) {
            if ("tracked".equals(arg)) {
                this.tracked = true;
                this.attracked = false;
                this.fullTracked = false;
                continue;
            }
            if ("attracked".equals(arg)) {
                this.tracked = true;
                this.attracked = true;
                this.fullTracked = false;
                continue;
            }
            if ("fulltracked".equals(arg)) {
                this.tracked = true;
                this.attracked = true;
                this.fullTracked = true;
                continue;
            }
            if ("untracked".equals(arg)) {
                this.tracked = false;
                this.attracked = false;
                this.fullTracked = false;
                continue;
            }
            if (!arg.startsWith("context=")) continue;
            String ctx = arg.substring(8);
            if (ctx.length() == 0) {
                this.contextAttribute = null;
                continue;
            }
            this.contextAttribute = this.getEntity().getAttributeByJavaName(arg.substring(8), false);
        }
    }

    public boolean isTracked() {
        return this.tracked;
    }

    public boolean isAttracked() {
        return this.attracked;
    }

    public boolean isFullTracked() {
        return this.fullTracked;
    }

    public Attribute getContextAttribute() {
        return this.contextAttribute;
    }

    public boolean isClassIdRequiredInWhereClause(Entity entity) {
        return !entity.isAbstract() && entity.getSuperEntity() != null && entity.getHierarchyInheritanceType().isMappingToSuperTable();
    }

    public boolean isClassIdRequiredInWhereClause() {
        return this.isClassIdRequiredInWhereClause(this.getEntity());
    }

    public boolean isEntityPersistable() {
        return !this.getEntity().isAbstract() || !this.getEntity().getHierarchyInheritanceType().isMappingToNoTable();
    }

    public void assertEntityIsPersistable() throws WurbelException {
        if (!this.isEntityPersistable()) {
            throw new WurbelException(this.getEntity() + " does not map to any table and is not persistable");
        }
    }

    public List<AttributeSorting> getDefaultSorting() {
        for (Entity entity = this.getEntity(); entity != null; entity = entity.getSuperEntity()) {
            List sorting = entity.getSorting();
            if (sorting == null || sorting.isEmpty()) continue;
            return sorting;
        }
        return null;
    }

    public List<WurbletParameter> getDefaultSortKeys() {
        ArrayList<WurbletParameter> sortKeys = new ArrayList<WurbletParameter>();
        List<AttributeSorting> sorting = this.getDefaultSorting();
        if (sorting != null) {
            for (AttributeSorting as : sorting) {
                WurbletParameter key = new WurbletParameter(as.toString());
                key.setAttribute(as.getAttribute());
                sortKeys.add(key);
            }
        }
        return sortKeys;
    }

    public boolean isWithDefaultSorting() {
        return this.getDefaultSorting() != null;
    }

    public Set<ComponentJoin> getComponentJoins() throws WurbelException {
        if (this.componentJoins == null) {
            this.componentJoins = new HashSet<ComponentJoin>();
            for (WurbletParameter par : this.getExpressionParameters()) {
                ComponentJoin join;
                if (par.isComponentKey() || par.isRelationKey() && par.getRelationComponentEntityName() != null) {
                    join = new ComponentJoin(this, par.isComponentKey() ? this.getEntity() : par.getRelation().getForeignEntity(), par.getAttribute().getEntity());
                    this.componentJoins.add(join);
                    continue;
                }
                if (!par.isRelationKey() || par.getComponentEntityName().isEmpty()) continue;
                join = new ComponentJoin(this, par.getRelation().getForeignEntity(), par.getRelation().getEntity());
                this.componentJoins.add(join);
            }
        }
        return this.componentJoins;
    }

    public List<Relation> getJoinedRelations() {
        if (this.joinedRelations == null) {
            this.joinedRelations = new ArrayList<Relation>();
            for (WurbletParameter par : this.getExpressionParameters()) {
                if (!par.isRelationKey()) continue;
                this.joinedRelations.add(par.getRelation());
            }
        }
        return this.joinedRelations;
    }

    public String createOrderBy(List<WurbletParameter> sortKeys) throws WurbelException {
        if (!sortKeys.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            boolean needComma = false;
            for (WurbletParameter key : sortKeys) {
                Attribute attr = key.getAttribute();
                for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                    if (needComma) {
                        buf.append("\n           .append(Backend.SQL_COMMA)");
                    }
                    String name = "CN_" + attr.getJavaName().toUpperCase() + sp.getPostfix();
                    buf.append(".append(");
                    if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                        buf.append(this.deriveClassNameForEntity(this.getEntity().getTopSuperEntity()));
                        buf.append(".CLASSVARIABLES.getColumnName(").append(name).append(')');
                    } else if (this.isPdo()) {
                        buf.append("getColumnName(").append(name).append(')');
                    } else {
                        buf.append(name);
                    }
                    buf.append(").append(");
                    buf.append(key.getSortMode().equals(" ASC") ? "Backend.SQL_SORTASC" : "Backend.SQL_SORTDESC");
                    buf.append(')');
                    needComma = true;
                }
            }
            return buf.toString();
        }
        return null;
    }

    public String createOrderBy() throws WurbelException {
        return this.createOrderBy(this.getSortingParameters());
    }

    public String createStatementId() throws WurbelException {
        StringBuilder buf = new StringBuilder();
        String id = this.getGuardName();
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isUpperCase(c) && buf.length() > 0) {
                buf.append('_');
            }
            buf.append(Character.toUpperCase(c));
        }
        buf.append("_STMT");
        return buf.toString();
    }

    public String buildMethodParameters(boolean limit, boolean offset) throws WurbelException {
        StringBuilder params = new StringBuilder();
        if (limit) {
            this.appendCommaSeparated(params, "int limit");
        }
        if (offset) {
            this.appendCommaSeparated(params, "int offset");
        }
        HashSet<String> argSet = new HashSet<String>();
        for (WurbletParameter key : this.getMethodParameters()) {
            if (!key.isArg() || !argSet.add(key.getArg())) continue;
            Attribute attr = key.getAttribute();
            try {
                this.appendCommaSeparated(params, attr.getJavaType());
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java type for key " + key, (Throwable)me);
            }
            params.append(' ');
            params.append(key.getArg());
        }
        return params.toString();
    }

    public String buildMethodParameters() throws WurbelException {
        return this.buildMethodParameters(false, false);
    }

    public String buildInvocationParameters(boolean limit, boolean offset) {
        StringBuilder params = new StringBuilder();
        if (limit) {
            this.appendCommaSeparated(params, "limit");
        }
        if (offset) {
            this.appendCommaSeparated(params, "offset");
        }
        HashSet<String> argSet = new HashSet<String>();
        for (WurbletParameter key : this.getMethodParameters()) {
            if (!key.isArg() || !argSet.add(key.getArg())) continue;
            this.appendCommaSeparated(params, key.getArg());
        }
        return params.toString();
    }

    public String buildInvocationParameters() {
        return this.buildInvocationParameters(false, false);
    }

    public String acs(String str, String appendStr) {
        StringBuilder builder = new StringBuilder(str);
        this.appendCommaSeparated(builder, appendStr);
        return builder.toString();
    }

    public String pcs(String str, String prependStr) {
        StringBuilder builder = new StringBuilder(str);
        this.prependCommaSeparated(builder, prependStr);
        return builder.toString();
    }

    public String aas(String str) {
        if (str != null && str.length() > 0) {
            return ", " + str;
        }
        return "";
    }

    public String as(String str) {
        return str == null ? "" : str;
    }

    public DataType getJdbcDataType(Attribute attribute) throws WurbelException {
        if (attribute.getDataType() == DataType.APPLICATION) {
            try {
                return attribute.getInnerType();
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine effective JDBC datatype for " + attribute, (Throwable)me);
            }
        }
        return attribute.getDataType();
    }

    public String createJdbcSetterName(Attribute attribute) throws WurbelException {
        StringBuilder buf = new StringBuilder("set");
        DataType type = this.getJdbcDataType(attribute);
        if (type.isPrimitive()) {
            buf.append(BasicStringHelper.firstToUpper((String)type.toString()));
        } else {
            buf.append(type.toString());
        }
        return buf.toString();
    }

    public String createJdbcGetterName(Attribute attribute) throws WurbelException {
        StringBuilder buf = new StringBuilder("get");
        DataType type = this.getJdbcDataType(attribute);
        if (type.isPrimitive()) {
            buf.append(BasicStringHelper.firstToUpper((String)type.toString()));
        } else if (type == DataType.BOOLEAN) {
            buf.append("ABoolean");
        } else if (type == DataType.BYTE) {
            buf.append("AByte");
        } else if (type == DataType.SHORT) {
            buf.append("AShort");
        } else if (type == DataType.LONG) {
            buf.append("ALong");
        } else if (type == DataType.FLOAT) {
            buf.append("AFloat");
        } else if (type == DataType.DOUBLE) {
            buf.append("ADouble");
        } else {
            buf.append(type.toString());
        }
        return buf.toString();
    }

    public String getModelCode(Attribute attribute, String jdbcCode) throws WurbelException {
        if (attribute.getDataType() == DataType.APPLICATION) {
            try {
                return attribute.getJavaType() + ".toInternal(" + jdbcCode + ")";
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java model-side code for " + attribute + ": " + jdbcCode, (Throwable)me);
            }
        }
        return jdbcCode;
    }

    public String getJdbcCode(Attribute attribute, String modelCode) throws WurbelException {
        String jdbcCode = modelCode;
        if (attribute.getDataType() == DataType.APPLICATION) {
            try {
                String applicationType = attribute.getApplicationType();
                jdbcCode = modelCode.startsWith(applicationType + ".") ? modelCode + ".toExternal()" : (attribute.getInnerType().isPrimitive() ? modelCode + " == null ? " + applicationType + ".getDefault().toExternal() : " + modelCode + ".toExternal()" : modelCode + " == null ? null : " + modelCode + ".toExternal()");
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java jdbc-side code for " + attribute + ": " + modelCode, (Throwable)me);
            }
        }
        return jdbcCode;
    }

    public boolean isRelationTransient(Relation relation) {
        return relation.getSelectionType() == SelectionType.LAZY && !relation.isComposite() && !relation.isSerialized();
    }

    public List<String> getRelationArgs(Relation relation, boolean select) {
        if (select ? relation.isSelectionFromMainClass() : relation.isDeletionFromMainClass()) {
            return new ArrayList<String>();
        }
        return relation.getMethodArgs();
    }

    public String createRelationArgString(Relation relation, boolean select) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        List<String> args = this.getRelationArgs(relation, select);
        boolean first = true;
        for (String arg : args) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(arg);
        }
        buf.append(')');
        return buf.toString();
    }

    public String createRelationSelectCode(Relation relation) {
        String text = "on(" + relation.getClassName() + ".class)." + this.createRelationSelectMethodName(relation);
        text = text + this.createRelationArgString(relation, true);
        if (relation.getForeignEntity().isAbstract()) {
            text = "(" + relation.getClassName() + "<?>) " + text;
        }
        return text;
    }

    public String createRelationUpdateReferenceCode(Relation relation) {
        if (relation.getLinkMethodName() != null) {
            return relation.getLinkMethodName() + (relation.getLinkMethodIndex() != null ? "(pdo(), ndx++)" : "(pdo())");
        }
        return "set" + relation.getEntity().getName() + "(pdo())";
    }

    public String createRelationSetFirstArgMethodName(Relation relation) {
        return "set" + BasicStringHelper.firstToUpper((String)((String)relation.getMethodArgs().get(0)));
    }

    public String createRelationDeleteCode(Relation relation) {
        String text = "delete";
        if (relation.getRelationType() == RelationType.LIST) {
            text = text + "By";
        }
        text = relation.getMethodName() != null ? text + relation.getMethodName() : text + relation.getEntity().getName() + "Id";
        text = "on(" + relation.getClassName() + ".class)." + text;
        text = text + this.createRelationArgString(relation, false);
        return text;
    }

    public String createRelationLinkCode(Relation relation) {
        if (relation.getLinkMethodName() != null) {
            return relation.getLinkMethodName() + (relation.getLinkMethodIndex() != null ? "(pdo(), ndx++)" : "(pdo())");
        }
        String text = "set";
        text = relation.getMethodName() != null ? text + relation.getMethodName() : text + relation.getEntity().getName() + "Id";
        return text + this.createRelationArgString(relation, true);
    }

    public List<Relation> getEagerRelations() {
        ArrayList<Relation> eagerRelations = new ArrayList<Relation>();
        block0: for (Relation relation : this.getEntity().getRelations()) {
            if (relation.getSelectionType() != SelectionType.EAGER) continue;
            for (Relation rel : this.getEntity().getSubEntityRelations()) {
                if (rel.getSelectionType() != SelectionType.EAGER) continue;
                break block0;
            }
            for (Entity component : relation.getForeignEntity().getComponentsIncludingInherited()) {
                for (Relation rel : component.getAllRelations()) {
                    if (rel.getSelectionType() != SelectionType.EAGER) continue;
                    break block0;
                }
            }
            eagerRelations.add(relation);
        }
        return eagerRelations.isEmpty() ? null : eagerRelations;
    }
}

