/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.PrintStream;
import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.InheritanceType;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.WurbletParameter;
import org.tentackle.wurblet.WurbletParameterExpression;
import org.tentackle.wurblet.WurbletParameterOperator;
import org.wurbelizer.wurbel.WurbelException;

public class DbSelectList
extends DbModelWurblet {
    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            String orderByStr;
            if (!this.getExtraParameters().isEmpty()) {
                String msg = "unexpected extra parameters:";
                for (WurbletParameter par : this.getExtraParameters()) {
                    msg = msg + " " + par;
                }
                throw new WurbelException(msg);
            }
            String className = this.getClassName();
            String methodName = this.getMethodName();
            String delegateCast = "(" + className + "RemoteDelegate)";
            String scope = "public";
            String classVar = null;
            boolean sort = false;
            boolean lock = false;
            String append = null;
            boolean limit = false;
            boolean offset = false;
            boolean bounded = false;
            boolean resultSet = false;
            for (String arg : this.getOptionArgs()) {
                if (arg.equals("private")) {
                    scope = "private";
                    this.setRemote(false);
                    continue;
                }
                if (arg.equals("sort")) {
                    if (this.isWithDefaultSorting()) {
                        if (this.isWithSorting()) {
                            throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
                        }
                        sort = true;
                        continue;
                    }
                    throw new WurbelException("no sorting configured in model for " + this.getEntity());
                }
                if (arg.equals("lock")) {
                    lock = true;
                    continue;
                }
                if (arg.equals("limit")) {
                    limit = true;
                    continue;
                }
                if (arg.equals("offset")) {
                    offset = true;
                    continue;
                }
                if (arg.equals("bounded")) {
                    bounded = true;
                    continue;
                }
                if (arg.equals("resultset")) {
                    resultSet = true;
                    continue;
                }
                if (arg.startsWith("append=")) {
                    append = arg.substring(7);
                    continue;
                }
                if (!arg.startsWith("classvar=")) continue;
                classVar = arg.substring(9);
            }
            if (resultSet) {
                this.setRemote(false);
            }
            classVar = classVar == null ? "" : classVar + ".";
            String params = this.buildMethodParameters(limit, offset);
            String iparms = this.buildInvocationParameters(limit, offset);
            String statementId = this.createStatementId();
            String listType = resultSet ? "ResultSetWrapper" : (this.isTracked() ? "TrackedArrayList" : "List") + "<" + (bounded ? "? extends " : "") + className + ">";
            String varListType = (this.isTracked() ? "TrackedArrayList" : "List") + "<" + className + ">";
            String rmiListType = (this.isTracked() ? "TrackedArrayList" : "List") + "<" + (bounded ? "? extends " : "") + (this.isGenerified() ? "P" : className) + ">";
            final boolean whereWithAliases = true;
            this.out.print(this.source[0]);
            this.out.print(scope);
            this.out.print(this.source[1]);
            this.out.print(listType);
            this.out.print(this.source[2]);
            this.out.print(methodName);
            this.out.print(this.source[3]);
            this.out.print(params);
            this.out.print(this.source[4]);
            if (this.isRemote()) {
                RemoteIncludes genInc = new RemoteIncludes(this);
                PrintStream implOut = genInc.getImplStream();
                PrintStream remoteOut = genInc.getRemoteStream();
                this.out.print(this.source[5]);
                remoteOut.print(this.source[6]);
                remoteOut.print(rmiListType);
                remoteOut.print(this.source[7]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[8]);
                remoteOut.print(params);
                remoteOut.print(this.source[9]);
                implOut.print(this.source[10]);
                implOut.print(rmiListType);
                implOut.print(this.source[11]);
                implOut.print(methodName);
                implOut.print(this.source[12]);
                implOut.print(params);
                implOut.print(this.source[13]);
                implOut.print(methodName);
                implOut.print(this.source[14]);
                implOut.print(iparms);
                implOut.print(this.source[15]);
                this.out.print(this.source[16]);
                this.out.print(listType);
                this.out.print(this.source[17]);
                this.out.print(delegateCast);
                this.out.print(this.source[18]);
                this.out.print(methodName);
                this.out.print(this.source[19]);
                this.out.print(iparms);
                this.out.print(this.source[20]);
            }
            this.out.print(this.source[21]);
            this.out.print(classVar);
            this.out.print(statementId);
            this.out.print(this.source[22]);
            if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[23]);
            }
            boolean andPrepended = false;
            if (this.getContextAttribute() != null) {
                andPrepended = true;
                this.out.print(this.source[24]);
                this.out.print(this.getContextAttribute().getJavaName().toUpperCase());
                this.out.print(this.source[25]);
            }
            boolean needParentheses = false;
            if (!this.getExpressionParameters().isEmpty()) {
                needParentheses = this.getExpression().needParenthesesAfterAndOperator();
                if (andPrepended || needParentheses) {
                    this.out.print(this.source[26]);
                } else {
                    this.out.print(this.source[27]);
                    if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                        this.out.print(this.source[28]);
                    }
                }
                CodeGenerator<Object> generator = new CodeGenerator<Object>(){

                    public String generate(Object t) throws WurbelException {
                        if (t instanceof WurbletParameterOperator) {
                            return "        sql.append(Backend." + ((WurbletParameterOperator)t).getSql() + ");\n";
                        }
                        if (t instanceof WurbletParameterExpression) {
                            StringBuilder buf = new StringBuilder();
                            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
                            buf.append(((WurbletParameterExpression)t).toCode((CodeGenerator)this));
                            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                            return buf.toString();
                        }
                        if (t instanceof WurbletParameter) {
                            StringBuilder buf = new StringBuilder();
                            WurbletParameter par = (WurbletParameter)t;
                            Attribute attr = par.getAttribute();
                            if (par.isComponentKey() || par.isRelationKey()) {
                                String compKeyClass = DbSelectList.this.deriveClassNameForEntity(attr.getEntity());
                                for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                    String name = attr.getJavaName().toUpperCase() + sp.getPostfix();
                                    boolean mainColumn = sp.getPostfix().isEmpty();
                                    if (!mainColumn) {
                                        buf.append("        sql.append(Backend.SQL_AND);\n");
                                    }
                                    buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(").append(compKeyClass).append(".CN_").append(name).append(")).\n");
                                    if (mainColumn) {
                                        buf.append("            append(").append(par.getRelop()).append(");\n");
                                        continue;
                                    }
                                    buf.append("            append(Backend.SQL_EQUAL_PAR);\n");
                                }
                            } else {
                                for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                    String name = attr.getJavaName().toUpperCase() + sp.getPostfix();
                                    boolean mainColumn = sp.getPostfix().isEmpty();
                                    if (!mainColumn) {
                                        buf.append("        sql.append(Backend.SQL_AND);\n");
                                    }
                                    if (whereWithAliases) {
                                        if (DbSelectList.this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                                            buf.append("        sql.append(");
                                            buf.append(DbSelectList.this.deriveClassNameForEntity(attr.getEntity()));
                                            buf.append(".CLASSVARIABLES.getColumnName(CN_");
                                            buf.append(name).append("));\n");
                                        } else if (DbSelectList.this.isPdo()) {
                                            buf.append("        sql.append(getColumnName(CN_").append(name).append("));\n");
                                        } else {
                                            buf.append("        sql.append(CN_").append(name).append(");\n");
                                        }
                                    } else {
                                        buf.append("        sql.append(CN_").append(name).append(");\n");
                                    }
                                    if (mainColumn) {
                                        buf.append("        sql.append(").append(par.getRelop()).append(");\n");
                                        continue;
                                    }
                                    buf.append("        sql.append(Backend.SQL_EQUAL_PAR);\n");
                                }
                            }
                            return buf.toString();
                        }
                        return "        sql.append(" + t + ");\n";
                    }
                };
                String code = this.getExpression().toCode((CodeGenerator)generator);
                if (code.endsWith("\n")) {
                    code = code.substring(0, code.length() - 1);
                }
                this.out.print(code);
                this.out.print(this.source[29]);
                if (andPrepended || needParentheses) {
                    this.out.print(this.source[30]);
                } else if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                    this.out.print(this.source[31]);
                }
            }
            if ((orderByStr = this.createOrderBy()) != null) {
                this.out.print(this.source[32]);
                this.out.print(orderByStr);
                this.out.print(this.source[33]);
            }
            this.out.print(this.source[34]);
            this.out.print(lock ? "true" : "false");
            this.out.print(this.source[35]);
            this.out.print(limit ? "limit" : "0");
            this.out.print(this.source[36]);
            this.out.print(offset ? "offset" : "0");
            this.out.print(this.source[37]);
            if (sort) {
                this.out.print(this.source[38]);
            }
            if (append != null) {
                this.out.print(this.source[39]);
                this.out.print(append);
                this.out.print(this.source[40]);
            }
            this.out.print(this.source[41]);
            if (limit || offset) {
                this.out.print(this.source[42]);
                this.out.print(limit ? "limit" : "0");
                this.out.print(this.source[43]);
                this.out.print(offset ? "offset" : "0");
                this.out.print(this.source[44]);
            } else {
                this.out.print(this.source[45]);
            }
            if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[46]);
            }
            if (this.getContextAttribute() != null) {
                this.out.print(this.source[47]);
                this.out.print(this.createJdbcSetterName(this.getContextAttribute()));
                this.out.print(this.source[48]);
                this.out.print(this.getContextAttribute().getJavaName());
                this.out.print(this.source[49]);
            }
            for (WurbletParameter par : this.getMethodParameters()) {
                if (!par.isSqlArg()) continue;
                Attribute attr = par.getAttribute();
                if (attr.getOptions().isMapNull()) {
                    this.out.print(this.source[50]);
                    this.out.print(this.createJdbcSetterName(attr));
                    this.out.print(this.source[51]);
                    this.out.print(this.getJdbcCode(attr, par.getSqlArg()));
                    this.out.print(this.source[52]);
                } else {
                    this.out.print(this.source[53]);
                    this.out.print(this.createJdbcSetterName(attr));
                    this.out.print(this.source[54]);
                    this.out.print(this.getJdbcCode(attr, par.getSqlArg()));
                    this.out.print(this.source[55]);
                }
                for (int p = 1; p < attr.getDataType().getSqlTypes().length; ++p) {
                    this.out.print(this.source[56]);
                }
            }
            if (limit || offset) {
                this.out.print(this.source[57]);
                this.out.print(limit ? "limit" : "0");
                this.out.print(this.source[58]);
                this.out.print(offset ? "offset" : "0");
                this.out.print(this.source[59]);
            }
            if (resultSet) {
                this.out.print(this.source[60]);
            } else {
                this.out.print(this.source[61]);
                if (this.isTracked()) {
                    this.out.print(this.source[62]);
                    this.out.print(varListType);
                    this.out.print(this.source[63]);
                    this.out.print(className);
                    this.out.print(this.source[64]);
                } else {
                    this.out.print(this.source[65]);
                    this.out.print(varListType);
                    this.out.print(this.source[66]);
                }
                this.out.print(this.source[67]);
                this.out.print(className);
                this.out.print(this.source[68]);
                this.out.print(className);
                this.out.print(this.source[69]);
                this.out.print(className);
                this.out.print(this.source[70]);
                if (this.isTracked()) {
                    this.out.print(this.source[71]);
                }
                this.out.print(this.source[72]);
            }
            this.out.print(this.source[73]);
            if (classVar.length() == 0) {
                this.out.print(this.source[74]);
                this.out.print(statementId);
                this.out.print(this.source[75]);
            }
        }
        catch (Exception ex) {
            throw new WurbelException("wurblet " + (Object)((Object)this) + " failed", (Throwable)ex);
        }
    }
}

