/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.PrintStream;
import org.tentackle.model.Attribute;
import org.tentackle.model.DataType;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.persist.wurblet.ComponentJoin;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.WurbletParameter;
import org.tentackle.wurblet.WurbletParameterExpression;
import org.tentackle.wurblet.WurbletParameterOperator;
import org.wurbelizer.wurbel.WurbelException;

public class PdoSelectUnique
extends DbModelWurblet {
    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            String orderByStr;
            String pdoName;
            this.assertEntityIsPersistable();
            if (!this.getExtraParameters().isEmpty()) {
                String msg = "unexpected extra parameters:";
                for (WurbletParameter par : this.getExtraParameters()) {
                    msg = msg + " " + par;
                }
                throw new WurbelException(msg);
            }
            String className = this.getClassName();
            String methodName = this.getMethodName();
            String returnType = pdoName = this.getPdoClassName();
            String poType = className;
            if (this.isGenerified()) {
                returnType = "T";
                poType = "P";
            }
            boolean sort = false;
            boolean lock = false;
            String append = null;
            boolean noif = false;
            String scope = "public";
            for (String arg : this.getOptionArgs()) {
                if (arg.equals("private")) {
                    scope = "private";
                    continue;
                }
                if (arg.equals("noif")) {
                    noif = true;
                    continue;
                }
                if (arg.equals("sort")) {
                    if (this.isWithDefaultSorting()) {
                        if (this.isWithSorting()) {
                            throw new WurbelException("either default sorting (--sort) or explicit sorting (+/-AN) allowed");
                        }
                        sort = true;
                        continue;
                    }
                    throw new WurbelException("no sorting configured in model for " + this.getEntity());
                }
                if (arg.equals("lock")) {
                    lock = true;
                    continue;
                }
                if (!arg.startsWith("append=")) continue;
                append = arg.substring(7);
            }
            if (scope.equals("private")) {
                this.setRemote(false);
                noif = true;
            }
            if (methodName == null) {
                throw new WurbelException("can't determine <methodname>");
            }
            if (this.getExpressionParameters().isEmpty() && !sort && append == null && this.getContextAttribute() == null) {
                throw new WurbelException("no keys given");
            }
            String params = this.buildMethodParameters();
            String iparms = this.buildInvocationParameters();
            String statementId = this.createStatementId();
            String reflMethod = this.getGuardName() + "Method";
            boolean needLimit = sort || append != null || this.createOrderBy() != null;
            final boolean whereWithAliases = true;
            String alias = this.getEntity().getTopSuperEntity().getTableAlias();
            String poImpl = this.deriveClassNameForEntity(this.getEntity());
            this.out.print(this.source[0]);
            this.out.print(statementId);
            this.out.print(this.source[1]);
            if (!noif) {
                this.out.print(this.source[2]);
            }
            this.out.print(this.source[3]);
            this.out.print(scope);
            this.out.print(this.source[4]);
            this.out.print(returnType);
            this.out.print(this.source[5]);
            this.out.print(methodName);
            this.out.print(this.source[6]);
            this.out.print(this.as(params));
            this.out.print(this.source[7]);
            if (this.isRemote()) {
                RemoteIncludes genInc = new RemoteIncludes(this);
                PrintStream implOut = genInc.getImplStream();
                PrintStream remoteOut = genInc.getRemoteStream();
                this.out.print(this.source[8]);
                remoteOut.print(this.source[9]);
                remoteOut.print(returnType);
                remoteOut.print(this.source[10]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[11]);
                remoteOut.print(this.pcs(params, "DomainContext context"));
                remoteOut.print(this.source[12]);
                implOut.print(this.source[13]);
                implOut.print(returnType);
                implOut.print(this.source[14]);
                implOut.print(methodName);
                implOut.print(this.source[15]);
                implOut.print(this.pcs(params, "DomainContext context"));
                implOut.print(this.source[16]);
                implOut.print(methodName);
                implOut.print(this.source[17]);
                implOut.print(iparms);
                implOut.print(this.source[18]);
                this.out.print(this.source[19]);
                this.out.print(returnType);
                this.out.print(this.source[20]);
                this.out.print(methodName);
                this.out.print(this.source[21]);
                this.out.print(this.pcs(iparms, "getDomainContext()"));
                this.out.print(this.source[22]);
            }
            if (!this.getJoins().isEmpty()) {
                this.out.print(this.source[23]);
                this.out.print(returnType);
                this.out.print(this.source[24]);
                int joinCount = 0;
                for (Relation join : this.getJoins()) {
                    ++joinCount;
                    String joinClass = join.getForeignEntity().getName();
                    String joinAlias = join.getForeignEntity().getTopSuperEntity().getTableAlias();
                    if (join.getRelationType() == RelationType.LIST) {
                        this.out.print(this.source[25]);
                        this.out.print(joinCount);
                        this.out.print(this.source[26]);
                        this.out.print(join.getForeignAttribute().getColumnName());
                        this.out.print(this.source[27]);
                        this.out.print(joinClass);
                        this.out.print(this.source[28]);
                        this.out.print(joinCount);
                        this.out.print(this.source[29]);
                        this.out.print(alias);
                        this.out.print(this.source[30]);
                        this.out.print(joinAlias);
                        this.out.print(this.source[31]);
                        this.out.print(poImpl);
                        this.out.print(this.source[32]);
                        this.out.print(poImpl);
                        this.out.print(this.source[33]);
                        this.out.print(alias);
                        this.out.print(this.source[34]);
                        this.out.print(join.getGetterName());
                        this.out.print(this.source[35]);
                        this.out.print(joinAlias);
                        this.out.print(this.source[36]);
                        continue;
                    }
                    this.out.print(this.source[37]);
                    this.out.print(join.getAttribute().getJavaName().toUpperCase());
                    this.out.print(this.source[38]);
                    this.out.print(joinCount);
                    this.out.print(this.source[39]);
                    this.out.print(joinClass);
                    this.out.print(this.source[40]);
                    this.out.print(joinCount);
                    this.out.print(this.source[41]);
                    this.out.print(alias);
                    this.out.print(this.source[42]);
                    this.out.print(joinAlias);
                    this.out.print(this.source[43]);
                    this.out.print(alias);
                    this.out.print(this.source[44]);
                    this.out.print(join.getSetterName());
                    this.out.print(this.source[45]);
                    this.out.print(joinAlias);
                    this.out.print(this.source[46]);
                }
            }
            this.out.print(this.source[47]);
            this.out.print(statementId);
            this.out.print(this.source[48]);
            if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[49]);
            }
            boolean andPrepended = false;
            if (this.getContextAttribute() != null) {
                andPrepended = true;
                this.out.print(this.source[50]);
                this.out.print(this.getContextAttribute().getJavaName().toUpperCase());
                this.out.print(this.source[51]);
            }
            boolean needParentheses = false;
            if (!this.getExpressionParameters().isEmpty()) {
                needParentheses = this.getExpression().needParenthesesAfterAndOperator();
                if (andPrepended || needParentheses) {
                    this.out.print(this.source[52]);
                } else {
                    this.out.print(this.source[53]);
                    if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                        this.out.print(this.source[54]);
                    }
                }
                CodeGenerator<Object> generator = new CodeGenerator<Object>(){

                    public String generate(Object t) throws WurbelException {
                        if (t instanceof WurbletParameterOperator) {
                            return "        sql.append(Backend." + ((WurbletParameterOperator)t).getSql() + ");\n";
                        }
                        if (t instanceof WurbletParameterExpression) {
                            StringBuilder buf = new StringBuilder();
                            buf.append("        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n");
                            buf.append(((WurbletParameterExpression)t).toCode((CodeGenerator)this));
                            buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
                            return buf.toString();
                        }
                        if (t instanceof WurbletParameter) {
                            StringBuilder buf = new StringBuilder();
                            WurbletParameter par = (WurbletParameter)t;
                            Attribute attr = par.getAttribute();
                            if (par.isComponentKey() || par.isRelationKey()) {
                                String compKeyClass = PdoSelectUnique.this.deriveClassNameForEntity(attr.getEntity());
                                for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                    String name = attr.getJavaName().toUpperCase() + sp.getPostfix();
                                    boolean mainColumn = sp.getPostfix().isEmpty();
                                    if (!mainColumn) {
                                        buf.append("        sql.append(Backend.SQL_AND);\n");
                                    }
                                    buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(").append(compKeyClass).append(".CN_").append(name).append(")).\n");
                                    if (mainColumn) {
                                        buf.append("            append(").append(par.getRelop()).append(");\n");
                                        continue;
                                    }
                                    buf.append("            append(Backend.SQL_EQUAL_PAR);\n");
                                }
                            } else {
                                for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                                    String name = attr.getJavaName().toUpperCase() + sp.getPostfix();
                                    boolean mainColumn = sp.getPostfix().isEmpty();
                                    if (!mainColumn) {
                                        buf.append("        sql.append(Backend.SQL_AND);\n");
                                    }
                                    if (whereWithAliases) {
                                        if (PdoSelectUnique.this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                                            buf.append("        sql.append(");
                                            buf.append(PdoSelectUnique.this.deriveClassNameForEntity(attr.getEntity()));
                                            buf.append(".CLASSVARIABLES.getColumnName(CN_");
                                            buf.append(name).append("));\n");
                                        } else if (PdoSelectUnique.this.isPdo()) {
                                            buf.append("        sql.append(getColumnName(CN_").append(name).append("));\n");
                                        } else {
                                            buf.append("        sql.append(CN_").append(name).append(");\n");
                                        }
                                    } else {
                                        buf.append("        sql.append(CN_").append(name).append(");\n");
                                    }
                                    if (mainColumn) {
                                        buf.append("        sql.append(").append(par.getRelop()).append(");\n");
                                        continue;
                                    }
                                    buf.append("        sql.append(Backend.SQL_EQUAL_PAR);\n");
                                }
                            }
                            return buf.toString();
                        }
                        return "        sql.append(" + t + ");\n";
                    }
                };
                String code = this.getExpression().toCode((CodeGenerator)generator);
                if (code.endsWith("\n")) {
                    code = code.substring(0, code.length() - 1);
                }
                this.out.print(code);
                this.out.print(this.source[55]);
                if (andPrepended || needParentheses) {
                    this.out.print(this.source[56]);
                } else if (needParentheses && this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                    this.out.print(this.source[57]);
                }
            }
            if ((orderByStr = this.createOrderBy()) != null) {
                this.out.print(this.source[58]);
                this.out.print(orderByStr);
                this.out.print(this.source[59]);
            }
            this.out.print(this.source[60]);
            this.out.print(lock ? "true" : "false");
            this.out.print(this.source[61]);
            this.out.print(needLimit ? 1 : 0);
            this.out.print(this.source[62]);
            if (sort) {
                this.out.print(this.source[63]);
            }
            if (append != null) {
                this.out.print(this.source[64]);
                this.out.print(append);
                this.out.print(this.source[65]);
            }
            for (Relation relation : this.getJoinedRelations()) {
                String rightAttribute;
                String leftAttribute;
                if (relation.getRelationType() == RelationType.OBJECT) {
                    leftAttribute = "CN_" + relation.getAttribute().getJavaName().toUpperCase();
                    rightAttribute = "CN_ID";
                } else {
                    leftAttribute = "CN_ID";
                    rightAttribute = "CN_" + relation.getForeignAttribute().getJavaName().toUpperCase();
                }
                String leftClass = relation.getEntity().equals(this.getEntity()) ? "" : this.deriveClassNameForEntity(relation.getEntity()) + ".";
                String leftClassVariables = leftClass.isEmpty() ? "" : leftClass + "CLASSVARIABLES.";
                String rightClass = relation.getForeignEntity().equals(this.getEntity()) ? "" : this.deriveClassNameForEntity(relation.getForeignEntity()) + ".";
                this.out.print(this.source[66]);
                this.out.print(rightClass);
                this.out.print(this.source[67]);
                this.out.print(rightClass);
                this.out.print(this.source[68]);
                this.out.print(leftClassVariables);
                this.out.print(this.source[69]);
                this.out.print(leftClass);
                this.out.print(leftAttribute);
                this.out.print(this.source[70]);
                this.out.print(rightClass);
                this.out.print(this.source[71]);
                this.out.print(rightClass);
                this.out.print(rightAttribute);
                this.out.print(this.source[72]);
            }
            for (ComponentJoin cj : this.getComponentJoins()) {
                String leftClassVariables = "";
                if (!cj.getEntity().equals(this.getEntity())) {
                    leftClassVariables = this.deriveClassNameForEntity(cj.getEntity()) + ".CLASSVARIABLES.";
                }
                this.out.print(this.source[73]);
                this.out.print(cj.getRootIdClassName());
                this.out.print(this.source[74]);
                this.out.print(cj.getRootIdClassName());
                this.out.print(this.source[75]);
                this.out.print(leftClassVariables);
                this.out.print(this.source[76]);
                this.out.print(cj.getRootIdClassName());
                this.out.print(this.source[77]);
                this.out.print(cj.getRootIdColumnName());
                this.out.print(this.source[78]);
                if (!cj.isExtraJoinNecessary()) continue;
                this.out.print(this.source[79]);
                this.out.print(cj.getExtraClassName());
                this.out.print(this.source[80]);
                this.out.print(cj.getExtraClassName());
                this.out.print(this.source[81]);
                this.out.print(cj.getRootIdClassName());
                this.out.print(this.source[82]);
                this.out.print(cj.getExtraClassName());
                this.out.print(this.source[83]);
            }
            if (!this.getJoins().isEmpty()) {
                this.out.print(this.source[84]);
            }
            this.out.print(this.source[85]);
            if (needLimit) {
                this.out.print(this.source[86]);
            } else {
                this.out.print(this.source[87]);
            }
            if (!this.getJoins().isEmpty()) {
                this.out.print(this.source[88]);
            }
            if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.SINGLE) {
                this.out.print(this.source[89]);
            }
            if (this.getContextAttribute() != null) {
                this.out.print(this.source[90]);
                this.out.print(this.createJdbcSetterName(this.getContextAttribute()));
                this.out.print(this.source[91]);
                this.out.print(this.getContextAttribute().getJavaName());
                this.out.print(this.source[92]);
            }
            for (WurbletParameter par : this.getMethodParameters()) {
                if (!par.isSqlArg()) continue;
                Attribute attr = par.getAttribute();
                if (attr.getOptions().isMapNull()) {
                    this.out.print(this.source[93]);
                    this.out.print(this.createJdbcSetterName(attr));
                    this.out.print(this.source[94]);
                    this.out.print(this.getJdbcCode(attr, par.getSqlArg()));
                    this.out.print(this.source[95]);
                } else {
                    this.out.print(this.source[96]);
                    this.out.print(this.createJdbcSetterName(attr));
                    this.out.print(this.source[97]);
                    this.out.print(this.getJdbcCode(attr, par.getSqlArg()));
                    this.out.print(this.source[98]);
                }
                for (int p = 1; p < attr.getDataType().getSqlTypes().length; ++p) {
                    this.out.print(this.source[99]);
                }
            }
            if (needLimit) {
                this.out.print(this.source[100]);
            }
            if (this.getJoins().isEmpty()) {
                this.out.print(this.source[101]);
            } else {
                this.out.print(this.source[102]);
            }
            this.out.print(this.source[103]);
        }
        catch (Exception ex) {
            throw new WurbelException("wurblet " + (Object)((Object)this) + " failed", (Throwable)ex);
        }
    }
}

