/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.tentackle.buildsupport.RemoteMethodInfo;
import org.tentackle.common.NamingRules;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.persist.wurblet.RemoteMethodHelper;
import org.wurbelizer.wurbel.WurbelDiscardException;
import org.wurbelizer.wurbel.WurbelException;

public class RemoteMethod
extends DbModelWurblet {
    public RemoteMethod() {
        this.setConfiguration("missingModelOk");
    }

    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            this.wurbel();
        }
        catch (Throwable t) {
            if (t instanceof WurbelException) {
                throw (WurbelException)t;
            }
            throw new WurbelException("wurblet " + String.valueOf((Object)this) + " failed", t);
        }
    }

    private void wurbel() throws WurbelException {
        String instanceName = null;
        boolean addThis = false;
        boolean noContext = false;
        for (String arg : this.getOptionArgs()) {
            if (arg.startsWith("instance=")) {
                instanceName = arg.substring(9);
                continue;
            }
            if (arg.equals("this")) {
                addThis = true;
                continue;
            }
            if (!arg.equals("nocontext")) continue;
            noContext = true;
        }
        String methodName = this.getMethodName();
        String className = this.getClassName();
        if (className == null) {
            throw new WurbelException("can't determine <classname>");
        }
        String packageName = this.getPackageName();
        if (packageName == null) {
            throw new WurbelException("can't determine <packagename>");
        }
        boolean isPdoOrOperation = false;
        String pdoClassName = null;
        try {
            pdoClassName = this.getPdoClassName();
            isPdoOrOperation = true;
        }
        catch (WurbelException wurbelException) {
            // empty catch block
        }
        if (this.isRemote()) {
            RemoteIncludes genInc = new RemoteIncludes(this);
            PrintStream implOut = genInc.getImplementationStream();
            PrintStream remoteOut = genInc.getInterfaceStream();
            String infoName = (packageName + "." + className + "." + methodName).replace('.', '/') + ".remote";
            RemoteMethodInfo info = null;
            try {
                info = RemoteMethodInfo.readInfo((File)this.getContainer().getAnalyzeFile(infoName));
            }
            catch (IOException ex) {
                if (this.getContainer().getAnalyzeFile("error.log").exists()) {
                    genInc.discard();
                    throw new WurbelDiscardException("reading info '" + infoName + "' failed", (Throwable)ex);
                }
                throw new WurbelException("reading info '" + infoName + "' failed (@RemoteMethod annotation missing?)", (Throwable)ex);
            }
            RemoteMethodHelper helper = new RemoteMethodHelper(info, pdoClassName, addThis);
            boolean returningObject = helper.isReturningObject();
            boolean returningCollection = helper.isReturningCollection();
            boolean returningCursor = helper.isReturningCursor();
            boolean returningVoid = helper.isReturningVoid();
            methodName = helper.getMethodName();
            if (helper.isStaticMethod()) {
                throw new WurbelException("static methods cannot be --remote");
            }
            Object iparms = helper.getInvocationParameterString();
            String riparms = helper.getRemoteInvocationParameterString();
            Object dparms = helper.getDeclarationParameterString();
            if (isPdoOrOperation && !addThis && !noContext) {
                iparms = ((String)iparms).length() > 0 ? "getDomainContext(), " + (String)iparms : "getDomainContext()";
                dparms = ((String)dparms).length() > 0 ? "DomainContext context, " + (String)dparms : "DomainContext context";
            }
            String returnType = helper.getReturnType();
            String genType = helper.getGenericReturnType();
            String firstName = helper.getFirstName();
            boolean firstIsDb = helper.isFirstInstanceOfDb();
            boolean firstIsDomainContext = helper.isFirstInstanceOfDomainContext();
            String remoteDelegateName = this.isOperation() ? NamingRules.getInstance().getOperationRemoteInterface(pdoClassName != null ? pdoClassName : className) : NamingRules.getInstance().getPdoRemoteInterface(pdoClassName != null ? pdoClassName : className);
            String imethod = "getRemoteDelegate()";
            String setDomainContext = "setDomainContext(" + firstName + ")";
            String apply = null;
            if (returningObject) {
                apply = "configureRemoteObject(getDomainContext(), obj)";
            } else if (returningCollection) {
                apply = "configureRemoteObjects(getDomainContext(), list)";
            }
            Object dbObject = "newInstance(" + (firstIsDomainContext ? firstName : "context") + ")";
            if (!isPdoOrOperation || noContext) {
                dbObject = "dbObject";
            }
            if (addThis) {
                dbObject = "obj";
            } else if (instanceName != null) {
                dbObject = instanceName;
            }
            this.out.print(this.source[0]);
            if (returningObject) {
                String poType = this.isGenerified() ? "P" : this.getClassName();
                remoteOut.print(this.source[1]);
                remoteOut.print(returnType);
                remoteOut.print(this.source[2]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[3]);
                remoteOut.print((String)dparms);
                remoteOut.print(this.source[4]);
                implOut.print(this.source[5]);
                implOut.print(returnType);
                implOut.print(this.source[6]);
                implOut.print(methodName);
                implOut.print(this.source[7]);
                implOut.print((String)dparms);
                implOut.print(this.source[8]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[9]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[10]);
                }
                if (addThis) {
                    implOut.print(this.source[11]);
                    implOut.print(poType);
                    implOut.print(this.source[12]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[13]);
                    implOut.print(statement);
                    implOut.print(this.source[14]);
                }
                implOut.print(this.source[15]);
                implOut.print((String)dbObject);
                implOut.print(this.source[16]);
                implOut.print(methodName);
                implOut.print(this.source[17]);
                implOut.print(riparms);
                implOut.print(this.source[18]);
                this.out.print(this.source[19]);
                this.out.print(returnType);
                this.out.print(this.source[20]);
                this.out.print(imethod);
                this.out.print(this.source[21]);
                this.out.print(methodName);
                this.out.print(this.source[22]);
                this.out.print((String)iparms);
                this.out.print(this.source[23]);
                this.out.print(apply);
                this.out.print(this.source[24]);
            } else if (returningCollection) {
                remoteOut.print(this.source[25]);
                remoteOut.print(returnType);
                remoteOut.print(this.source[26]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[27]);
                remoteOut.print((String)dparms);
                remoteOut.print(this.source[28]);
                implOut.print(this.source[29]);
                implOut.print(returnType);
                implOut.print(this.source[30]);
                implOut.print(methodName);
                implOut.print(this.source[31]);
                implOut.print((String)dparms);
                implOut.print(this.source[32]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[33]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[34]);
                }
                if (addThis) {
                    implOut.print(this.source[35]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[36]);
                    implOut.print(statement);
                    implOut.print(this.source[37]);
                }
                implOut.print(this.source[38]);
                implOut.print((String)dbObject);
                implOut.print(this.source[39]);
                implOut.print(methodName);
                implOut.print(this.source[40]);
                implOut.print(riparms);
                implOut.print(this.source[41]);
                this.out.print(this.source[42]);
                this.out.print(returnType);
                this.out.print(this.source[43]);
                this.out.print(imethod);
                this.out.print(this.source[44]);
                this.out.print(methodName);
                this.out.print(this.source[45]);
                this.out.print((String)iparms);
                this.out.print(this.source[46]);
                this.out.print(apply);
                this.out.print(this.source[47]);
            } else if (returningCursor) {
                remoteOut.print(this.source[48]);
                remoteOut.print(genType);
                remoteOut.print(this.source[49]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[50]);
                remoteOut.print((String)dparms);
                remoteOut.print(this.source[51]);
                implOut.print(this.source[52]);
                implOut.print(genType);
                implOut.print(this.source[53]);
                implOut.print(methodName);
                implOut.print(this.source[54]);
                implOut.print((String)dparms);
                implOut.print(this.source[55]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[56]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[57]);
                }
                if (addThis) {
                    implOut.print(this.source[58]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[59]);
                    implOut.print(statement);
                    implOut.print(this.source[60]);
                }
                implOut.print(this.source[61]);
                implOut.print((String)dbObject);
                implOut.print(this.source[62]);
                implOut.print(methodName);
                implOut.print(this.source[63]);
                implOut.print(riparms);
                implOut.print(this.source[64]);
                if (isPdoOrOperation) {
                    this.out.print(this.source[65]);
                    this.out.print(imethod);
                    this.out.print(this.source[66]);
                    this.out.print(methodName);
                    this.out.print(this.source[67]);
                    this.out.print((String)iparms);
                    this.out.print(this.source[68]);
                } else {
                    this.out.print(this.source[69]);
                    this.out.print(imethod);
                    this.out.print(this.source[70]);
                    this.out.print(methodName);
                    this.out.print(this.source[71]);
                    this.out.print((String)iparms);
                    this.out.print(this.source[72]);
                }
            } else if (returningVoid) {
                remoteOut.print(this.source[73]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[74]);
                remoteOut.print((String)dparms);
                remoteOut.print(this.source[75]);
                implOut.print(this.source[76]);
                implOut.print(methodName);
                implOut.print(this.source[77]);
                implOut.print((String)dparms);
                implOut.print(this.source[78]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[79]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[80]);
                }
                if (addThis) {
                    implOut.print(this.source[81]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[82]);
                    implOut.print(statement);
                    implOut.print(this.source[83]);
                }
                implOut.print(this.source[84]);
                implOut.print((String)dbObject);
                implOut.print(this.source[85]);
                implOut.print(methodName);
                implOut.print(this.source[86]);
                implOut.print(riparms);
                implOut.print(this.source[87]);
                this.out.print(this.source[88]);
                this.out.print(imethod);
                this.out.print(this.source[89]);
                this.out.print(methodName);
                this.out.print(this.source[90]);
                this.out.print((String)iparms);
                this.out.print(this.source[91]);
            } else {
                remoteOut.print(this.source[92]);
                remoteOut.print(returnType);
                remoteOut.print(this.source[93]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[94]);
                remoteOut.print((String)dparms);
                remoteOut.print(this.source[95]);
                implOut.print(this.source[96]);
                implOut.print(returnType);
                implOut.print(this.source[97]);
                implOut.print(methodName);
                implOut.print(this.source[98]);
                implOut.print((String)dparms);
                implOut.print(this.source[99]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[100]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[101]);
                }
                if (addThis) {
                    implOut.print(this.source[102]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[103]);
                    implOut.print(statement);
                    implOut.print(this.source[104]);
                }
                implOut.print(this.source[105]);
                implOut.print((String)dbObject);
                implOut.print(this.source[106]);
                implOut.print(methodName);
                implOut.print(this.source[107]);
                implOut.print(riparms);
                implOut.print(this.source[108]);
                this.out.print(this.source[109]);
                this.out.print(imethod);
                this.out.print(this.source[110]);
                this.out.print(methodName);
                this.out.print(this.source[111]);
                this.out.print((String)iparms);
                this.out.print(this.source[112]);
            }
            this.out.print(this.source[113]);
        } else {
            this.out.print(this.source[114]);
        }
    }
}

