/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import org.tentackle.model.Attribute;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.Join;
import org.tentackle.wurblet.WurbletArgument;
import org.tentackle.wurblet.WurbletArgumentExpression;
import org.tentackle.wurblet.WurbletArgumentOperator;
import org.wurbelizer.wurbel.WurbelException;

public class JoinClauseGenerator
implements CodeGenerator<Object> {
    private final DbModelWurblet wurblet;
    private final Join join;

    public JoinClauseGenerator(DbModelWurblet wurblet, Join join) {
        this.wurblet = wurblet;
        this.join = join;
    }

    public String generate() throws WurbelException {
        return " AND " + this.generate(this.join.getWurbletRelation().getParser().getExpression());
    }

    public String generate(Object t) throws WurbelException {
        if (t instanceof WurbletArgumentOperator) {
            WurbletArgumentOperator operator = (WurbletArgumentOperator)t;
            return " " + operator.getText() + " ";
        }
        if (t instanceof WurbletArgumentExpression) {
            WurbletArgumentExpression expression = (WurbletArgumentExpression)t;
            return "(" + expression.toCode((CodeGenerator)this) + ")";
        }
        if (t instanceof WurbletArgument) {
            WurbletArgument argument = (WurbletArgument)t;
            StringBuilder buf = new StringBuilder();
            Attribute attribute = argument.getAttribute();
            for (int columnIndex = 0; columnIndex < argument.getDataType().getColumnCount(null); ++columnIndex) {
                if (columnIndex > 0 && argument.getColumnIndex() == null) {
                    buf.append(" AND ");
                }
                if (argument.getColumnIndex() == null || columnIndex == argument.getColumnIndex()) {
                    buf.append(this.join.getName()).append('.').append(attribute.getColumnName());
                }
                buf.append(this.wurblet.createRelopSql(argument));
            }
            return buf.toString();
        }
        return " " + String.valueOf(t) + " ";
    }
}

