/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.List;
import java.util.Set;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.wurblet.CodeGenerator;
import org.tentackle.wurblet.ComponentInfo;
import org.tentackle.wurblet.WurbletArgument;
import org.tentackle.wurblet.WurbletArgumentExpression;
import org.tentackle.wurblet.WurbletArgumentOperator;
import org.wurbelizer.wurbel.WurbelException;

public class WhereClauseGenerator
implements CodeGenerator<Object> {
    private final DbModelWurblet wurblet;

    public WhereClauseGenerator(DbModelWurblet wurblet) {
        this.wurblet = wurblet;
    }

    public String generate(Object t) throws WurbelException {
        if (t instanceof WurbletArgumentOperator) {
            WurbletArgumentOperator operator = (WurbletArgumentOperator)t;
            return "        sql.append(Backend." + operator.getSql() + ");\n";
        }
        if (t instanceof WurbletArgumentExpression) {
            WurbletArgumentExpression expression = (WurbletArgumentExpression)t;
            return "        sql.append(Backend.SQL_LEFT_PARENTHESIS);\n" + expression.toCode((CodeGenerator)this) + "        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n";
        }
        if (t instanceof WurbletArgument) {
            WurbletArgument argument = (WurbletArgument)t;
            StringBuilder buf = new StringBuilder();
            Attribute attribute = argument.getAttribute();
            if (argument.isPath()) {
                Set existsRelations = argument.getExistsRelations();
                if (existsRelations != null) {
                    String rightClass;
                    buf.append("        sql.append(Backend.SQL_EXISTS)\n");
                    String comma = "";
                    for (Entity component : argument.getExistsComponents()) {
                        ComponentInfo ci = this.wurblet.createComponentInfo(component);
                        rightClass = ci.getRootIdClassName();
                        buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                        comma = "Backend.SQL_COMMA).append(";
                        if (!ci.isExtraJoinNecessary()) continue;
                        buf.append("           .append(").append(comma).append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(ci.getExtraClassName()).append(".CLASSVARIABLES.getTableAlias())\n");
                    }
                    for (Relation relation : existsRelations) {
                        rightClass = this.wurblet.deriveClassNameForEntity(relation.getForeignEntity());
                        buf.append("           .append(").append(comma).append(rightClass).append(".CLASSVARIABLES.getTableName())\n").append("           .append(getBackend().sqlAsBeforeTableAlias())\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getTableAlias())\n");
                        comma = "Backend.SQL_COMMA).append(";
                    }
                    buf.append("           .append(Backend.SQL_WHERE)\n");
                    for (Entity component : argument.getExistsComponents()) {
                        ComponentInfo componentInfo = this.wurblet.createComponentInfo(component);
                        rightClass = componentInfo.getRootIdClassName();
                        buf.append("           .append(getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append(".CLASSVARIABLES.getColumnName(").append(componentInfo.getRootIdColumnName()).append("))\n").append("           .append(Backend.SQL_AND)\n");
                        if (!componentInfo.isExtraJoinNecessary()) continue;
                        buf.append("           .append(").append(componentInfo.getRootIdClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID)).append(Backend.SQL_EQUAL)\n").append("           .append(").append(componentInfo.getExtraClassName()).append(".CLASSVARIABLES.getColumnName(CN_ID))\n").append("           .append(Backend.SQL_AND)\n");
                    }
                    for (Relation relation : existsRelations) {
                        String rightAttribute;
                        Object leftAttribute;
                        boolean isEmbeddingRelation = false;
                        if (relation.getRelationType() == RelationType.OBJECT) {
                            if (relation.isEmbedded()) {
                                isEmbeddingRelation = true;
                                leftAttribute = "\"" + argument.getEmbeddingColumnPrefix() + ((MethodArgument)relation.getMethodArgs().getFirst()).getAttribute().getColumnName() + "\"";
                            } else {
                                leftAttribute = this.wurblet.getColumnNameConstant(relation.getAttribute(), 0);
                            }
                            rightAttribute = "CN_ID";
                        } else {
                            leftAttribute = "CN_ID";
                            rightAttribute = this.wurblet.getColumnNameConstant(relation.getForeignAttribute(), 0);
                        }
                        String leftClass = relation.getEntity().equals((Object)this.wurblet.getEntity()) ? "" : this.wurblet.deriveClassNameForEntity(relation.getEntity()) + ".";
                        String leftClassVariables = leftClass.isEmpty() || isEmbeddingRelation ? "" : leftClass + "CLASSVARIABLES.";
                        rightClass = relation.getForeignEntity().equals((Object)this.wurblet.getEntity()) ? "" : this.wurblet.deriveClassNameForEntity(relation.getForeignEntity()) + ".";
                        buf.append("           .append(").append(leftClassVariables).append("getColumnName(").append((String)leftAttribute).append(")).append(Backend.SQL_EQUAL)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(rightAttribute).append("))\n").append("           .append(Backend.SQL_AND)\n");
                        List methodArguments = relation.getMethodArgs();
                        for (MethodArgument methodArgument : methodArguments.subList(1, methodArguments.size())) {
                            Attribute methodAttribute = methodArgument.getForeignAttribute();
                            buf.append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(this.wurblet.getColumnNameConstant(methodAttribute, 0)).append("))\n");
                            if (methodArgument.isValue()) {
                                buf.append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                for (int columnIndex = 1; columnIndex < this.wurblet.getEffectiveDataType(attribute).getColumnCount(null); ++columnIndex) {
                                    buf.append("           .append(Backend.SQL_AND)\n").append("           .append(").append(rightClass).append("CLASSVARIABLES.getColumnName(").append(rightClass).append(this.wurblet.getColumnNameConstant(attribute, columnIndex)).append("))\n").append("           .append(Backend.SQL_EQUAL_PAR)\n");
                                }
                            } else {
                                buf.append("           .append(Backend.SQL_EQUAL).append(").append(leftClassVariables).append("getColumnName(").append(leftClassVariables).append(this.wurblet.getColumnNameConstant(methodArgument.getAttribute(), 0)).append("))\n");
                            }
                            buf.append("           .append(Backend.SQL_AND)\n");
                        }
                    }
                    buf.deleteCharAt(buf.length() - 1).append(";\n");
                }
                String compKeyClass = this.wurblet.deriveClassNameForEntity(attribute.getEmbeddingPath() == null ? attribute.getEntity() : (Entity)attribute.getEmbeddingPath().getFirst());
                for (int columnIndex = 0; columnIndex < argument.getDataType().getColumnCount(null); ++columnIndex) {
                    if (columnIndex > 0 && argument.getColumnIndex() == null) {
                        buf.append("        sql.append(Backend.SQL_AND);\n");
                    }
                    if (argument.getColumnIndex() != null && columnIndex != argument.getColumnIndex()) continue;
                    buf.append("        sql.append(").append(compKeyClass).append(".CLASSVARIABLES.getColumnName(");
                    if (attribute.getEmbeddingPath() != null) {
                        try {
                            buf.append('\"').append(attribute.getColumnName(null, columnIndex)).append("\"))\n");
                        }
                        catch (ModelException mx) {
                            throw new WurbelException("cannot determine embedded column name", (Throwable)mx);
                        }
                    } else {
                        buf.append(compKeyClass).append('.').append(this.wurblet.getColumnNameConstant(attribute, columnIndex)).append("))\n");
                    }
                    buf.append("           ").append(this.wurblet.createRelopCode(argument)).append(";\n");
                }
            } else {
                for (int columnIndex = 0; columnIndex < argument.getDataType().getColumnCount(null); ++columnIndex) {
                    if (columnIndex > 0 && argument.getColumnIndex() == null) {
                        buf.append("        sql.append(Backend.SQL_AND);\n");
                    }
                    if (argument.getColumnIndex() != null && columnIndex != argument.getColumnIndex()) continue;
                    if (this.wurblet.isPathAllowed()) {
                        if (this.wurblet.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                            buf.append("        sql.append(").append(this.wurblet.deriveClassNameForEntity(attribute.getEntity())).append(".CLASSVARIABLES.getColumnName(").append(this.wurblet.getColumnNameConstant(attribute, columnIndex)).append("));\n");
                        } else if (this.wurblet.isPdo()) {
                            buf.append("        sql.append(getColumnName(");
                            if (attribute.isEmbedded()) {
                                buf.append('\"').append(attribute.getColumnName()).append('\"');
                            } else {
                                buf.append(this.wurblet.getColumnNameConstant(attribute, columnIndex));
                            }
                            buf.append("));\n");
                        } else {
                            buf.append("        sql.append(").append(this.wurblet.getColumnNameConstant(attribute, columnIndex)).append(");\n");
                        }
                    } else {
                        buf.append("        sql.append(");
                        if (attribute.isEmbedded()) {
                            buf.append("getColumnPrefix() + ");
                        }
                        buf.append(this.wurblet.getColumnNameConstant(attribute, columnIndex)).append(");\n");
                    }
                    buf.append("        sql").append(this.wurblet.createRelopCode(argument)).append(";\n");
                }
            }
            if (argument.isEndOfExistsClause()) {
                buf.append("        sql.append(Backend.SQL_RIGHT_PARENTHESIS);\n");
            }
            return buf.toString();
        }
        return "        sql.append(" + String.valueOf(t) + ");\n";
    }
}

