/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.tentackle.common.StringHelper;
import org.tentackle.model.Attribute;
import org.tentackle.model.AttributeSorting;
import org.tentackle.model.DataType;
import org.tentackle.model.Entity;
import org.tentackle.model.InheritanceType;
import org.tentackle.model.MethodArgument;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.RelationType;
import org.tentackle.model.SelectionType;
import org.tentackle.model.SortType;
import org.tentackle.model.TrackType;
import org.tentackle.persist.wurblet.ComponentInfo;
import org.tentackle.persist.wurblet.Join;
import org.tentackle.persist.wurblet.JoinPath;
import org.tentackle.persist.wurblet.WurbletArgument;
import org.tentackle.persist.wurblet.WurbletArgumentExpression;
import org.tentackle.persist.wurblet.WurbletArgumentParser;
import org.tentackle.wurblet.ModelWurblet;
import org.wurbelizer.wurbel.WurbelException;

public class DbModelWurblet
extends ModelWurblet {
    private boolean argumentGroupingEnabled;
    private boolean pathAllowed;
    private boolean tracked;
    private boolean attracked;
    private boolean fullTracked;
    private Attribute contextAttribute;
    private List<JoinPath> joinPaths;
    private WurbletArgumentParser parser;

    public boolean isArgumentGroupingEnabled() {
        return this.argumentGroupingEnabled;
    }

    public boolean isPathAllowed() {
        return this.pathAllowed;
    }

    public void run() throws WurbelException {
        String wurbletOptions = this.getConfiguration();
        if (wurbletOptions != null) {
            if (wurbletOptions.contains("groupArgs")) {
                this.argumentGroupingEnabled = true;
            } else if (wurbletOptions.contains("pathAllowed")) {
                this.pathAllowed = true;
            }
        }
        super.run();
        this.tracked = this.getEntity().getOptions().getTrackType().isTracked();
        this.attracked = this.getEntity().getOptions().getTrackType().isAttracked();
        this.fullTracked = this.getEntity().getOptions().getTrackType() == TrackType.FULLTRACKED;
        this.contextAttribute = this.getEntity().getContextIdAttribute();
        for (String string : this.getOptionArgs()) {
            if ("tracked".equals(string)) {
                this.tracked = true;
                this.attracked = false;
                this.fullTracked = false;
                continue;
            }
            if ("attracked".equals(string)) {
                this.tracked = true;
                this.attracked = true;
                this.fullTracked = false;
                continue;
            }
            if ("fulltracked".equals(string)) {
                this.tracked = true;
                this.attracked = true;
                this.fullTracked = true;
                continue;
            }
            if ("untracked".equals(string)) {
                this.tracked = false;
                this.attracked = false;
                this.fullTracked = false;
                continue;
            }
            if (!string.startsWith("context=")) continue;
            String ctx = string.substring(8);
            if (ctx.length() == 0) {
                this.contextAttribute = null;
                continue;
            }
            this.contextAttribute = this.getEntity().getAttributeByJavaName(string.substring(8), false);
        }
        this.parser = new WurbletArgumentParser(this.getEntity(), this.argumentGroupingEnabled, this.getWurbletArgs());
        if (!this.pathAllowed) {
            for (WurbletArgument wurbletArgument : this.parser.getAllArguments()) {
                if (!wurbletArgument.isPath()) continue;
                throw new WurbelException("relation paths not allowed in wurblet " + (Object)((Object)this));
            }
        }
        if (this.isRemote()) {
            for (WurbletArgument wurbletArgument : this.parser.getJoinArguments()) {
                for (Relation relation : wurbletArgument.getRelations()) {
                    if (!relation.isComposite() && !relation.isSerialized() && relation.getSelectionType() != SelectionType.EAGER) {
                        throw new WurbelException("joined non-composite relation '" + relation.getName() + "' must be serialized for remote access");
                    }
                    Relation opRel = relation.getForeignRelation();
                    if (opRel == null || opRel.isSerialized() || opRel.isComposite()) continue;
                    throw new WurbelException("joined opposite relation '" + opRel.getEntity() + "." + opRel.getName() + "' must be serialized for remote access");
                }
            }
        }
    }

    public boolean isTracked() {
        return this.tracked;
    }

    public boolean isAttracked() {
        return this.attracked;
    }

    public boolean isFullTracked() {
        return this.fullTracked;
    }

    public Attribute getContextAttribute() {
        return this.contextAttribute;
    }

    public boolean isClassIdRequiredInWhereClause(Entity entity) {
        return !entity.isAbstract() && entity.getSuperEntity() != null && entity.getHierarchyInheritanceType().isMappingToSuperTable();
    }

    public boolean isClassIdRequiredInWhereClause() {
        return this.isClassIdRequiredInWhereClause(this.getEntity());
    }

    public boolean isEntityPersistable() {
        return !this.getEntity().isAbstract() || !this.getEntity().getHierarchyInheritanceType().isMappingToNoTable();
    }

    public void assertEntityIsPersistable() throws WurbelException {
        if (!this.isEntityPersistable()) {
            throw new WurbelException(this.getEntity() + " does not map to any table and is not persistable");
        }
    }

    public List<WurbletArgument> getMethodArguments() {
        return this.parser.getMethodArguments();
    }

    public List<WurbletArgument> getExpressionArguments() {
        return this.parser.getExpressionArguments();
    }

    public List<WurbletArgument> getExtraArguments() {
        return this.parser.getExtraArguments();
    }

    public WurbletArgumentExpression getExpression() {
        return this.parser.getExpression();
    }

    public List<WurbletArgument> getSortingArguments() {
        return this.parser.getSortingArguments();
    }

    public boolean isWithSorting() {
        return !this.getSortingArguments().isEmpty();
    }

    public List<AttributeSorting> getDefaultSorting() {
        for (Entity entity = this.getEntity(); entity != null; entity = entity.getSuperEntity()) {
            List sorting = entity.getSorting();
            if (sorting == null || sorting.isEmpty()) continue;
            return sorting;
        }
        return null;
    }

    public List<WurbletArgument> getDefaultSortKeys() throws WurbelException {
        ArrayList<WurbletArgument> sortKeys = new ArrayList<WurbletArgument>();
        List<AttributeSorting> sorting = this.getDefaultSorting();
        if (sorting != null) {
            for (AttributeSorting as : sorting) {
                WurbletArgument key = this.parser.createArgument(as.toString(), true, false);
                sortKeys.add(key);
            }
        }
        return sortKeys;
    }

    public boolean isWithDefaultSorting() {
        return this.getDefaultSorting() != null;
    }

    public List<JoinPath> getJoinPaths() {
        if (this.joinPaths == null) {
            this.joinPaths = this.parser.getJoinPaths();
            for (JoinPath path : this.joinPaths) {
                path.normalize();
            }
        }
        return this.joinPaths;
    }

    public boolean isWithJoins() {
        return !this.getJoinPaths().isEmpty();
    }

    public String createOrderBy(List<WurbletArgument> sortKeys) throws WurbelException {
        if (!sortKeys.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            boolean needComma = false;
            for (WurbletArgument key : sortKeys) {
                Attribute attr = key.getAttribute();
                for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                    if (needComma) {
                        buf.append("\n           .append(Backend.SQL_COMMA)");
                    }
                    String name = "CN_" + attr.getName().toUpperCase() + sp.getPostfix();
                    buf.append(".append(");
                    if (this.getEntity().getHierarchyInheritanceType() == InheritanceType.MULTI) {
                        buf.append(this.deriveClassNameForEntity(this.getEntity().getTopSuperEntity())).append(".CLASSVARIABLES.getColumnName(").append(name).append(')');
                    } else if (!this.getEntity().equals(attr.getEntity())) {
                        boolean joinFound = false;
                        for (JoinPath joinPath : this.getJoinPaths()) {
                            Join join = joinPath.findJoin(key.getRelations());
                            if (join == null) continue;
                            buf.append('\"').append(join.getName()).append('.').append(attr.getColumnName()).append('\"');
                            joinFound = true;
                            break;
                        }
                        if (!joinFound) {
                            throw new WurbelException("missing join for sort key: " + key);
                        }
                    } else if (this.isPdo()) {
                        buf.append("getColumnName(").append(name).append(')');
                    } else {
                        buf.append(name);
                    }
                    buf.append(").append(").append(SortType.ASC == key.getSortType() ? "Backend.SQL_SORTASC" : "Backend.SQL_SORTDESC").append(')');
                    needComma = true;
                }
            }
            return buf.toString();
        }
        return null;
    }

    public String createOrderBy() throws WurbelException {
        return this.createOrderBy(this.getSortingArguments());
    }

    public String createJoins() throws WurbelException {
        StringBuilder buf = new StringBuilder();
        String pdoType = this.getPdoClassName();
        if (this.isGenerified()) {
            pdoType = "T";
        }
        buf.append("    JoinedSelect<").append(pdoType).append("> js = new JoinedSelect<").append(pdoType).append(">()\n");
        this.createJoinsImpl(buf, "      ", this.getJoinPaths(), pdoType, null);
        buf.replace(buf.length() - 1, buf.length(), ";\n");
        return buf.toString();
    }

    private void createJoinsImpl(StringBuilder buf, String inset, List<JoinPath> paths, String pdoType, String parentName) throws WurbelException {
        for (JoinPath path : paths) {
            List<JoinPath> subPaths;
            String lastJoinName = null;
            if (!path.getElements().isEmpty()) {
                Join join = path.getElements().get(0);
                Relation relation = join.getRelation();
                lastJoinName = join.getName();
                String poImpl = this.deriveClassNameForEntity(relation.getEntity());
                String alias = relation.getEntity().getTopSuperEntity().getTableAlias();
                String leftClass = relation.getEntity().equals(this.getEntity()) ? pdoType : relation.getEntity().getName();
                String joinClass = relation.getForeignEntity().getName();
                String joinAlias = relation.getForeignEntity().getTableProvidingEntity().getTableAlias();
                buf.append(inset).append(".addJoin(\n");
                if (relation.getRelationType() == RelationType.LIST) {
                    buf.append(inset).append("  new Join<>(JoinType.LEFT, ");
                    if (parentName == null) {
                        buf.append("getColumnName(CN_ID), \"");
                    } else {
                        buf.append('\"').append(parentName).append(".id\", \"");
                    }
                    buf.append(join.getName()).append('.').append(relation.getForeignAttribute().getColumnName()).append("\", ").append(joinClass).append(".class, \"").append(join.getName()).append("\",\n");
                    String extraSql = this.createOptionalWhereForJoin(relation, parentName, join.getName());
                    if (!extraSql.isEmpty()) {
                        buf.append(inset).append("             ").append(extraSql).append(",\n");
                    }
                    buf.append(inset).append("    (").append(leftClass).append(" ").append(alias).append(", ").append(joinClass).append(" ").append(joinAlias).append(") -> {\n");
                    if (relation.isReversed()) {
                        buf.append(inset).append("      ((").append(poImpl).append(") ").append(alias).append(".getPersistenceDelegate()).").append(relation.getSetterName());
                        if (relation.isSerialized()) {
                            buf.append("Blunt");
                        }
                        buf.append("(").append(joinAlias).append(");\n");
                    } else {
                        buf.append(inset).append("      ((").append(poImpl).append(") ").append(alias).append(".getPersistenceDelegate()).").append(relation.getGetterName()).append("Blunt().addBlunt(").append(joinAlias).append(");\n");
                        if (relation.getLinkMethodName() != null) {
                            String joinImpl = this.deriveClassNameForEntity(relation.getForeignEntity());
                            buf.append(inset).append("      ((").append(joinImpl).append(") ").append(joinAlias).append(".getPersistenceDelegate()).").append(this.createRelationUpdateReferenceCode(relation, alias, true)).append(";\n");
                        }
                    }
                } else {
                    buf.append(inset).append("  new Join<>(JoinType.LEFT, ");
                    if (parentName == null) {
                        buf.append("getColumnName(CN_").append(relation.getAttribute().getName().toUpperCase()).append("), \"");
                    } else {
                        buf.append('\"').append(parentName).append('.').append(relation.getAttribute().getColumnName()).append("\", \"");
                    }
                    buf.append(join.getName()).append(".id\", ").append(joinClass).append(".class, \"").append(join.getName()).append("\",\n").append(inset).append("    (").append(leftClass).append(" ").append(alias).append(", ").append(joinClass).append(" ").append(joinAlias).append(") -> {\n").append(inset).append("      ((").append(poImpl).append(") ").append(alias).append(".getPersistenceDelegate()).").append(relation.getSetterName());
                    if (relation.isSerialized()) {
                        buf.append("Blunt");
                    }
                    buf.append("(").append(joinAlias).append(");\n");
                }
                buf.append(inset).append("    }\n").append(inset).append("  )\n");
            }
            if (!(subPaths = path.getPaths()).isEmpty()) {
                Entity subEntity = subPaths.get(0).getElements().get(0).getRelation().getEntity();
                this.createJoinsImpl(buf, inset + "  ", subPaths, subEntity.getName(), lastJoinName);
            }
            buf.append(inset).append(")\n");
        }
    }

    private String createOptionalWhereForJoin(Relation relation, String parentName, String joinName) {
        StringBuilder buf = new StringBuilder();
        List methodArgs = relation.getMethodArgs();
        if (methodArgs.size() > 1) {
            for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                Attribute attr = methodArg.getForeignAttribute();
                buf.append("\" AND ").append(joinName).append('.').append(attr.getColumnName()).append('=');
                if (methodArg.isValue()) {
                    buf.append('?');
                    for (DataType.SqlTypeWithPostfix sp : attr.getDataType().getSqlTypesWithPostfix()) {
                        String name = attr.getName().toUpperCase() + sp.getPostfix();
                        boolean mainColumn = sp.getPostfix().isEmpty();
                        if (mainColumn) continue;
                        buf.append(" AND ").append(joinName).append('.').append(name).append("=?");
                    }
                    buf.append('\"');
                    continue;
                }
                attr = methodArg.getAttribute();
                if (parentName == null) {
                    buf.append("\" + getColumnName(CN_").append(attr.getName().toUpperCase()).append(")");
                    continue;
                }
                buf.append('\"').append(parentName).append('.').append(attr.getColumnName()).append("\"");
            }
        }
        return buf.toString();
    }

    public String createJoinSetPars() throws WurbelException {
        StringBuilder buf = new StringBuilder();
        for (JoinPath path : this.getJoinPaths()) {
            this.createJoinSetPars(buf, path);
        }
        return buf.toString();
    }

    private void createJoinSetPars(StringBuilder buf, JoinPath path) throws WurbelException {
        if (!path.getElements().isEmpty()) {
            List methodArgs;
            Join join = path.getElements().get(0);
            Relation relation = join.getRelation();
            if (this.isClassIdRequiredInWhereClause(relation.getForeignEntity())) {
                buf.append("    st.setInt(ndx++, ").append(relation.getForeignEntity().getClassId()).append(");\n");
            }
            if ((methodArgs = relation.getMethodArgs()).size() > 1) {
                for (MethodArgument methodArg : methodArgs.subList(1, methodArgs.size())) {
                    if (!methodArg.isValue()) continue;
                    Attribute attr = methodArg.getForeignAttribute();
                    buf.append("    st.").append(this.createJdbcSetterName(attr)).append("(ndx++, ").append(this.getJdbcCode(attr, attr.toMethodArgument(methodArg.getValue())));
                    if (attr.getOptions().isMapNull()) {
                        buf.append(", true);\n");
                    } else {
                        buf.append(");\n");
                    }
                    for (int p = 1; p < attr.getDataType().getSqlTypes().length; ++p) {
                        buf.append("    ndx++;\n");
                    }
                }
            }
            for (JoinPath subPath : path.getPaths()) {
                this.createJoinSetPars(buf, subPath);
            }
        }
    }

    public String createStatementId() throws WurbelException {
        StringBuilder buf = new StringBuilder();
        String id = this.getGuardName();
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isUpperCase(c) && buf.length() > 0) {
                buf.append('_');
            }
            buf.append(Character.toUpperCase(c));
        }
        buf.append("_STMT");
        return buf.toString();
    }

    public String buildMethodParameters(boolean limit, boolean offset) throws WurbelException {
        StringBuilder params = new StringBuilder();
        if (limit) {
            this.appendCommaSeparated(params, "int limit");
        }
        if (offset) {
            this.appendCommaSeparated(params, "int offset");
        }
        HashSet<String> argSet = new HashSet<String>();
        for (WurbletArgument key : this.getMethodArguments()) {
            String arg;
            if (!key.isMethodArgument() || !argSet.add(arg = key.getMethodArgumentName())) continue;
            Attribute attr = key.getAttribute();
            try {
                this.appendCommaSeparated(params, attr.getJavaType());
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java type for key " + key, (Throwable)me);
            }
            params.append(' ');
            params.append(arg);
        }
        return params.toString();
    }

    public String buildMethodParameters() throws WurbelException {
        return this.buildMethodParameters(false, false);
    }

    public String buildInvocationParameters(boolean limit, boolean offset) throws WurbelException {
        StringBuilder params = new StringBuilder();
        if (limit) {
            this.appendCommaSeparated(params, "limit");
        }
        if (offset) {
            this.appendCommaSeparated(params, "offset");
        }
        HashSet<String> argSet = new HashSet<String>();
        for (WurbletArgument key : this.getMethodArguments()) {
            String arg;
            if (!key.isMethodArgument() || !argSet.add(arg = key.getMethodArgumentName())) continue;
            this.appendCommaSeparated(params, arg);
        }
        return params.toString();
    }

    public String buildInvocationParameters() throws WurbelException {
        return this.buildInvocationParameters(false, false);
    }

    public String acs(String str, String appendStr) {
        StringBuilder builder = new StringBuilder(str);
        this.appendCommaSeparated(builder, appendStr);
        return builder.toString();
    }

    public String pcs(String str, String prependStr) {
        StringBuilder builder = new StringBuilder(str);
        this.prependCommaSeparated(builder, prependStr);
        return builder.toString();
    }

    public String aas(String str) {
        if (str != null && str.length() > 0) {
            return ", " + str;
        }
        return "";
    }

    public String as(String str) {
        return str == null ? "" : str;
    }

    public DataType getJdbcDataType(Attribute attribute) throws WurbelException {
        try {
            return attribute.getEffectiveType();
        }
        catch (ModelException me) {
            throw new WurbelException("cannot determine effective JDBC datatype for " + attribute, (Throwable)me);
        }
    }

    public String createJdbcSetterName(Attribute attribute) throws WurbelException {
        StringBuilder buf = new StringBuilder("set");
        DataType type = this.getJdbcDataType(attribute);
        if (type.isPrimitive()) {
            buf.append(StringHelper.firstToUpper((String)type.toString()));
        } else {
            buf.append(type.toString());
        }
        return buf.toString();
    }

    public String createJdbcGetterName(Attribute attribute) throws WurbelException {
        StringBuilder buf = new StringBuilder("get");
        DataType type = this.getJdbcDataType(attribute);
        if (type.isPrimitive()) {
            buf.append(StringHelper.firstToUpper((String)type.toString()));
        } else if (type == DataType.BOOLEAN) {
            buf.append("ABoolean");
        } else if (type == DataType.BYTE) {
            buf.append("AByte");
        } else if (type == DataType.SHORT) {
            buf.append("AShort");
        } else if (type == DataType.LONG) {
            buf.append("ALong");
        } else if (type == DataType.FLOAT) {
            buf.append("AFloat");
        } else if (type == DataType.DOUBLE) {
            buf.append("ADouble");
        } else {
            buf.append(type.toString());
        }
        return buf.toString();
    }

    public String getModelCode(Attribute attribute, String jdbcCode) throws WurbelException {
        if (attribute.getDataType() == DataType.APPLICATION) {
            try {
                return attribute.getJavaType() + ".toInternal(" + jdbcCode + ")";
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java model-side code for " + attribute + ": " + jdbcCode, (Throwable)me);
            }
        }
        return jdbcCode;
    }

    public String getJdbcCode(Attribute attribute, String modelCode) throws WurbelException {
        String jdbcCode = modelCode;
        if (attribute.getDataType() == DataType.APPLICATION) {
            try {
                String applicationType = attribute.getApplicationType();
                jdbcCode = modelCode.startsWith(applicationType + ".") ? modelCode + ".toExternal()" : (attribute.getInnerType().isPrimitive() ? modelCode + " == null ? " + applicationType + ".getDefault().toExternal() : " + modelCode + ".toExternal()" : modelCode + " == null ? null : " + modelCode + ".toExternal()");
            }
            catch (ModelException me) {
                throw new WurbelException("cannot determine java jdbc-side code for " + attribute + ": " + modelCode, (Throwable)me);
            }
        }
        return jdbcCode;
    }

    public boolean isRelationTransient(Relation relation) {
        return relation.getSelectionType() == SelectionType.LAZY && !relation.isComposite() && !relation.isSerialized();
    }

    public String createRelationArgString(Relation relation) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        List args = relation.getMethodArgs();
        boolean first = true;
        for (MethodArgument arg : args) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(arg.getMethodArgument());
        }
        buf.append(')');
        return buf.toString();
    }

    public String createRelationWurbletArgString(Relation relation) {
        StringBuilder buf = new StringBuilder();
        List args = relation.getMethodArgs();
        for (MethodArgument arg : args) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(arg.getForeignAttribute().getName());
        }
        return buf.toString();
    }

    public String createRelationSelectCode(Relation relation) {
        StringBuilder text = new StringBuilder();
        if (relation.getForeignEntity().isAbstract() && relation.getRelationType() == RelationType.OBJECT && relation.getMethodName() == null) {
            text.append("(").append(relation.getClassName()).append("<?>) ");
        }
        text.append("on(").append(relation.getClassName()).append(".class).").append(this.createRelationSelectMethodName(relation)).append(this.createRelationArgString(relation));
        return text.toString();
    }

    public String createRelationUpdateReferenceCode(Relation relation, String pdo, boolean blunt) {
        Relation foreignRel = relation.getForeignRelation();
        if (blunt && (foreignRel == null || foreignRel.getRelationType() != RelationType.OBJECT || !foreignRel.isSerialized() || foreignRel.getSelectionType() != SelectionType.LAZY && foreignRel.getSelectionType() != SelectionType.EAGER)) {
            blunt = false;
        }
        if (!blunt && relation.getLinkMethodName() != null) {
            return relation.getLinkMethodName() + (relation.getLinkMethodIndex() != null ? "(" + pdo + ", ndx++)" : "(" + pdo + ")");
        }
        if (foreignRel != null) {
            return foreignRel.getSetterName() + (blunt ? "Blunt" : "") + "(" + pdo + ")";
        }
        return "set" + relation.getForeignEntity() + (blunt ? "Blunt" : "") + "(" + pdo + ")";
    }

    public String createRelationUpdateReferenceCode(Relation relation) {
        return this.createRelationUpdateReferenceCode(relation, "me()", false);
    }

    public String createRelationSetFirstArgMethodName(Relation relation) throws WurbelException {
        if (relation.getMethodArgs().size() > 1) {
            throw new WurbelException("more than one method argument in relation " + relation);
        }
        MethodArgument methodArg = (MethodArgument)relation.getMethodArgs().get(0);
        Attribute attribute = methodArg.getAttribute();
        if (attribute == null) {
            throw new WurbelException("missing attribute for method argument " + methodArg + " in relation " + relation);
        }
        return "set" + StringHelper.firstToUpper((String)attribute.getName());
    }

    public String createRelationDeleteCode(Relation relation) {
        StringBuilder text = new StringBuilder();
        text.append("on(").append(relation.getClassName()).append(".class).").append(this.createListRelationDeleteMethodName(relation)).append(this.createRelationArgString(relation));
        return text.toString();
    }

    public String createRelationLinkCode(Relation relation) {
        if (relation.getLinkMethodName() != null) {
            return relation.getLinkMethodName() + (relation.getLinkMethodIndex() != null ? "(me(), ndx++)" : "(me())");
        }
        String text = "set";
        text = relation.getMethodName() != null ? text + relation.getMethodName() : text + relation.getEntity().getName() + "Id";
        return text + this.createRelationArgString(relation);
    }

    public List<Relation> getEagerRelations() {
        ArrayList<Relation> eagerRelations = new ArrayList<Relation>();
        block0: for (Relation relation : this.getEntity().getRelations()) {
            if (relation.getSelectionType() != SelectionType.EAGER) continue;
            for (Relation rel : this.getEntity().getSubEntityRelations()) {
                if (rel.getSelectionType() != SelectionType.EAGER) continue;
                break block0;
            }
            for (Entity component : relation.getForeignEntity().getComponentsIncludingInherited()) {
                for (Relation rel : component.getAllRelations()) {
                    if (rel.getSelectionType() != SelectionType.EAGER) continue;
                    break block0;
                }
            }
            eagerRelations.add(relation);
        }
        return eagerRelations.isEmpty() ? null : eagerRelations;
    }

    public ComponentInfo createComponentInfo(Entity component) throws WurbelException {
        return new ComponentInfo(this, component);
    }
}

