/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.tentackle.buildsupport.RemoteMethodInfo;
import org.tentackle.persist.wurblet.DbModelWurblet;
import org.tentackle.persist.wurblet.RemoteIncludes;
import org.tentackle.persist.wurblet.RemoteMethodHelper;
import org.wurbelizer.wurbel.WurbelDiscardException;
import org.wurbelizer.wurbel.WurbelException;

public class RemoteMethod
extends DbModelWurblet {
    @Override
    public void run() throws WurbelException {
        super.run();
        try {
            this.wurbel();
        }
        catch (Throwable t) {
            if (t instanceof WurbelException) {
                throw (WurbelException)t;
            }
            throw new WurbelException("wurblet " + (Object)((Object)this) + " failed", t);
        }
    }

    private void wurbel() throws WurbelException {
        String instanceName = null;
        boolean addThis = false;
        boolean noContext = false;
        for (String arg : this.getOptionArgs()) {
            if (arg.startsWith("instance=")) {
                instanceName = arg.substring(9);
                continue;
            }
            if (arg.equals("this")) {
                addThis = true;
                continue;
            }
            if (!arg.equals("nocontext")) continue;
            noContext = true;
        }
        String methodName = this.getMethodName();
        String className = this.getClassName();
        if (className == null) {
            throw new WurbelException("can't determine <classname>");
        }
        String packageName = this.getPackageName();
        if (packageName == null) {
            throw new WurbelException("can't determine <packagename>");
        }
        boolean isPdo = false;
        String pdoClassName = null;
        try {
            pdoClassName = this.getPdoClassName();
            isPdo = true;
        }
        catch (WurbelException wurbelException) {
            // empty catch block
        }
        if (this.isRemote()) {
            RemoteIncludes genInc = new RemoteIncludes(this);
            PrintStream implOut = genInc.getImplStream();
            PrintStream remoteOut = genInc.getRemoteStream();
            String infoName = (packageName + "." + className + "." + methodName).replace('.', '/') + ".remote";
            RemoteMethodInfo info = null;
            try {
                info = RemoteMethodInfo.readInfo((File)this.getContainer().getAnalyzeFile(infoName));
            }
            catch (IOException ex) {
                if (this.getContainer().getAnalyzeFile("error.log").exists()) {
                    genInc.discard();
                    throw new WurbelDiscardException("reading info '" + infoName + "' failed", (Throwable)ex);
                }
                throw new WurbelException("reading info '" + infoName + "' failed (@RemoteMethod annotation missing?)", (Throwable)ex);
            }
            RemoteMethodHelper helper = new RemoteMethodHelper(info, pdoClassName, addThis);
            boolean returningObject = helper.isReturningObject();
            boolean returningCollection = helper.isReturningCollection();
            boolean returningCursor = helper.isReturningCursor();
            boolean returningVoid = helper.isReturningVoid();
            methodName = helper.getMethodName();
            if (helper.isStaticMethod()) {
                throw new WurbelException("static methods cannot be --remote");
            }
            String iparms = helper.getInvocationParameterString();
            String riparms = helper.getRemoteInvocationParameterString();
            String dparms = helper.getDeclarationParameterString();
            if (isPdo && !addThis && !noContext) {
                iparms = iparms.length() > 0 ? "getDomainContext(), " + iparms : "getDomainContext()";
                dparms = dparms.length() > 0 ? "DomainContext context, " + dparms : "DomainContext context";
            }
            String returnType = helper.getReturnType();
            String genType = helper.getGenericReturnType();
            String firstName = helper.getFirstName();
            boolean firstIsDb = helper.isFirstInstanceOfDb();
            boolean firstIsDomainContext = helper.isFirstInstanceOfDomainContext();
            String remoteDelegateName = (pdoClassName != null ? pdoClassName : className) + "RemoteDelegate";
            String imethod = "getRemoteDelegate()";
            String setDomainContext = "setDomainContext(" + firstName + ")";
            String apply = null;
            if (returningObject) {
                apply = "configureRemoteObject(getDomainContext(), obj)";
            } else if (returningCollection) {
                apply = "configureRemoteObjects(getDomainContext(), list)";
            }
            String dbObject = "newInstance(" + (firstIsDomainContext ? firstName : "context") + ")";
            if (!isPdo || noContext) {
                dbObject = "dbObject";
            }
            if (addThis) {
                dbObject = "obj";
            } else if (instanceName != null) {
                dbObject = instanceName;
            }
            this.out.print(this.source[0]);
            if (returningObject) {
                remoteOut.print(this.source[1]);
                remoteOut.print(className);
                remoteOut.print(this.source[2]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[3]);
                remoteOut.print(dparms);
                remoteOut.print(this.source[4]);
                implOut.print(this.source[5]);
                implOut.print(className);
                implOut.print(this.source[6]);
                implOut.print(methodName);
                implOut.print(this.source[7]);
                implOut.print(dparms);
                implOut.print(this.source[8]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[9]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[10]);
                }
                if (addThis) {
                    implOut.print(this.source[11]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[12]);
                    implOut.print(statement);
                    implOut.print(this.source[13]);
                }
                implOut.print(this.source[14]);
                implOut.print(dbObject);
                implOut.print(this.source[15]);
                implOut.print(methodName);
                implOut.print(this.source[16]);
                implOut.print(riparms);
                implOut.print(this.source[17]);
                this.out.print(this.source[18]);
                this.out.print(className);
                this.out.print(this.source[19]);
                this.out.print(imethod);
                this.out.print(this.source[20]);
                this.out.print(methodName);
                this.out.print(this.source[21]);
                this.out.print(iparms);
                this.out.print(this.source[22]);
                this.out.print(apply);
                this.out.print(this.source[23]);
            }
            if (returningCollection) {
                remoteOut.print(this.source[24]);
                remoteOut.print(returnType);
                remoteOut.print(this.source[25]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[26]);
                remoteOut.print(dparms);
                remoteOut.print(this.source[27]);
                implOut.print(this.source[28]);
                implOut.print(returnType);
                implOut.print(this.source[29]);
                implOut.print(methodName);
                implOut.print(this.source[30]);
                implOut.print(dparms);
                implOut.print(this.source[31]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[32]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[33]);
                }
                if (addThis) {
                    implOut.print(this.source[34]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[35]);
                    implOut.print(statement);
                    implOut.print(this.source[36]);
                }
                implOut.print(this.source[37]);
                implOut.print(dbObject);
                implOut.print(this.source[38]);
                implOut.print(methodName);
                implOut.print(this.source[39]);
                implOut.print(riparms);
                implOut.print(this.source[40]);
                this.out.print(this.source[41]);
                this.out.print(returnType);
                this.out.print(this.source[42]);
                this.out.print(imethod);
                this.out.print(this.source[43]);
                this.out.print(methodName);
                this.out.print(this.source[44]);
                this.out.print(iparms);
                this.out.print(this.source[45]);
                this.out.print(apply);
                this.out.print(this.source[46]);
            } else if (returningCursor) {
                remoteOut.print(this.source[47]);
                remoteOut.print(genType);
                remoteOut.print(this.source[48]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[49]);
                remoteOut.print(dparms);
                remoteOut.print(this.source[50]);
                implOut.print(this.source[51]);
                implOut.print(genType);
                implOut.print(this.source[52]);
                implOut.print(methodName);
                implOut.print(this.source[53]);
                implOut.print(dparms);
                implOut.print(this.source[54]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[55]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[56]);
                }
                if (addThis) {
                    implOut.print(this.source[57]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[58]);
                    implOut.print(statement);
                    implOut.print(this.source[59]);
                }
                implOut.print(this.source[60]);
                implOut.print(dbObject);
                implOut.print(this.source[61]);
                implOut.print(methodName);
                implOut.print(this.source[62]);
                implOut.print(riparms);
                implOut.print(this.source[63]);
                if (isPdo) {
                    this.out.print(this.source[64]);
                    this.out.print(imethod);
                    this.out.print(this.source[65]);
                    this.out.print(methodName);
                    this.out.print(this.source[66]);
                    this.out.print(iparms);
                    this.out.print(this.source[67]);
                } else {
                    this.out.print(this.source[68]);
                    this.out.print(imethod);
                    this.out.print(this.source[69]);
                    this.out.print(methodName);
                    this.out.print(this.source[70]);
                    this.out.print(iparms);
                    this.out.print(this.source[71]);
                }
            } else if (returningVoid) {
                remoteOut.print(this.source[72]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[73]);
                remoteOut.print(dparms);
                remoteOut.print(this.source[74]);
                implOut.print(this.source[75]);
                implOut.print(methodName);
                implOut.print(this.source[76]);
                implOut.print(dparms);
                implOut.print(this.source[77]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[78]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[79]);
                }
                if (addThis) {
                    implOut.print(this.source[80]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[81]);
                    implOut.print(statement);
                    implOut.print(this.source[82]);
                }
                implOut.print(this.source[83]);
                implOut.print(dbObject);
                implOut.print(this.source[84]);
                implOut.print(methodName);
                implOut.print(this.source[85]);
                implOut.print(riparms);
                implOut.print(this.source[86]);
                this.out.print(this.source[87]);
                this.out.print(imethod);
                this.out.print(this.source[88]);
                this.out.print(methodName);
                this.out.print(this.source[89]);
                this.out.print(iparms);
                this.out.print(this.source[90]);
            } else {
                remoteOut.print(this.source[91]);
                remoteOut.print(returnType);
                remoteOut.print(this.source[92]);
                remoteOut.print(methodName);
                remoteOut.print(this.source[93]);
                remoteOut.print(dparms);
                remoteOut.print(this.source[94]);
                implOut.print(this.source[95]);
                implOut.print(returnType);
                implOut.print(this.source[96]);
                implOut.print(methodName);
                implOut.print(this.source[97]);
                implOut.print(dparms);
                implOut.print(this.source[98]);
                if (firstIsDomainContext) {
                    implOut.print(this.source[99]);
                    implOut.print(setDomainContext);
                    implOut.print(this.source[100]);
                }
                if (addThis) {
                    implOut.print(this.source[101]);
                }
                for (String statement : helper.getUpdateDbInParametersStatements()) {
                    implOut.print(this.source[102]);
                    implOut.print(statement);
                    implOut.print(this.source[103]);
                }
                implOut.print(this.source[104]);
                implOut.print(dbObject);
                implOut.print(this.source[105]);
                implOut.print(methodName);
                implOut.print(this.source[106]);
                implOut.print(riparms);
                implOut.print(this.source[107]);
                this.out.print(this.source[108]);
                this.out.print(imethod);
                this.out.print(this.source[109]);
                this.out.print(methodName);
                this.out.print(this.source[110]);
                this.out.print(iparms);
                this.out.print(this.source[111]);
            }
            this.out.print(this.source[112]);
        } else {
            this.out.print(this.source[113]);
        }
    }
}

