/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.tentackle.model.Attribute;
import org.tentackle.model.Entity;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;
import org.tentackle.model.Relation;
import org.tentackle.model.SortType;
import org.tentackle.persist.wurblet.WurbletArgumentOperand;
import org.tentackle.persist.wurblet.WurbletArgumentType;
import org.wurbelizer.wurbel.WurbelException;

public class WurbletArgument
implements WurbletArgumentOperand {
    private final Entity entity;
    private final int index;
    private final String text;
    private WurbletArgumentType argumentType;
    private String name;
    private String relop;
    private String value;
    private boolean literally;
    private SortType sortType;
    private Attribute attribute;
    private List<Relation> relations;
    private Entity component;
    private List<Relation> expressionRelations;
    private Set<Relation> existsRelations;
    private Set<Entity> existsComponents;
    private boolean endOfExistsClause;

    public WurbletArgument(Entity entity, int index, String text, boolean expressionFinished, boolean argumentGroupingEnabled) throws WurbelException {
        Entity currentEntity;
        String str;
        this.entity = entity;
        this.index = index;
        this.text = text;
        if (text == null || text.isEmpty()) {
            throw new WurbelException("text must be a non-empty string");
        }
        switch (text.charAt(0)) {
            case '*': {
                this.argumentType = WurbletArgumentType.JOIN;
                text = text.substring(1);
                break;
            }
            case '+': {
                this.argumentType = WurbletArgumentType.SORT;
                this.sortType = SortType.ASC;
                text = text.substring(1);
                break;
            }
            case '-': {
                this.argumentType = WurbletArgumentType.SORT;
                this.sortType = SortType.DESC;
                text = text.substring(1);
                break;
            }
            default: {
                if (expressionFinished) {
                    if (argumentGroupingEnabled) {
                        this.argumentType = WurbletArgumentType.EXTRA;
                        break;
                    }
                    this.argumentType = WurbletArgumentType.SORT;
                    this.sortType = SortType.ASC;
                    break;
                }
                this.argumentType = WurbletArgumentType.CONDITION;
                this.relop = "=";
            }
        }
        int ndx = text.indexOf(58);
        if (ndx > 0) {
            if (!this.argumentType.isRelopOptional()) {
                throw new WurbelException("relops not allowed for " + (Object)((Object)this.argumentType) + "-argument '" + this.text + "'");
            }
            str = text.substring(0, ndx);
            this.relop = text.substring(ndx + 1);
            ndx = this.relop.indexOf(58);
            if (ndx > 0) {
                this.value = this.relop.substring(ndx + 1);
                this.relop = this.relop.substring(0, ndx);
            } else {
                ndx = this.relop.indexOf(35);
                if (ndx > 0) {
                    this.value = this.relop.substring(ndx + 1);
                    this.relop = this.relop.substring(0, ndx);
                    this.literally = true;
                }
            }
            switch (this.relop.toUpperCase()) {
                case "NULL": {
                    this.relop = " IS NULL";
                    this.value = "";
                    this.literally = true;
                    break;
                }
                case "NOTNULL": {
                    this.relop = " IS NOT NULL";
                    this.value = "";
                    this.literally = true;
                    break;
                }
                case "LIKE": {
                    this.relop = " LIKE ";
                    break;
                }
                case "NOTLIKE": {
                    this.relop = " NOT LIKE ";
                }
            }
        } else {
            str = text;
        }
        ndx = str.indexOf(91);
        if (ndx > 0) {
            if (!this.argumentType.isNameOptional()) {
                throw new WurbelException("method argument name not allowed for " + (Object)((Object)this.argumentType) + "-argument '" + this.text + "'");
            }
            int ndx2 = str.indexOf(93);
            if (ndx2 > ndx) {
                this.name = str.substring(ndx + 1, ndx2);
                str = str.substring(0, ndx);
            }
        }
        if ((ndx = str.indexOf(46)) >= 0) {
            if (str.length() == 1) {
                throw new WurbelException("single dot not allowed as argument");
            }
            if (!this.argumentType.isPathAllowed()) {
                throw new WurbelException("relation path not allowed for " + (Object)((Object)this.argumentType) + "-argument '" + this.text + "'");
            }
        }
        if (ndx == 0) {
            if (this.argumentType == WurbletArgumentType.JOIN) {
                throw new WurbelException("leading dot not allowed for " + (Object)((Object)this.argumentType) + "-argument '" + this.text + "'");
            }
            int ndx2 = str.indexOf(46, ndx + 1);
            if (!entity.isRootEntity()) {
                throw new WurbelException("component not allowed for non-root entity " + entity + " in argument '" + this.text + "'");
            }
            String componentName = str.substring(ndx + 1, ndx2);
            try {
                this.component = Model.getInstance().getByEntityName(componentName);
            }
            catch (ModelException mx) {
                throw new WurbelException("could not load component " + componentName, (Throwable)mx);
            }
            if (this.component == null) {
                throw new WurbelException("no such component entity '" + componentName + "' in argument '" + this.text + "'");
            }
            boolean isComponent = false;
            for (List path : this.component.getAllCompositePaths()) {
                if (!((Relation)path.get(0)).getEntity().equals(entity)) continue;
                isComponent = true;
                this.relations = new ArrayList<Relation>();
                break;
            }
            if (!isComponent) {
                throw new WurbelException(this.component + " is not a component of " + entity);
            }
            str = str.substring(ndx2 + 1);
        }
        Entity entity2 = currentEntity = this.component != null ? this.component : this.entity;
        while ((ndx = this.nextSeparatorIndex(str)) > 0) {
            String relationName = str.substring(0, ndx);
            str = str.substring(ndx + 1);
            currentEntity = this.addRelation(currentEntity, relationName);
        }
        if (this.argumentType == WurbletArgumentType.JOIN) {
            if (!str.isEmpty()) {
                this.addRelation(currentEntity, str);
            }
        } else if (str.isEmpty()) {
            if (this.argumentType.isAttributeRequired()) {
                throw new WurbelException("missing attribute in argument '" + this.text + "'");
            }
        } else {
            if (!this.argumentType.isAttributeAllowed()) {
                throw new WurbelException("attribute not allowed for " + (Object)((Object)this.argumentType) + "-argument '" + this.text + "'");
            }
            this.attribute = currentEntity.getAttributeByJavaName(str, true);
            if (this.attribute == null) {
                throw new WurbelException("no such attribute '" + str + "' defined for entity " + currentEntity + " in argument '" + this.text + "'");
            }
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public int getIndex() {
        return this.index;
    }

    public String getText() {
        return this.text;
    }

    public WurbletArgumentType getArgumentType() {
        return this.argumentType;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public Set<Relation> getExistsRelations() {
        return this.existsRelations;
    }

    public void setExistsRelations(Set<Relation> existsRelations) {
        this.existsRelations = existsRelations;
    }

    public Set<Entity> getExistsComponents() {
        return this.existsComponents;
    }

    public void setExistsComponents(Set<Entity> existsComponents) {
        this.existsComponents = existsComponents;
    }

    public boolean isEndOfExistsClause() {
        return this.endOfExistsClause;
    }

    public void setEndOfExistsClause(boolean endOfExistsClause) {
        this.endOfExistsClause = endOfExistsClause;
    }

    public List<Relation> getExpressionRelations() {
        if (this.relations != null && this.expressionRelations == null) {
            this.expressionRelations = new ArrayList<Relation>();
            if (this.entity.isRootEntity() && this.component == null) {
                for (Relation relation : this.relations) {
                    if (this.expressionRelations.isEmpty() && relation.isComposite() && relation.getMethodArgs().size() == 1) {
                        this.component = relation.getForeignEntity();
                        continue;
                    }
                    this.expressionRelations.add(relation);
                }
            } else {
                this.expressionRelations = this.relations;
            }
        }
        return this.expressionRelations;
    }

    public Entity getComponent() {
        this.getExpressionRelations();
        return this.component;
    }

    public boolean isPath() {
        return this.relations != null;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMethodArgument() {
        return this.attribute != null && this.value == null;
    }

    public String getMethodArgumentName() throws WurbelException {
        if (this.attribute == null) {
            throw new WurbelException("argument " + this + " provides no name");
        }
        return this.name != null ? this.name : this.attribute.getName();
    }

    public String getJdbcValue() throws WurbelException {
        String str;
        if (this.value != null) {
            str = this.value;
            if (this.attribute != null) {
                str = this.attribute.toMethodArgument(this.value);
            }
        } else {
            str = this.getMethodArgumentName();
        }
        return str;
    }

    public String getRelop() {
        String str;
        switch (this.relop) {
            case "=": {
                if (this.literally) {
                    str = "Backend.SQL_EQUAL + " + this.value;
                    break;
                }
                str = "Backend.SQL_EQUAL_PAR";
                break;
            }
            case "<>": 
            case "!=": {
                if (this.literally) {
                    str = "Backend.SQL_NOTEQUAL + " + this.value;
                    break;
                }
                str = "Backend.SQL_NOTEQUAL_PAR";
                break;
            }
            case "<": {
                if (this.literally) {
                    str = "Backend.SQL_LESS + " + this.value;
                    break;
                }
                str = "Backend.SQL_LESS_PAR";
                break;
            }
            case ">": {
                if (this.literally) {
                    str = "Backend.SQL_GREATER + " + this.value;
                    break;
                }
                str = "Backend.SQL_GREATER_PAR";
                break;
            }
            case "<=": {
                if (this.literally) {
                    str = "Backend.SQL_LESSOREQUAL + " + this.value;
                    break;
                }
                str = "Backend.SQL_LESSOREQUAL_PAR";
                break;
            }
            case ">=": {
                if (this.literally) {
                    str = "Backend.SQL_GREATEROREQUAL + " + this.value;
                    break;
                }
                str = "Backend.SQL_GREATEROREQUAL_PAR";
                break;
            }
            case " LIKE ": {
                if (this.literally) {
                    str = "Backend.SQL_LIKE + " + this.value;
                    break;
                }
                str = "Backend.SQL_LIKE_PAR";
                break;
            }
            case " NOT LIKE ": {
                if (this.literally) {
                    str = "Backend.SQL_NOTLIKE + " + this.value;
                    break;
                }
                str = "Backend.SQL_NOTLIKE_PAR";
                break;
            }
            case " IS NULL": {
                str = "Backend.SQL_ISNULL";
                break;
            }
            case " IS NOT NULL": {
                str = "Backend.SQL_ISNOTNULL";
                break;
            }
            default: {
                str = this.relop + (this.literally ? this.value : "?");
            }
        }
        return str;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isValueLiterally() {
        return this.literally;
    }

    public String toString() {
        return this.text;
    }

    private int nextSeparatorIndex(String name) {
        int ndx2;
        int ndx = name.indexOf(46);
        if (this.argumentType == WurbletArgumentType.JOIN && (ndx2 = name.indexOf(42)) >= 0 && (ndx2 < ndx || ndx < 0)) {
            ndx = ndx2;
        }
        return ndx;
    }

    private Entity addRelation(Entity currentEntity, String name) throws WurbelException {
        Relation relation = currentEntity.getRelation(name, true);
        if (relation == null) {
            throw new WurbelException("no such relation '" + name + "' defined for entity " + currentEntity + " in argument '" + this.text + "'");
        }
        if (this.relations == null) {
            this.relations = new ArrayList<Relation>();
        }
        this.relations.add(relation);
        return relation.getForeignEntity();
    }
}

