/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.wurblet;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.tentackle.buildsupport.RemoteMethodInfo;
import org.tentackle.buildsupport.RemoteMethodInfoParameter;

public class RemoteMethodHelper {
    private final RemoteMethodInfo info;
    private final RemoteMethodInfoParameter[] params;
    private final boolean staticMethod;
    private final boolean returningVoid;
    private final String pdoClassName;
    private final boolean returningObject;
    private final boolean returningCollection;
    private final boolean returningCursor;

    public RemoteMethodHelper(RemoteMethodInfo info, String pdoClassName, boolean addThis) {
        this.info = info;
        this.pdoClassName = pdoClassName;
        String classBaseName = info.getClassName().substring(info.getClassName().lastIndexOf(46) + 1);
        String returnType = info.getReturnType();
        this.returningVoid = returnType.equals("void");
        this.returningCollection = info.isReturningDbObjectCollection();
        this.returningCursor = info.isReturningCursor();
        this.returningObject = info.isReturningDbObject();
        if (addThis) {
            info.addParameter(new RemoteMethodInfoParameter(info, "this", classBaseName));
        }
        this.staticMethod = info.isModifierSet(Modifier.STATIC);
        this.params = info.getParameters();
    }

    public String getMethodName() {
        return this.info.getMethodName();
    }

    public String getReturnType() {
        return this.info.cleanTypeString(this.info.getReturnType());
    }

    public String getGenericReturnType() {
        return this.info.getGenericReturnType().equals("<>") ? "" : this.info.cleanTypeString(this.info.getGenericReturnType());
    }

    public boolean isPdo() {
        return this.pdoClassName != null;
    }

    public boolean isReturningVoid() {
        return this.returningVoid;
    }

    public boolean isReturningObject() {
        return this.returningObject;
    }

    public boolean isReturningCollection() {
        return this.returningCollection;
    }

    public boolean isReturningCursor() {
        return this.returningCursor;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public String getFirstName() {
        return this.params != null && this.params.length > 0 ? this.params[0].getName() : null;
    }

    public boolean isFirstInstanceOfDb() {
        return this.params != null && this.params.length > 0 && this.params[0].isInstanceOfSession();
    }

    public boolean isFirstInstanceOfDomainContext() {
        return this.params != null && this.params.length > 0 && this.params[0].isInstanceOfContext();
    }

    public int getParamCount() {
        return this.params == null ? 0 : this.params.length;
    }

    public String getInvocationParameterString() {
        StringBuilder buf = new StringBuilder();
        if (this.params != null) {
            boolean addSep = false;
            for (RemoteMethodInfoParameter par : this.params) {
                boolean isThis;
                if (par.isInstanceOfSession()) continue;
                if (addSep) {
                    buf.append(", ");
                }
                if ((isThis = par.getName().equals("this")) && this.isPdo()) {
                    buf.append("me()");
                } else {
                    buf.append(par.getName());
                }
                addSep = true;
            }
        }
        return buf.toString();
    }

    public String getRemoteInvocationParameterString() {
        StringBuilder buf = new StringBuilder();
        if (this.params != null) {
            boolean addSep = false;
            for (RemoteMethodInfoParameter par : this.params) {
                if (par.getName().equals("this")) continue;
                if (addSep) {
                    buf.append(", ");
                }
                buf.append(par.getName());
                addSep = true;
            }
        }
        return buf.toString();
    }

    public String getDeclarationParameterString() {
        StringBuilder buf = new StringBuilder();
        if (this.params != null) {
            boolean addSep = false;
            for (RemoteMethodInfoParameter par : this.params) {
                boolean isThis;
                if (par.isInstanceOfSession()) continue;
                if (addSep) {
                    buf.append(", ");
                }
                if ((isThis = par.getName().equals("this")) && this.isPdo()) {
                    buf.append(this.pdoClassName);
                } else {
                    buf.append(this.info.cleanTypeString(par.getType()));
                    if (par.isVarArg()) {
                        buf.append("...");
                    }
                }
                buf.append(' ');
                buf.append(isThis ? "obj" : par.getName());
                addSep = true;
            }
        }
        return buf.toString();
    }

    public List<String> getUpdateDbInParametersStatements() {
        ArrayList<String> statements = new ArrayList<String>();
        if (this.params != null) {
            for (RemoteMethodInfoParameter par : this.params) {
                if (!par.isInstanceOfDbObject() && !par.isInstanceOfPdo()) continue;
                statements.add("getSession().applyTo(" + par.getName() + ")");
            }
        }
        return statements;
    }
}

