/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.tentackle.log.Logger;
import org.tentackle.session.Session;
import org.tentackle.session.SessionKeepAliveDaemon;
import org.tentackle.task.AbstractTask;

public class SessionKeepAliveTask
extends AbstractTask {
    private static final Logger LOGGER = Logger.get(SessionKeepAliveTask.class);
    private static final int MAX_FAILURES = 10;
    private static final long serialVersionUID = 1L;
    private final transient SessionKeepAliveDaemon daemon;
    private final transient Session session;
    private final long timeOut;
    private final transient Callable<Boolean> aliveCallable;
    private transient Future<Boolean> future;
    private transient int failCount;

    public SessionKeepAliveTask(SessionKeepAliveDaemon daemon, Session session, long interval, long timeOut) {
        this.daemon = daemon;
        this.session = session;
        this.timeOut = timeOut;
        this.aliveCallable = this.createAliveCallable();
        if (interval > 0L) {
            this.setRepeatInterval(interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Session session = this.session;
        synchronized (session) {
            if (this.session.isOpen()) {
                if (this.getRepeatInterval() > 0L) {
                    LOGGER.fine("keep-alive {0}", new Object[]{this.session});
                    if (this.future == null) {
                        this.future = this.daemon.getExecutorService().submit(this.aliveCallable);
                    }
                    try {
                        this.future.get(this.timeOut, TimeUnit.MILLISECONDS);
                        this.failCount = 0;
                        this.future = null;
                    }
                    catch (TimeoutException tex) {
                        LOGGER.fine("setAlive still pending for {0}", new Object[]{this.session});
                    }
                    catch (ExecutionException eex) {
                        ++this.failCount;
                        LOGGER.warning("setAlive failed for " + this.session, (Throwable)eex);
                        if (this.failCount > 10) {
                            LOGGER.severe("setAlive failed " + this.failCount + " times in sequence -> closing " + this.session, (Throwable)eex);
                            this.daemon.getExecutorService().submit(this.createCloseCallable());
                            this.daemon.removeAliveTask(this.session);
                        }
                    }
                    catch (InterruptedException iex) {
                        LOGGER.warning("interrupted -> ignored", (Throwable)iex);
                    }
                } else {
                    LOGGER.fine("close requested for {0}", new Object[]{this.session});
                    this.daemon.getExecutorService().submit(this.createCloseCallable());
                    this.daemon.removeAliveTask(this.session);
                }
            } else {
                LOGGER.info(this.session + " is closed");
                this.daemon.removeAliveTask(this.session);
            }
        }
    }

    public String toString() {
        return "keep alive " + this.session.getName();
    }

    protected Callable<Boolean> createAliveCallable() {
        return () -> {
            try {
                this.session.setAlive(true);
                return Boolean.TRUE;
            }
            catch (RuntimeException ex) {
                throw new ExecutionException("set alive failed", ex);
            }
        };
    }

    protected Callable<Boolean> createCloseCallable() {
        return () -> {
            try {
                this.session.close();
                return Boolean.TRUE;
            }
            catch (RuntimeException ex) {
                throw new ExecutionException("close failed", ex);
            }
        };
    }
}

