/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.tentackle.bind.Bindable;
import org.tentackle.session.AbstractSessionConfiguration;
import org.tentackle.session.PersistenceException;
import org.tentackle.validate.validator.NotNull;

public class DriverConfiguration
extends AbstractSessionConfiguration {
    private static final String NODE_NAME = "drivers";
    private static final String DRIVER_KEY = "driver";
    private static final String URL_KEY = "url";
    private String driver;
    private String url;

    public static Map<String, DriverConfiguration> getDriverConfigurations(boolean system) {
        TreeMap<String, DriverConfiguration> drivers = new TreeMap<String, DriverConfiguration>();
        Preferences applicationPrefs = DriverConfiguration.getPrefNode(system);
        try {
            for (String name : applicationPrefs.childrenNames()) {
                Preferences driverPrefs = applicationPrefs.node(name);
                String driver = driverPrefs.get(DRIVER_KEY, null);
                String url = driverPrefs.get(URL_KEY, null);
                if (driver == null || url == null) continue;
                DriverConfiguration configuration = new DriverConfiguration(name, driver, url);
                configuration.setPersisted(true);
                drivers.put(name, configuration);
            }
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("cannot load driver configurations", (Throwable)bx);
        }
        return drivers;
    }

    public static void removeDriverConfigurations(boolean system) {
        Preferences prefs = DriverConfiguration.getPrefNode(system);
        try {
            prefs.removeNode();
            prefs.flush();
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("removing driver configurations failed", (Throwable)bx);
        }
    }

    private static Preferences getPrefNode(boolean system) {
        return DriverConfiguration.getPrefNode(NODE_NAME, system);
    }

    public DriverConfiguration(String name, String driver, String url) {
        this.setName(name);
        this.driver = driver;
        this.url = url;
    }

    @Bindable
    @NotNull
    public String getDriver() {
        return this.driver;
    }

    @Bindable
    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Bindable
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Bindable
    public void setUrl(String url) {
        this.url = url;
    }

    public void persist(boolean system) {
        Preferences prefs = DriverConfiguration.getPrefNode(system);
        Preferences node = prefs.node(this.getName());
        try {
            node.put(DRIVER_KEY, this.driver);
            node.put(URL_KEY, this.url);
            prefs.flush();
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("cannot persist driver configuration " + this, (Throwable)bx);
        }
    }

    public void remove(boolean system) {
        Preferences prefs = DriverConfiguration.getPrefNode(system);
        Preferences node = prefs.node(this.getName());
        try {
            node.removeNode();
            prefs.flush();
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("cannot remove driver configuration " + this, (Throwable)bx);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverConfiguration that = (DriverConfiguration)o;
        return Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

