/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.tentackle.common.InterruptedRuntimeException;
import org.tentackle.log.Logger;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionDependable;
import org.tentackle.session.SessionPool;

public class SessionPooledExecutor {
    private static final Logger LOGGER = Logger.get(SessionPooledExecutor.class);
    private final SessionPool sessionPool;
    private final ExecutorService executorService;
    private final AtomicInteger theadNumber = new AtomicInteger(1);

    public SessionPooledExecutor(SessionPool sessionPool) {
        this.sessionPool = sessionPool;
        this.executorService = this.createExecutorService();
    }

    public SessionPool getSessionPool() {
        return this.sessionPool;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void shutdown() {
        this.executorService.shutdown();
        this.sessionPool.shutdown();
    }

    public <V> void submit(Supplier<V> task, Consumer<V> successHandler, Consumer<RuntimeException> failHandler) {
        this.executorService.submit(() -> {
            Session session = null;
            RuntimeException failEx = null;
            try {
                session = this.sessionPool.getSession();
                session.makeCurrent();
                if (task instanceof SessionDependable) {
                    ((SessionDependable)((Object)task)).setSession(session);
                }
                Object value = task.get();
                if (successHandler != null) {
                    successHandler.accept(value);
                }
            }
            catch (RuntimeException rx) {
                failEx = rx;
            }
            finally {
                if (session != null) {
                    session.clearCurrent();
                    this.sessionPool.putSession(session);
                }
            }
            if (failEx != null) {
                if (failHandler != null) {
                    failHandler.accept(failEx);
                } else {
                    LOGGER.severe("background task failed", (Throwable)failEx);
                }
            }
        });
    }

    public <V> void submit(Collection<Supplier<V>> tasks, long timeoutMillis, Consumer<Map<Supplier<V>, V>> successHandler, Consumer<Map<Supplier<V>, RuntimeException>> failHandler) {
        CountDownLatch latch = new CountDownLatch(tasks.size());
        ConcurrentHashMap results = new ConcurrentHashMap();
        ConcurrentHashMap failures = new ConcurrentHashMap();
        this.executorService.submit(() -> {
            try {
                if (timeoutMillis <= 0L) {
                    latch.await();
                } else if (!latch.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
                    failures.put(() -> null, new PersistenceException("parallel execution timed out"));
                }
                if (failHandler != null && !failures.isEmpty()) {
                    failHandler.accept(failures);
                }
                if (successHandler != null) {
                    successHandler.accept(results);
                }
            }
            catch (InterruptedException ix) {
                InterruptedRuntimeException irx = new InterruptedRuntimeException((Throwable)ix);
                failures.put(() -> null, irx);
                throw irx;
            }
        });
        for (Supplier task : tasks) {
            this.submit(task, result -> {
                results.put(task, result);
                latch.countDown();
            }, failure -> {
                failures.put(task, failure);
                latch.countDown();
            });
        }
    }

    protected ExecutorService createExecutorService() {
        int maxSize = this.sessionPool.getMaxSize();
        return maxSize <= 0 ? Executors.newCachedThreadPool(this::createThread) : Executors.newFixedThreadPool(maxSize, this::createThread);
    }

    protected Thread createThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.sessionPool.getName() + "(" + this.theadNumber.getAndIncrement() + ")");
        thread.setDaemon(true);
        return thread;
    }
}

