/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import org.tentackle.log.Logger;
import org.tentackle.session.AbstractSessionTask;
import org.tentackle.session.Session;
import org.tentackle.session.SessionTaskDispatcher;
import org.tentackle.session.SessionTaskDispatcherLock;
import org.tentackle.task.DefaultTaskDispatcher;
import org.tentackle.task.Task;

public class DefaultSessionTaskDispatcher
extends DefaultTaskDispatcher
implements SessionTaskDispatcher {
    private static final Logger LOGGER = Logger.get(DefaultSessionTaskDispatcher.class);
    private boolean sessionClosedOnTermination;
    private boolean sessionKeptAlive;
    private Session session;

    public DefaultSessionTaskDispatcher(String name, Session session, boolean useMutexLocking, long keepAliveMillis, long deadInterval) {
        super(name, useMutexLocking, keepAliveMillis, deadInterval);
        if (session != null && session.isPooled()) {
            throw new IllegalArgumentException(session + " must not be pooled");
        }
        this.session = session;
    }

    public DefaultSessionTaskDispatcher(String name) {
        super(name);
    }

    @Override
    public void setSessionKeptAlive(boolean sessionKeptAlive) {
        this.sessionKeptAlive = sessionKeptAlive;
    }

    @Override
    public boolean isSessionKeptAlive() {
        return this.sessionKeptAlive;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        if (Thread.currentThread() == this) {
            session.setOwnerThread((Thread)((Object)this));
            session.makeCurrent();
        } else {
            this.assertNotAlive();
        }
        this.session = session;
    }

    @Override
    public boolean isSessionClosedOnTermination() {
        return this.sessionClosedOnTermination;
    }

    @Override
    public void setSessionClosedOnTermination(boolean closeSessionOnTermination) {
        this.sessionClosedOnTermination = closeSessionOnTermination;
    }

    protected SessionTaskDispatcherLock createLock(Object key) {
        return new SessionTaskDispatcherLock(this, key);
    }

    public boolean addTask(Task task) {
        if (task instanceof AbstractSessionTask) {
            ((AbstractSessionTask)task).setSession(this.session);
        }
        return super.addTask(task);
    }

    protected void unlockInternal(long sleepMs) {
        if (this.sessionKeptAlive && sleepMs > 0L) {
            try {
                LOGGER.fine("{0}: keep alive on {1}", new Object[]{this, this.session});
                this.session.setAlive(true);
            }
            catch (RuntimeException ex) {
                LOGGER.severe("ping failed -> terminating " + this, (Throwable)ex);
                this.requestTermination();
            }
        } else if (!this.session.isOpen()) {
            LOGGER.info("session " + this.session + " closed -> terminating " + this);
            this.requestTermination();
        }
        super.unlockInternal(sleepMs);
    }

    public void run() {
        this.session.setOwnerThread((Thread)((Object)this));
        this.session.makeCurrent();
        super.run();
    }

    protected void cleanup() {
        super.cleanup();
        if (this.session != null && this.sessionClosedOnTermination) {
            try {
                this.session.close();
            }
            catch (RuntimeException ex) {
                LOGGER.severe("cleaning up " + this + " failed", (Throwable)ex);
            }
            this.session = null;
        }
    }
}

