/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.rmi.RemoteException;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.misc.Identifiable;
import org.tentackle.session.Session;
import org.tentackle.session.SessionProvider;
import org.tentackle.session.SessionUtilities;

public class PersistenceException
extends TentackleRuntimeException {
    private static final long serialVersionUID = -5355906838551059053L;
    private transient Session session;
    private Identifiable identifiable;
    private String lazyMessage;

    public static RuntimeException createFromRemoteException(Object relatedObject, RemoteException remoteException) {
        return SessionUtilities.getInstance().createFromRemoteException(relatedObject, remoteException);
    }

    public static PersistenceException extractPersistenceException(Throwable e) {
        while (e != null) {
            if (e instanceof PersistenceException) {
                return (PersistenceException)((Object)e);
            }
            e = e.getCause();
        }
        return null;
    }

    public PersistenceException(Session session) {
        this.setSession(session);
    }

    public PersistenceException(Session session, String message) {
        super(message);
        this.setSession(session);
    }

    public PersistenceException(Session session, String message, Throwable cause) {
        super(message, SessionUtilities.getInstance().alignExceptionCause(cause));
        this.setSession(session);
        SessionUtilities.getInstance().alignTemporaryExceptionStatus(this);
    }

    public PersistenceException(Session session, Throwable cause) {
        super(SessionUtilities.getInstance().alignExceptionCause(cause));
        this.setSession(session);
        SessionUtilities.getInstance().alignTemporaryExceptionStatus(this);
    }

    public PersistenceException(Identifiable identifiable) {
        this.setIdentifiable(identifiable);
    }

    public PersistenceException(Identifiable object, String message) {
        super(message);
        this.setIdentifiable(object);
    }

    public PersistenceException(Identifiable object, String message, Throwable cause) {
        super(message, SessionUtilities.getInstance().alignExceptionCause(cause));
        this.setIdentifiable(object);
        SessionUtilities.getInstance().alignTemporaryExceptionStatus(this);
    }

    public PersistenceException(Identifiable object, Throwable cause) {
        super(SessionUtilities.getInstance().alignExceptionCause(cause));
        this.setIdentifiable(object);
        SessionUtilities.getInstance().alignTemporaryExceptionStatus(this);
    }

    public PersistenceException() {
    }

    public PersistenceException(String message) {
        super(message);
    }

    public PersistenceException(String message, Throwable cause) {
        super(message, SessionUtilities.getInstance().alignExceptionCause(cause));
    }

    public PersistenceException(Throwable cause) {
        super(SessionUtilities.getInstance().alignExceptionCause(cause));
    }

    public Session getSession() {
        return this.session;
    }

    public Identifiable getIdentifiable() {
        return this.identifiable;
    }

    public String getMessage() {
        if (this.lazyMessage == null) {
            this.lazyMessage = SessionUtilities.getInstance().createLazyExceptionMessage(super.getMessage(), this.getCause(), this.getIdentifiable(), this.getSession()).toString();
        }
        return this.lazyMessage;
    }

    public void updateDbObject(Identifiable object) {
        if (this.identifiable == null) {
            this.setIdentifiable(object);
        }
    }

    private void setIdentifiable(Identifiable object) {
        this.identifiable = object;
        if (object instanceof SessionProvider) {
            this.setSession(((SessionProvider)object).getSession());
        }
    }

    private void setSession(Session session) {
        this.session = session;
    }
}

