/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.io.Serializable;
import java.util.Collection;
import org.tentackle.misc.Provider;
import org.tentackle.misc.TrackedList;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.RemoteSession;
import org.tentackle.session.SavepointHandle;
import org.tentackle.session.SessionCloseHandler;
import org.tentackle.session.SessionDependable;
import org.tentackle.session.SessionInfo;
import org.tentackle.session.SessionPool;
import org.tentackle.session.SessionTaskDispatcher;
import org.tentackle.session.SessionThreadLocalHolder;
import org.tentackle.session.TransactionIsolation;
import org.tentackle.session.TransactionWritability;

public interface Session
extends Comparable<Session>,
AutoCloseable {
    public static Session getCurrentSession() {
        return SessionThreadLocalHolder.TL_SESSION.get();
    }

    public static void setCurrentSession(Session session) {
        SessionThreadLocalHolder.TL_SESSION.set(session);
    }

    public static void assertCurrentSessionValid() {
        Session.getSession();
    }

    public static Session getSession() {
        Session session = Session.getCurrentSession();
        if (session == null) {
            throw new PersistenceException("no thread local session for " + Thread.currentThread());
        }
        return session;
    }

    default public void makeCurrent() {
        Session.setCurrentSession(this);
    }

    default public boolean isCurrent() {
        return Session.getCurrentSession() == this;
    }

    default public void clearCurrent() {
        if (!this.isCurrent()) {
            throw new PersistenceException(this, "is not the current session");
        }
        Session.setCurrentSession(null);
    }

    default public void applyTo(SessionDependable obj) {
        if (obj != null && obj.getSession() != this) {
            obj.setSession(this);
        }
    }

    default public void applyTo(Collection<? extends SessionDependable> list) {
        if (list != null) {
            for (SessionDependable sessionDependable : list) {
                this.applyTo(sessionDependable);
            }
            if (list instanceof TrackedList) {
                for (SessionDependable sessionDependable : ((TrackedList)list).getRemovedObjects()) {
                    this.applyTo(sessionDependable);
                }
            }
        }
    }

    public String getName();

    public int getSessionId();

    public int getSessionGroupId();

    public void groupWith(int var1);

    @Override
    public void close();

    public boolean registerCloseHandler(SessionCloseHandler var1);

    public boolean unregisterCloseHandler(SessionCloseHandler var1);

    public Session clone(String var1);

    public void reOpen();

    public SessionInfo getSessionInfo();

    public long begin(String var1, TransactionIsolation var2, TransactionWritability var3);

    public long begin(String var1);

    public long begin();

    public boolean commit(long var1);

    public boolean rollback(long var1);

    public boolean rollbackSilently(long var1);

    public boolean isTxRunning();

    public String getTxName();

    public <T, E extends Exception> T transaction(String var1, Provider<T, E> var2) throws E;

    public <T, E extends Exception> T transaction(Provider<T, E> var1) throws E;

    public SavepointHandle setSavepoint();

    public SavepointHandle setSavepoint(String var1);

    public void rollback(SavepointHandle var1);

    public void releaseSavepoint(SavepointHandle var1);

    public int getInstanceNumber();

    public void setOwnerThread(Thread var1);

    public Thread getOwnerThread();

    public void setAlive(boolean var1);

    public boolean isAlive();

    public void setKeepAliveInterval(long var1);

    public long getKeepAliveInterval();

    public boolean isPooled();

    public SessionPool getPool();

    public boolean isOpen();

    public boolean isRemote();

    public RemoteSession getRemoteSession();

    public String getUrl();

    public SessionTaskDispatcher getDispatcher();

    public <T extends Serializable> T setProperty(String var1, T var2);

    public <T extends Serializable> T getProperty(String var1);
}

