/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.tentackle.common.FileHelper;
import org.tentackle.common.StringHelper;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.ImmutableException;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.SessionInfo;
import org.tentackle.session.VersionInfoIncompatibleException;

public class DefaultSessionInfo
implements SessionInfo,
Serializable,
Cloneable {
    static final long serialVersionUID = 6002689783347165834L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSessionInfo.class);
    private String userName;
    private char[] password;
    private long userId;
    private int userClassId;
    private String applicationName;
    private long applicationId;
    private Serializable clientVersionInfo;
    private long since;
    private String propertiesName;
    private Properties properties;
    private boolean immutable;
    private Logger.Level immutableLoggingLevel;
    private Locale locale;
    private String vmInfo;
    private String osInfo;
    private String hostInfo;
    private TimeZone timeZone;
    private boolean cloned;

    public DefaultSessionInfo(String username, char[] password, String propertiesName) {
        this.userName = username == null ? System.getProperty("user.name") : username;
        this.password = password;
        this.propertiesName = propertiesName == null ? "backend" : propertiesName;
    }

    public DefaultSessionInfo(String propertiesName) {
        this(null, null, propertiesName);
    }

    public DefaultSessionInfo() {
        this(null, null, null);
    }

    public DefaultSessionInfo(Properties properties) {
        this.propertiesName = "<internal>";
        this.properties = properties;
        this.userName = properties.getProperty("user");
        String pass = properties.getProperty("password");
        if (pass != null && !pass.isEmpty()) {
            this.password = pass.toCharArray();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionInfo other = (SessionInfo)obj;
        return !(this.getUserName() != null ? !this.getUserName().equals(other.getUserName()) : other.getUserName() != null);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        return hash;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public void setImmutableLoggingLevel(Logger.Level immutableLoggingLevel) {
        this.immutableLoggingLevel = immutableLoggingLevel;
    }

    public Logger.Level getImmutableLoggingLevel() {
        return this.immutableLoggingLevel;
    }

    protected void assertMutable() {
        if (this.isImmutable()) {
            ImmutableException ex = new ImmutableException("session info " + this + " is immutable");
            if (this.immutableLoggingLevel == null) {
                throw ex;
            }
            LOGGER.log(this.immutableLoggingLevel, ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void setSince(long since) {
        this.assertMutable();
        this.since = since;
    }

    @Override
    public long getSince() {
        return this.since;
    }

    @Override
    public void setUserName(String userName) {
        this.assertMutable();
        this.userName = userName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setPassword(char[] password) {
        this.assertMutable();
        this.password = password;
    }

    @Override
    public void clearPassword() {
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
            this.password = null;
        }
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public String getPasswordAsString() {
        return this.password == null ? "" : new String(this.password);
    }

    @Override
    public Serializable getClientVersionInfo() {
        return this.clientVersionInfo;
    }

    @Override
    public void setClientVersionInfo(Serializable clientVersionInfo) {
        this.assertMutable();
        this.clientVersionInfo = clientVersionInfo;
    }

    @Override
    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String getVmInfo() {
        return this.vmInfo;
    }

    @Override
    public void setVmInfo(String vmInfo) {
        this.vmInfo = vmInfo;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public String getOsInfo() {
        return this.osInfo;
    }

    @Override
    public void setOsInfo(String osInfo) {
        this.osInfo = osInfo;
    }

    @Override
    public String getHostInfo() {
        return this.hostInfo;
    }

    @Override
    public void setHostInfo(String hostInfo) {
        this.hostInfo = hostInfo;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.userName);
        buf.append('[');
        buf.append(this.userId);
        buf.append("]/");
        buf.append(this.password == null ? "<no_passwd>" : "<passwd>");
        if (this.applicationName != null || this.applicationId != 0L) {
            buf.append('/');
            buf.append(this.applicationName);
            buf.append('[');
            buf.append(this.applicationId);
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public DefaultSessionInfo clone() {
        DefaultSessionInfo ui;
        try {
            ui = (DefaultSessionInfo)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        if (this.password != null) {
            ui.password = new char[this.password.length];
            System.arraycopy(this.password, 0, ui.password, 0, this.password.length);
        }
        if (this.properties != null) {
            ui.properties = (Properties)this.properties.clone();
        }
        ui.immutable = false;
        ui.cloned = true;
        return ui;
    }

    @Override
    public boolean isCloned() {
        return this.cloned;
    }

    @Override
    public void clearCloned() {
        this.assertMutable();
        this.cloned = false;
    }

    @Override
    public String getPropertiesName() {
        return this.propertiesName;
    }

    @Override
    public void setPropertiesName(String propertiesName) {
        this.assertMutable();
        this.propertiesName = propertiesName;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            try {
                try {
                    this.properties = FileHelper.loadProperties((String)this.propertiesName);
                }
                catch (FileNotFoundException e1) {
                    throw new PersistenceException("backend properties '" + this.propertiesName + "' not found");
                }
            }
            catch (IOException ex) {
                throw new PersistenceException("reading backend properties '" + this.propertiesName + "' failed", (Throwable)ex);
            }
        }
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.assertMutable();
        this.properties = properties;
    }

    @Override
    public void applyProperties() {
        char[] pwd;
        String name = this.getProperties().getProperty("user");
        if (name != null) {
            this.setUserName(name);
        }
        if ((pwd = StringHelper.toCharArray((String)this.getProperties().getProperty("password"))) != null) {
            this.setPassword(pwd);
        }
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void setApplicationName(String application) {
        this.assertMutable();
        this.applicationName = application;
    }

    @Override
    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public long getApplicationId() {
        return this.applicationId;
    }

    @Override
    public void checkServerVersionInfo(Serializable serverVersionInfo) throws VersionInfoIncompatibleException {
    }

    @Override
    public long getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(long userId) {
        this.assertMutable();
        this.userId = userId;
    }

    @Override
    public int getUserClassId() {
        return this.userClassId;
    }

    @Override
    public void setUserClassId(int userClassId) {
        this.assertMutable();
        this.userClassId = userClassId;
    }
}

