/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import org.tentackle.daemon.DaemonSupervisor;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.session.DefaultSessionTaskDispatcher;
import org.tentackle.session.Session;
import org.tentackle.session.SessionFactory;
import org.tentackle.session.SessionInfo;
import org.tentackle.task.PooledTaskDispatcher;

public class PooledSessionTaskDispatcher
extends PooledTaskDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledSessionTaskDispatcher.class);
    private final SessionInfo sessionInfo;
    private final int poolSize;
    private Session[] dbSessions;

    public PooledSessionTaskDispatcher(SessionInfo sessionInfo, int poolSize, String name, boolean useMutexLocking, long sleepInterval, boolean supervised, long deadInterval) {
        super(poolSize, name, useMutexLocking, sleepInterval, supervised, deadInterval);
        this.sessionInfo = sessionInfo;
        this.poolSize = poolSize;
    }

    public PooledSessionTaskDispatcher(SessionInfo sessionInfo, int poolSize, String name, boolean useMutexLocking, long sleepInterval) {
        this(sessionInfo, poolSize, name, useMutexLocking, sleepInterval, false, 0L);
    }

    public synchronized Session[] getDbSessions() {
        if (this.dbSessions == null) {
            this.dbSessions = new Session[this.poolSize];
        }
        return this.dbSessions;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    protected Session createSession() {
        return SessionFactory.getInstance().create(this.getSessionInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultSessionTaskDispatcher createDispatcher(int index) {
        Session session;
        PooledSessionTaskDispatcher pooledSessionTaskDispatcher = this;
        synchronized (pooledSessionTaskDispatcher) {
            session = this.getDbSessions()[index];
            if (session == null || !session.isOpen()) {
                session = this.createSession();
                session.open();
            }
        }
        DefaultSessionTaskDispatcher dispatcher = new DefaultSessionTaskDispatcher(this.getName() + "-" + index, session, this.isUsingMutexLocking(), this.getSleepInterval(), this.isSupervised() ? this.getDeadInterval() : 0L);
        dispatcher.setSessionClosedOnTermination(true);
        dispatcher.setSessionKeptAlive(true);
        return dispatcher;
    }

    protected DaemonSupervisor createSupervisor() {
        return new DaemonSupervisor("Supervisor for " + this.getName(), this.getDeadInterval(), 0, this.getDispatchers().length){
            private int dispatcherIndex;

            public Thread createDaemon(int index) {
                DefaultSessionTaskDispatcher dispatcher = PooledSessionTaskDispatcher.this.createDispatcher(index);
                dispatcher.addTaskListener(PooledSessionTaskDispatcher.this.taskListener);
                this.dispatcherIndex = index;
                PooledSessionTaskDispatcher.this.getDispatchers()[index] = dispatcher;
                return (Thread)((Object)dispatcher);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cleanupDaemon(Thread daemon) {
                super.cleanupDaemon(daemon);
                PooledSessionTaskDispatcher pooledSessionTaskDispatcher = PooledSessionTaskDispatcher.this;
                synchronized (pooledSessionTaskDispatcher) {
                    PooledSessionTaskDispatcher.this.getDispatchers()[this.dispatcherIndex].removeTaskListener(PooledSessionTaskDispatcher.this.taskListener);
                    PooledSessionTaskDispatcher.this.getDispatchers()[this.dispatcherIndex] = null;
                    try {
                        PooledSessionTaskDispatcher.this.getDbSessions()[this.dispatcherIndex].close();
                        PooledSessionTaskDispatcher.this.getDbSessions()[this.dispatcherIndex] = null;
                    }
                    catch (RuntimeException re) {
                        LOGGER.warning("db session could not be closed", (Throwable)re);
                    }
                }
            }
        };
    }
}

