/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionHolder;
import org.tentackle.session.SessionInfo;

public class ThreadLocalSessionHolder
implements SessionHolder {
    private boolean sessionImmutable;

    @Override
    public Session getSession() {
        Session session = Session.getCurrentSession();
        if (session == null) {
            throw new PersistenceException("thread-local session not set");
        }
        return session;
    }

    @Override
    public void setSession(Session session) {
        throw new UnsupportedOperationException("session is thread-local by definition and cannot be changed");
    }

    @Override
    public boolean isSessionThreadLocal() {
        return true;
    }

    @Override
    public void setSessionImmutable(boolean sessionImmutable) {
        this.sessionImmutable = sessionImmutable;
    }

    @Override
    public boolean isSessionImmutable() {
        return this.sessionImmutable;
    }

    @Override
    public SessionInfo getSessionInfo() {
        return this.getSession().getSessionInfo();
    }

    @Override
    public int getSessionInstanceNumber() {
        return this.getSession().getInstanceNumber();
    }
}

