/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.rmi.RemoteException;
import java.sql.SQLException;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.misc.Identifiable;
import org.tentackle.session.Session;
import org.tentackle.session.SessionProvider;

public class PersistenceException
extends TentackleRuntimeException {
    private static final long serialVersionUID = -5355906838551059053L;
    public static final String START_INFO = "[_ ";
    public static final String END_INFO = " _]";
    private transient Session session;
    private Identifiable identifiable;
    private String lazyMessage;

    public static RuntimeException createFromRemoteException(Object relatedObject, RemoteException remoteException) {
        Throwable remoteCause = remoteException;
        while (remoteCause instanceof RemoteException && ((Throwable)remoteCause).getCause() != null) {
            remoteCause = ((Throwable)remoteCause).getCause();
        }
        Object pex = remoteCause instanceof RuntimeException ? (RuntimeException)remoteCause : (relatedObject instanceof Identifiable ? new PersistenceException((Identifiable)relatedObject, remoteCause) : (relatedObject instanceof Session ? new PersistenceException((Session)relatedObject, remoteCause) : new PersistenceException(relatedObject != null ? relatedObject.toString() : "", remoteCause)));
        StackTraceElement[] localTrace = new Exception().getStackTrace();
        StackTraceElement[] remoteTrace = pex.getStackTrace();
        StackTraceElement[] trace = new StackTraceElement[localTrace.length + remoteTrace.length];
        System.arraycopy(remoteTrace, 0, trace, 0, remoteTrace.length);
        trace[remoteTrace.length] = new StackTraceElement(">>>>> REMOTE METHOD INVOCATION >>>>>", "", "", 0);
        System.arraycopy(localTrace, 1, trace, remoteTrace.length + 1, localTrace.length - 1);
        pex.setStackTrace(trace);
        return pex;
    }

    public static PersistenceException extractPersistenceException(Throwable e) {
        while (e != null) {
            if (e instanceof PersistenceException) {
                return (PersistenceException)((Object)e);
            }
            e = e.getCause();
        }
        return null;
    }

    public PersistenceException(Session session) {
        this.setSession(session);
    }

    public PersistenceException(Session session, String message) {
        super(message);
        this.setSession(session);
    }

    public PersistenceException(Session session, String message, Throwable cause) {
        super(message, PersistenceException.translateSQLException(cause));
        this.setSession(session);
    }

    public PersistenceException(Session session, Throwable cause) {
        super(PersistenceException.translateSQLException(cause));
        this.setSession(session);
    }

    public PersistenceException(Identifiable identifiable) {
        this.setIdentifiable(identifiable);
    }

    public PersistenceException(Identifiable object, String message) {
        super(message);
        this.setIdentifiable(object);
    }

    public PersistenceException(Identifiable object, String message, Throwable cause) {
        super(message, PersistenceException.translateSQLException(cause));
        this.setIdentifiable(object);
    }

    public PersistenceException(Identifiable object, Throwable cause) {
        super(PersistenceException.translateSQLException(cause));
        this.setIdentifiable(object);
    }

    public PersistenceException() {
    }

    public PersistenceException(String message) {
        super(message);
    }

    public PersistenceException(String message, Throwable cause) {
        super(message, PersistenceException.translateSQLException(cause));
    }

    public PersistenceException(Throwable cause) {
        super(PersistenceException.translateSQLException(cause));
    }

    public Session getSession() {
        return this.session;
    }

    public Identifiable getIdentifiable() {
        return this.identifiable;
    }

    public String getMessage() {
        if (this.lazyMessage == null) {
            StringBuilder buf = new StringBuilder();
            String msg = super.getMessage();
            if (msg == null) {
                msg = "";
            }
            boolean sqlEx = this.getCause() instanceof SQLException;
            boolean multiline = msg.length() > 80 || sqlEx || msg.contains("\n");
            buf.append(msg);
            String identStr = null;
            if (this.identifiable != null && msg.contains(identStr = this.identifiable.toGenericString())) {
                identStr = null;
            }
            String sessionStr = null;
            if (this.session != null && msg.contains(sessionStr = this.session.toString())) {
                sessionStr = null;
            }
            if (identStr != null || sessionStr != null) {
                if (multiline) {
                    buf.append('\n');
                } else {
                    buf.append(' ');
                }
                buf.append(START_INFO);
                if (identStr != null) {
                    buf.append(identStr);
                }
                if (sessionStr != null) {
                    if (identStr != null) {
                        buf.append(" -- ");
                    }
                    buf.append(sessionStr);
                }
                buf.append(END_INFO);
            }
            if (sqlEx) {
                SQLException sx = (SQLException)this.getCause();
                buf.append("\nSQL-Message: ").append(sx.getMessage()).append("\nSQL-Code:    ").append(sx.getErrorCode()).append("\nSQL-State:   ").append(sx.getSQLState());
            }
            this.lazyMessage = buf.toString();
        }
        return this.lazyMessage;
    }

    public void updateDbObject(Identifiable object) {
        if (this.identifiable == null) {
            this.setIdentifiable(object);
        }
    }

    protected void setIdentifiable(Identifiable object) {
        this.identifiable = object;
        if (object instanceof SessionProvider) {
            this.setSession(((SessionProvider)object).getSession());
        }
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    private static Throwable translateSQLException(Throwable t) {
        if (t instanceof SQLException) {
            StackTraceElement[] trace = t.getStackTrace();
            SQLException sx = (SQLException)t;
            t = new SQLException(sx.getMessage() + " (" + t.getClass().getName() + ")", sx.getSQLState(), sx.getErrorCode());
            t.setStackTrace(trace);
        }
        return t;
    }
}

