/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.session.Session;
import org.tentackle.session.SessionKeepAliveTask;
import org.tentackle.task.DefaultTaskDispatcher;
import org.tentackle.task.Task;

public class SessionKeepAliveDaemon
extends DefaultTaskDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionKeepAliveDaemon.class);
    private static final long SLEEP_INTERVAL = 10000L;
    private final long minAliveInterval;
    private final Map<Session, Task> sessionTaskMap;
    private final ExecutorService executorService;
    private final AtomicInteger threadNumber;
    private ThreadGroup threadGroup;

    public SessionKeepAliveDaemon(long minAliveInterval) {
        super("Session Keep Alive Daemon", false, 10000L, 100000L);
        this.minAliveInterval = minAliveInterval;
        this.sessionTaskMap = new ConcurrentHashMap<Session, Task>();
        this.executorService = this.createExecutorService();
        this.threadNumber = new AtomicInteger(1);
        this.setPriority(10);
    }

    protected void cleanup() {
        this.executorService.shutdown();
        super.cleanup();
    }

    public void run() {
        this.threadGroup = Thread.currentThread().getThreadGroup();
        super.run();
    }

    public void keepAliveIntervalChanged(Session session) {
        long interval = session.getKeepAliveInterval();
        Task task = this.sessionTaskMap.get(session);
        if (task != null) {
            this.removeTask(task);
            this.sessionTaskMap.remove(session);
        }
        if (interval != 0L && session.isOpen()) {
            if (interval > 0L && interval < this.minAliveInterval) {
                interval = this.minAliveInterval;
            }
            task = this.createAliveTask(session, interval);
            this.sessionTaskMap.put(session, task);
            this.addTask(task);
            LOGGER.info("added keep-alive={0}ms for {1}", new Object[]{interval, session});
        } else {
            LOGGER.info("removed keep-alive for {0}", new Object[]{session});
        }
    }

    public void removeAliveTask(Session session) {
        Task task = this.sessionTaskMap.remove(session);
        if (task != null) {
            this.removeTask(task);
        }
        LOGGER.info("{0} removed from keep-alive", new Object[]{session.getName()});
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(runnable -> {
            Thread t = new Thread(this.threadGroup, runnable, "Keep Alive Thread(" + this.threadNumber.getAndIncrement() + ")", 0L);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        });
    }

    protected Task createAliveTask(Session session, long interval) {
        return new SessionKeepAliveTask(this, session, interval, this.sessionTaskMap.size() + 1);
    }
}

