/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.util.List;
import org.tentackle.common.Service;
import org.tentackle.session.Persistent;
import org.tentackle.validate.ValidationUtilities;
import org.tentackle.validate.Validator;

@Service(value=ValidationUtilities.class)
public class SessionValidationUtilities
extends ValidationUtilities {
    protected void sortValidators(List<Validator> validators) {
        int slotSize;
        int maxValidationIndex = 0;
        for (Validator validator : validators) {
            if (validator.getValidationIndex() <= maxValidationIndex) continue;
            maxValidationIndex = validator.getValidationIndex();
        }
        for (slotSize = 10; slotSize <= maxValidationIndex; slotSize *= 10) {
        }
        slotSize *= 10;
        for (Validator validator : validators) {
            Persistent persistent = validator.getAnnotatedElement().getAnnotation(Persistent.class);
            if (persistent == null) continue;
            validator.setValidationIndex(persistent.ordinal() * slotSize + validator.getValidationIndex());
        }
        super.sortValidators(validators);
    }
}

