/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.tentackle.bind.Bindable;
import org.tentackle.common.Cryptor;
import org.tentackle.log.Logger;
import org.tentackle.session.AbstractSessionConfiguration;
import org.tentackle.session.DriverConfiguration;
import org.tentackle.session.PersistenceException;
import org.tentackle.validate.validator.NotNull;

public class BackendConfiguration
extends AbstractSessionConfiguration {
    private static final Logger LOGGER = Logger.get(BackendConfiguration.class);
    private static final String NODE_NAME = "backends";
    private static final String URL_KEY = "url";
    private static final String OPTIONS_KEY = "options";
    private static final String DRIVER_KEY = "driver";
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    private static final String DEFAULT_KEY = "default";
    private String application;
    private String url;
    private String options;
    private DriverConfiguration driver;
    private String user;
    private String password;

    public static Map<String, BackendConfiguration> getBackendConfigurations(String application, boolean system) {
        TreeMap<String, BackendConfiguration> backends = new TreeMap<String, BackendConfiguration>();
        Preferences applicationPrefs = BackendConfiguration.getPrefNode(system).node(application);
        try {
            for (String name : applicationPrefs.childrenNames()) {
                Preferences backendPrefs = applicationPrefs.node(name);
                String driverName = backendPrefs.get(DRIVER_KEY, null);
                String url = backendPrefs.get(URL_KEY, null);
                String options = backendPrefs.get(OPTIONS_KEY, null);
                DriverConfiguration driver = null;
                if (driverName != null && (driver = DriverConfiguration.getDriverConfigurations(system).get(driverName)) == null) {
                    LOGGER.warning("no such driver: {0}", new Object[]{driverName});
                }
                String user = backendPrefs.get(USER_KEY, null);
                String password = backendPrefs.get(PASSWORD_KEY, null);
                BackendConfiguration configuration = new BackendConfiguration(application, name, url, options, driver, user, password);
                configuration.setPersisted(true);
                backends.put(name, configuration);
            }
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("cannot load backend configurations for '" + application + "'", (Throwable)bx);
        }
        return backends;
    }

    public static void removeBackendConfigurations(String application, boolean system) {
        Preferences prefs = BackendConfiguration.getPrefNode(system);
        try {
            prefs.node(application).removeNode();
            prefs.flush();
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("removing backend configurations for '" + application + "' failed", (Throwable)bx);
        }
    }

    public static void setDefault(BackendConfiguration backend, String application, boolean system) {
        Preferences prefs = BackendConfiguration.getPrefNode(system);
        Preferences node = prefs.node(application);
        try {
            if (backend == null) {
                node.remove(DEFAULT_KEY);
            } else {
                node.put(DEFAULT_KEY, backend.getName());
            }
            prefs.flush();
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("cannot set default backend configuration", (Throwable)bx);
        }
    }

    public static BackendConfiguration getDefault(String application, boolean system) {
        String name = BackendConfiguration.getPrefNode(system).node(application).get(DEFAULT_KEY, null);
        BackendConfiguration backend = null;
        if (name != null) {
            backend = BackendConfiguration.getBackendConfigurations(application, system).get(name);
        }
        return backend;
    }

    private static Preferences getPrefNode(boolean system) {
        return BackendConfiguration.getPrefNode(NODE_NAME, system);
    }

    public BackendConfiguration(String application, String name, String url, String options, DriverConfiguration driver, String user, String password) {
        this.setName(name);
        this.application = application;
        this.url = url;
        this.options = options;
        this.driver = driver;
        this.user = user;
        this.password = password;
    }

    @Bindable
    @NotNull
    public String getApplication() {
        return this.application;
    }

    @Bindable
    public void setApplication(String application) {
        this.application = application;
    }

    @Bindable
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Bindable
    public void setUrl(String url) {
        this.url = url;
    }

    @Bindable
    public String getOptions() {
        return this.options;
    }

    @Bindable
    public void setOptions(String options) {
        this.options = options;
    }

    @Bindable
    public DriverConfiguration getDriver() {
        return this.driver;
    }

    @Bindable
    public void setDriver(DriverConfiguration driver) {
        this.driver = driver;
    }

    @Bindable
    public String getUser() {
        return this.user;
    }

    @Bindable
    public void setUser(String user) {
        this.user = user;
    }

    @Bindable
    public String getPassword() {
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor != null && this.password != null) {
            return cryptor.decrypt64(this.password);
        }
        return this.password;
    }

    @Bindable
    public void setPassword(String password) {
        Cryptor cryptor = Cryptor.getInstance();
        this.password = cryptor != null && password != null ? cryptor.encrypt64(password) : password;
    }

    public void persist(boolean system) {
        Preferences prefs = BackendConfiguration.getPrefNode(system);
        Preferences node = prefs.node(this.application).node(this.getName());
        try {
            node.put(URL_KEY, this.url);
            if (this.options != null) {
                node.put(OPTIONS_KEY, this.options);
            } else {
                node.remove(OPTIONS_KEY);
            }
            if (this.driver != null) {
                node.put(DRIVER_KEY, this.driver.getName());
            } else {
                node.remove(DRIVER_KEY);
            }
            if (this.user != null && !this.user.isEmpty()) {
                node.put(USER_KEY, this.user);
            } else {
                node.remove(USER_KEY);
            }
            if (this.password != null && !this.password.isEmpty()) {
                node.put(PASSWORD_KEY, this.password);
            } else {
                node.remove(PASSWORD_KEY);
            }
            prefs.flush();
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("cannot persist backend configuration " + String.valueOf(this), (Throwable)bx);
        }
    }

    public void remove(boolean system) {
        Preferences prefs = BackendConfiguration.getPrefNode(system);
        Preferences node = prefs.node(this.application).node(this.getName());
        try {
            node.removeNode();
            prefs.flush();
        }
        catch (BackingStoreException bx) {
            throw new PersistenceException("cannot remove backend configuration " + String.valueOf(this), (Throwable)bx);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackendConfiguration that = (BackendConfiguration)o;
        return Objects.equals(this.application, that.application) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.application, this.getName());
    }
}

