/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.tentackle.common.Service;
import org.tentackle.reflect.ClassMapper;
import org.tentackle.session.MasterSerialEvent;
import org.tentackle.session.MasterSerialEventHandlerFactory;
import org.tentackle.session.PersistenceException;

@Service(value=MasterSerialEventHandlerFactory.class)
public class DefaultMasterSerialEventHandlerFactory
implements MasterSerialEventHandlerFactory {
    private final ConcurrentHashMap<Class, Optional> serviceMap = new ConcurrentHashMap();
    private final ClassMapper eventClassMapper = ClassMapper.create((String)"MasterSerial Events", MasterSerialEvent.class);

    @Override
    public <T extends MasterSerialEvent> Consumer<T> createEventHandler(Class<T> eventClass) {
        Optional constructor = this.serviceMap.computeIfAbsent(eventClass, this::getConstructor);
        if (constructor.isPresent()) {
            try {
                return (Consumer)((Constructor)constructor.get()).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new PersistenceException("cannot instantiate GUI service object for " + eventClass.getName(), (Throwable)e);
            }
        }
        return null;
    }

    protected <T extends MasterSerialEvent> Optional<Constructor<Consumer<T>>> getConstructor(Class<T> eventClass) {
        try {
            Class serviceClass = this.eventClassMapper.mapLenient(eventClass);
            try {
                return Optional.of(serviceClass.getConstructor(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new PersistenceException("no matching constructor for " + serviceClass.getName() + "(" + eventClass.getName() + ")");
            }
        }
        catch (ClassNotFoundException ex) {
            return Optional.empty();
        }
    }
}

