/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.session;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.tentackle.common.Service;
import org.tentackle.reflect.ClassMapper;
import org.tentackle.session.MasterSerialEvent;
import org.tentackle.session.MasterSerialEventHandlerFactory;
import org.tentackle.session.PersistenceException;

@Service(value=MasterSerialEventHandlerFactory.class)
public class DefaultMasterSerialEventHandlerFactory
implements MasterSerialEventHandlerFactory {
    private final ConcurrentHashMap<Class, Optional> serviceMap = new ConcurrentHashMap();
    private final ClassMapper eventClassMapper = ClassMapper.create((String)"MasterSerial Events", MasterSerialEvent.class);

    @Override
    public <T extends MasterSerialEvent> Consumer<T> getEventHandler(Class<T> eventClass) {
        Optional handler = this.serviceMap.computeIfAbsent(eventClass, this::getHandler);
        return handler.orElse(null);
    }

    protected <T extends MasterSerialEvent> Optional<Consumer<T>> getHandler(Class<T> eventClass) {
        try {
            Class serviceClass = this.eventClassMapper.mapLenient(eventClass);
            try {
                return Optional.of((Consumer)serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new PersistenceException("no no-args constructor for " + serviceClass.getName() + " (master serial event handler for " + eventClass.getName() + ")");
            }
        }
        catch (ClassNotFoundException ex) {
            return Optional.empty();
        }
    }
}

