/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tlooks;

import com.jgoodies.looks.plastic.PlasticComboBoxUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.tentackle.swing.FormComboBox;
import org.tentackle.swing.plaf.TComboPopup;
import org.tentackle.swing.plaf.TFlasherListener;
import org.tentackle.swing.plaf.TentackleLookAndFeel;

public class TLooksComboBoxUI
extends PlasticComboBoxUI {
    private static Color mandatoryColor;

    public static ComponentUI createUI(JComponent c) {
        PlasticComboBoxUI.createUI((JComponent)c);
        return new TLooksComboBoxUI();
    }

    protected void installListeners() {
        super.installListeners();
        if (((TentackleLookAndFeel)UIManager.getLookAndFeel()).isFocusAnimated()) {
            this.comboBox.addFocusListener((FocusListener)((Object)new TComboBoxFlasherListener()));
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        TFlasherListener.removeFlasherListener((JComponent)this.comboBox);
    }

    private Color getMandatoryColor() {
        Color color = UIManager.getColor("ComboBox.mandatoryBackground");
        if (mandatoryColor == null) {
            mandatoryColor = new Color(color.getRGB());
        }
        return mandatoryColor;
    }

    private boolean isArrowButtonShownAsMandatory() {
        return !this.comboBox.isEditable() && this.comboBox instanceof FormComboBox && ((FormComboBox)this.comboBox).isMandatory();
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new TMetalPropertyChangeListener();
    }

    protected JButton createArrowButton() {
        JButton button = super.createArrowButton();
        if (this.isArrowButtonShownAsMandatory()) {
            button.setBackground(this.getMandatoryColor());
        }
        return button;
    }

    public void configureArrowButton() {
        super.configureArrowButton();
        if (this.isArrowButtonShownAsMandatory()) {
            this.arrowButton.setBackground(this.getMandatoryColor());
        }
    }

    protected ComboPopup createPopup() {
        return new TComboPopup(this.comboBox);
    }

    private class TComboBoxFlasherListener
    extends TFlasherListener {
        public TComboBoxFlasherListener() {
            super((JComponent)TLooksComboBoxUI.this.comboBox);
        }

        public void actionPerformed(ActionEvent e) {
            if (!TLooksComboBoxUI.this.comboBox.isEditable()) {
                boolean bl = flasherVisible = !flasherVisible;
                if (!flasherVisible) {
                    Graphics g = TLooksComboBoxUI.this.arrowButton.getGraphics();
                    if (g != null) {
                        g.setColor(TLooksComboBoxUI.this.arrowButton.getBackground());
                        Insets insets = TLooksComboBoxUI.this.arrowButton.getInsets();
                        int width = TLooksComboBoxUI.this.arrowButton.getWidth() - (insets.left + insets.right);
                        int height = TLooksComboBoxUI.this.arrowButton.getHeight() - (insets.top + insets.bottom);
                        if (height > 0 && width > 0) {
                            int left = insets.left;
                            int top = insets.top;
                            g.drawRect(left - 1, top + 1, width, height - 4);
                        }
                    }
                } else {
                    TLooksComboBoxUI.this.arrowButton.repaint();
                }
            }
        }
    }

    public class TMetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public TMetalPropertyChangeListener() {
            super((BasicComboBoxUI)((Object)TLooksComboBoxUI.this));
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                if (TLooksComboBoxUI.this.isArrowButtonShownAsMandatory()) {
                    TLooksComboBoxUI.this.arrowButton.setBackground(TLooksComboBoxUI.this.getMandatoryColor());
                } else {
                    TLooksComboBoxUI.this.arrowButton.setBackground(color);
                }
                TLooksComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("mandatory") || propertyName.equals("editable") || propertyName.equals("enabled")) {
                Color color = TLooksComboBoxUI.this.isArrowButtonShownAsMandatory() ? TLooksComboBoxUI.this.getMandatoryColor() : TLooksComboBoxUI.this.listBox.getBackground();
                TLooksComboBoxUI.this.arrowButton.setBackground(color);
            }
        }
    }
}

