/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tlooks;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalTheme;
import org.tentackle.common.Service;
import org.tentackle.swing.plaf.PlafUtilities;
import org.tentackle.swing.plaf.TentackleLookAndFeel;
import org.tentackle.swing.plaf.tlooks.TLooksMicroLayoutPolicies;
import org.tentackle.swing.plaf.tlooks.TLooksTheme;

@Service(value=TentackleLookAndFeel.class)
public class TLooksLookAndFeel
extends Plastic3DLookAndFeel
implements TentackleLookAndFeel {
    private static final long serialVersionUID = 5384580948728456238L;
    private Color mandatoryColor;
    private Color unselectedMandatoryColor;
    private boolean focusAnimated = true;

    public TLooksLookAndFeel() {
        this.configureTLooksLookAndFeel();
    }

    public void loadTentackleExtraColors() {
        this.mandatoryColor = new ColorUIResource(255, 255, 170);
        this.unselectedMandatoryColor = new ColorUIResource(PlafUtilities.getInstance().brighter(this.mandatoryColor, 0.75));
    }

    public Color getMandatoryColor() {
        return this.mandatoryColor;
    }

    public void setMandatoryColor(Color mandatoryColor) {
        this.mandatoryColor = mandatoryColor;
    }

    public Color getUnselectedMandatoryColor() {
        return this.unselectedMandatoryColor;
    }

    public void setUnselectedMandatoryColor(Color unselectedMandatoryColor) {
        this.unselectedMandatoryColor = unselectedMandatoryColor;
    }

    protected void createDefaultTheme() {
        TLooksLookAndFeel.setCurrentTheme((MetalTheme)((Object)new TLooksTheme()));
    }

    public void configureTLooksLookAndFeel() {
        PlasticLookAndFeel.setTabStyle((String)"metal");
        PlasticLookAndFeel.set3DEnabled((boolean)true);
        Options.setPopupDropShadowEnabled((boolean)true);
        UIManager.put("Plastic.MicroLayoutPolicy", TLooksMicroLayoutPolicies.getDefaultPlasticPolicy());
    }

    public static String getTLooksName() {
        return "TLooks";
    }

    public static String getTLooksDescription() {
        return "Enhanced JGoodies LnF for Tentackle";
    }

    public String getName() {
        return TLooksLookAndFeel.getTLooksName();
    }

    public String getDescription() {
        return TLooksLookAndFeel.getTLooksDescription();
    }

    public String getID() {
        return this.getName();
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String tLooksPackageName = "org.tentackle.swing.plaf.tlooks.";
        Object[] uiDefaults = new Object[]{"ButtonUI", "org.tentackle.swing.plaf.tlooks.TLooksButtonUI", "ComboBoxUI", "org.tentackle.swing.plaf.tlooks.TLooksComboBoxUI", "RadioButtonUI", "org.tentackle.swing.plaf.tlooks.TLooksRadioButtonUI", "CheckBoxUI", "org.tentackle.swing.plaf.tlooks.TLooksCheckBoxUI", "TextFieldUI", "org.tentackle.swing.plaf.tlooks.TLooksTextFieldUI", "TextAreaUI", "org.tentackle.swing.plaf.tlooks.TLooksTextAreaUI", "TableUI", "org.tentackle.swing.plaf.tlooks.TLooksTableUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        String iconPrefix = "icons/" + (LookUtils.IS_LOW_RESOLUTION ? "32x32/" : "48x48/");
        Object[] defaults = new Object[]{"OptionPane.errorIcon", this.loadLooksIcon(iconPrefix + "dialog-error.png"), "OptionPane.informationIcon", this.loadLooksIcon(iconPrefix + "dialog-information.png"), "OptionPane.questionIcon", this.loadLooksIcon(iconPrefix + "dialog-question.png"), "OptionPane.warningIcon", this.loadLooksIcon(iconPrefix + "dialog-warning.png"), "FileView.computerIcon", this.loadLooksIcon("icons/Computer.gif"), "FileView.directoryIcon", this.loadLooksIcon("icons/TreeClosed.gif"), "FileView.fileIcon", this.loadLooksIcon("icons/File.gif"), "FileView.floppyDriveIcon", this.loadLooksIcon("icons/FloppyDrive.gif"), "FileView.hardDriveIcon", this.loadLooksIcon("icons/HardDrive.gif"), "FileChooser.homeFolderIcon", this.loadLooksIcon("icons/HomeFolder.gif"), "FileChooser.newFolderIcon", this.loadLooksIcon("icons/NewFolder.gif"), "FileChooser.upFolderIcon", this.loadLooksIcon("icons/UpFolder.gif"), "Tree.closedIcon", this.loadLooksIcon("icons/TreeClosed.gif"), "Tree.openIcon", this.loadLooksIcon("icons/TreeOpen.gif"), "Tree.leafIcon", this.loadLooksIcon("icons/TreeLeaf.gif"), "TextField.mandatoryBackground", this.getMandatoryColor(), "TextArea.mandatoryBackground", this.getMandatoryColor(), "TextArea.inactiveBackground", table.getColor("control"), "ComboBox.mandatoryBackground", this.getMandatoryColor(), "CheckBox.mandatoryBackground", this.getMandatoryColor(), "RadioButton.mandatoryBackground", this.getMandatoryColor(), "Table.selectedMandatoryBackground", this.getMandatoryColor(), "Table.unselectedMandatoryBackground", this.getUnselectedMandatoryColor()};
        table.putDefaults(defaults);
    }

    protected Object loadLooksIcon(String name) {
        return TLooksLookAndFeel.makeIcon(PlasticLookAndFeel.class, (String)name);
    }

    public ImageIcon loadImageIcon(String name) throws MissingResourceException {
        URL url = TLooksLookAndFeel.class.getResource("icons/" + name + ".png");
        if (url == null) {
            url = TLooksLookAndFeel.class.getResource("icons/" + name + ".gif");
        }
        if (url == null) {
            throw new MissingResourceException("no such icon '" + name + "'", TLooksLookAndFeel.class.getName(), name);
        }
        return new ImageIcon(url);
    }

    public void setFocusAnimated(boolean flag) {
        this.focusAnimated = flag;
    }

    public boolean isFocusAnimated() {
        return this.focusAnimated;
    }
}

