/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tlooks;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicy;
import javax.swing.UIDefaults;
import org.tentackle.swing.plaf.tlooks.TLooksMicroLayouts;

public class TLooksMicroLayoutPolicies {
    private TLooksMicroLayoutPolicies() {
    }

    public static MicroLayoutPolicy getDefaultPlasticPolicy() {
        return new DefaultPlasticPolicy();
    }

    public static MicroLayoutPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    private static final class DefaultWindowsPolicy
    implements MicroLayoutPolicy {
        private DefaultWindowsPolicy() {
        }

        public MicroLayout getMicroLayout(String lafName, UIDefaults table) {
            boolean isClassic = !LookUtils.IS_LAF_WINDOWS_XP_ENABLED;
            boolean isVista = LookUtils.IS_OS_WINDOWS_VISTA;
            boolean isLowRes = LookUtils.IS_LOW_RESOLUTION;
            if (isClassic) {
                return isLowRes ? TLooksMicroLayouts.createWindowsClassicLowResMicroLayout() : TLooksMicroLayouts.createWindowsClassicHiResMicroLayout();
            }
            if (isVista) {
                return isLowRes ? TLooksMicroLayouts.createWindowsVistaLowResMicroLayout() : TLooksMicroLayouts.createWindowsVistaHiResMicroLayout();
            }
            return isLowRes ? TLooksMicroLayouts.createWindowsXPLowResMicroLayout() : TLooksMicroLayouts.createWindowsXPHiResMicroLayout();
        }
    }

    private static final class DefaultPlasticPolicy
    implements MicroLayoutPolicy {
        private DefaultPlasticPolicy() {
        }

        public MicroLayout getMicroLayout(String lafName, UIDefaults table) {
            boolean isClassic = !LookUtils.IS_LAF_WINDOWS_XP_ENABLED;
            boolean isVista = LookUtils.IS_OS_WINDOWS_VISTA;
            boolean isLowRes = LookUtils.IS_LOW_RESOLUTION;
            boolean isPlasticXP = lafName.equals("JGoodies Plastic XP");
            if (isPlasticXP) {
                if (isVista) {
                    return isClassic ? TLooksMicroLayouts.createPlasticXPVistaClassicMicroLayout() : TLooksMicroLayouts.createPlasticXPVistaMicroLayout();
                }
                return isLowRes ? TLooksMicroLayouts.createPlasticXPLowResMicroLayout() : TLooksMicroLayouts.createPlasticXPHiResMicroLayout();
            }
            if (isVista) {
                return isClassic ? TLooksMicroLayouts.createPlasticVistaClassicMicroLayout() : TLooksMicroLayouts.createPlasticVistaMicroLayout();
            }
            return isLowRes ? TLooksMicroLayouts.createPlasticLowResMicroLayout() : TLooksMicroLayouts.createPlasticHiResMicroLayout();
        }
    }
}

