/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.print.PrintLabel;

public class PrintTable
extends FormTable {
    public PrintTable() {
    }

    public PrintTable(TableModel model) {
        super(model);
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height += this.getRowHeight() + this.getRowMargin();
        return dim;
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(new Dimension(preferredSize.width, preferredSize.height - this.getRowHeight() - this.getRowMargin()));
    }

    public void print(Graphics g) {
        int headerHeight = this.getRowHeight() + this.getRowMargin();
        Dimension size = super.getSize();
        super.setSize(size.width, size.height - headerHeight);
        JTableHeader header = this.getTableHeader();
        PrintLabel pl = new PrintLabel();
        pl.setHorizontalAlignment(0);
        pl.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        Font font = this.getFont();
        pl.setFont(new Font(font.getName(), 1, font.getSize()));
        pl.setForeground(header.getForeground());
        pl.setBackground(header.getBackground());
        TableColumnModel model = header.getColumnModel();
        int columns = model.getColumnCount();
        int columnMargin = model.getColumnMargin();
        g.translate(columnMargin, 0);
        for (int i = 0; i < columns; ++i) {
            TableColumn col = model.getColumn(i);
            Rectangle rect = header.getHeaderRect(i);
            rect.height = this.getRowHeight();
            pl.setBounds(rect);
            pl.setText(this.getColumnName(i));
            g.translate(rect.x, rect.y);
            pl.print(g);
            g.translate(-rect.x, -rect.y);
        }
        g.translate(0, headerHeight);
        super.print(g);
        g.translate(-columnMargin, -headerHeight);
        super.setSize(size);
    }
}

