/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import org.tentackle.swing.print.PrintHelper;
import org.tentackle.swing.print.PrintPanel;
import org.tentackle.swing.print.ReportSource;

public class Report
implements Printable,
Pageable {
    public static final int NORTHWEST = 18;
    public static final int NORTHEAST = 12;
    public static final int SOUTHWEST = 16;
    public static final int SOUTHEAST = 14;
    public static final int CENTER = 10;
    public static final int EAST = 13;
    public static final int WEST = 17;
    public static final int SOUTH = 15;
    public static final int NORTH = 11;
    public static final int SCALE_FIXED = 0;
    public static final int SCALE_IF_WIDER = 1;
    public static final int SCALE_TO_FIT = 2;
    private final ReportSource source;
    private final PageFormat pageFormat;
    private final int subLevels;
    private final boolean imageable;
    private int autoScale = 0;
    private double scale = 1.0;
    private PrintPanel intro;
    private PrintPanel trailer;
    private PrintPanel header;
    private PrintPanel footer;
    private PrintPanel line;
    private PrintPanel[] subHeader;
    private PrintPanel[] subFooter;
    private int introHeight;
    private int trailerHeight;
    private int headerHeight;
    private int footerHeight;
    private int lineHeight;
    private int[] subHeaderHeight;
    private int[] subFooterHeight;
    private int introWidth;
    private int trailerWidth;
    private int headerWidth;
    private int footerWidth;
    private int lineWidth;
    private int[] subHeaderWidth;
    private int[] subFooterWidth;
    private int introAlignment = 18;
    private int trailerAlignment = 18;
    private int headerAlignment = 18;
    private int footerAlignment = 18;
    private int lineAlignment = 18;
    private int[] subHeaderAlignment;
    private int[] subFooterAlignment;
    private boolean initDone;
    private int pages;
    private int yOffset;
    private int yMax;
    private State state;
    private State savedState;

    public Report(ReportSource source, PageFormat pageFormat, boolean imageable, int subLevels) {
        this.source = source;
        this.pageFormat = pageFormat;
        this.imageable = imageable;
        this.subLevels = subLevels;
        if (subLevels > 0) {
            this.subHeader = new PrintPanel[subLevels];
            this.subFooter = new PrintPanel[subLevels];
            this.subHeaderHeight = new int[subLevels];
            this.subFooterHeight = new int[subLevels];
            this.subHeaderWidth = new int[subLevels];
            this.subFooterWidth = new int[subLevels];
            this.subHeaderAlignment = new int[subLevels];
            this.subFooterAlignment = new int[subLevels];
            for (int i = 0; i < subLevels; ++i) {
                this.subHeaderAlignment[i] = 18;
                this.subFooterAlignment[i] = 18;
            }
        }
        this.initDone = false;
    }

    public Report(ReportSource source, PageFormat pageFormat) {
        this(source, pageFormat, true, 0);
    }

    public void setIntro(PrintPanel intro) throws PrinterException {
        if (intro == null) {
            this.introWidth = 0;
            this.introHeight = 0;
        } else {
            this.introWidth = intro.getWidth();
            this.introHeight = intro.getHeight();
        }
        this.intro = intro;
    }

    public void setTrailer(PrintPanel trailer) throws PrinterException {
        if (trailer == null) {
            this.trailerWidth = 0;
            this.trailerHeight = 0;
        } else {
            this.trailerWidth = trailer.getWidth();
            this.trailerHeight = trailer.getHeight();
        }
        this.trailer = trailer;
    }

    public void setHeader(PrintPanel header) throws PrinterException {
        if (header == null) {
            this.headerWidth = 0;
            this.headerHeight = 0;
        } else {
            this.headerWidth = header.getWidth();
            this.headerHeight = header.getHeight();
        }
        this.header = header;
    }

    public void setFooter(PrintPanel footer) throws PrinterException {
        if (footer == null) {
            this.footerWidth = 0;
            this.footerHeight = 0;
        } else {
            this.footerWidth = footer.getWidth();
            this.footerHeight = footer.getHeight();
        }
        this.footer = footer;
    }

    public void setLine(PrintPanel line) throws PrinterException {
        if (line == null) {
            this.lineWidth = 0;
            this.lineHeight = 0;
        } else {
            this.lineWidth = line.getWidth();
            this.lineHeight = line.getHeight();
        }
        this.line = line;
    }

    public void setSubHeader(PrintPanel[] subHeader) throws PrinterException {
        if (subHeader.length != this.subLevels) {
            throw new PrinterException("subHeader don't match subLevels");
        }
        for (int i = 0; i < this.subLevels; ++i) {
            this.subHeaderWidth[i] = subHeader[i] == null ? 0 : subHeader[i].getWidth();
            this.subHeaderHeight[i] = subHeader[i] == null ? 0 : subHeader[i].getHeight();
        }
        this.subHeader = subHeader;
    }

    public void setSubFooter(PrintPanel[] subFooter) throws PrinterException {
        if (subFooter.length != this.subLevels) {
            throw new PrinterException("subFooter don't match subLevels");
        }
        for (int i = 0; i < this.subLevels; ++i) {
            this.subFooterWidth[i] = subFooter[i] == null ? 0 : subFooter[i].getWidth();
            this.subFooterHeight[i] = subFooter[i] == null ? 0 : subFooter[i].getHeight();
        }
        this.subFooter = subFooter;
    }

    public void setIntroAlignment(int align) throws PrinterException {
        if (this.intro == null) {
            throw new PrinterException("can't set alignment for null-intro");
        }
        this.introAlignment = align;
    }

    public void setTrailerAlignment(int align) throws PrinterException {
        if (this.trailer == null) {
            throw new PrinterException("can't set alignment for null-trailer");
        }
        this.trailerAlignment = align;
    }

    public void setHeaderAlignment(int align) throws PrinterException {
        if (this.header == null) {
            throw new PrinterException("can't set alignment for null-header");
        }
        this.headerAlignment = align;
    }

    public void setFooterAlignment(int align) throws PrinterException {
        if (this.footer == null) {
            throw new PrinterException("can't set alignment for null-footer");
        }
        this.footerAlignment = align;
    }

    public void setLineAlignment(int align) throws PrinterException {
        if (this.line == null) {
            throw new PrinterException("can't set alignment for null-line");
        }
        this.lineAlignment = align;
    }

    public void setSubHeaderAlignment(int[] align) throws PrinterException {
        if (this.subHeader.length != this.subLevels) {
            throw new PrinterException("subHeaderAlignments don't match subLevels");
        }
        this.subHeaderAlignment = align;
    }

    public void setSubFooterAlignment(int[] align) throws PrinterException {
        if (this.subFooter.length != this.subLevels) {
            throw new PrinterException("subFooterAlignments don't match subLevels");
        }
        this.subFooterAlignment = align;
    }

    public void setIntroSize(Dimension size) throws PrinterException {
        if (this.intro == null) {
            throw new PrinterException("can't set size for null-intro");
        }
        this.introWidth = size.width;
        this.introHeight = size.height;
    }

    public void setTrailerSize(Dimension size) throws PrinterException {
        if (this.trailer == null) {
            throw new PrinterException("can't set size for null-trailer");
        }
        this.trailerWidth = size.width;
        this.trailerHeight = size.height;
    }

    public void setHeaderSize(Dimension size) throws PrinterException {
        if (this.header == null) {
            throw new PrinterException("can't set size for null-header");
        }
        this.headerWidth = size.width;
        this.headerHeight = size.height;
    }

    public void setFooterSize(Dimension size) throws PrinterException {
        if (this.footer == null) {
            throw new PrinterException("can't set size for null-footer");
        }
        this.footerWidth = size.width;
        this.footerHeight = size.height;
    }

    public void setLineSize(Dimension size) throws PrinterException {
        if (this.line == null) {
            throw new PrinterException("can't set size for null-line");
        }
        this.lineWidth = size.width;
        this.lineHeight = size.height;
    }

    public void setSubHeaderSize(Dimension[] sizes) throws PrinterException {
        if (this.subHeader.length != this.subLevels) {
            throw new PrinterException("subHeaderSizes don't match subLevels");
        }
        for (int i = 0; i < this.subLevels; ++i) {
            this.subHeaderWidth[i] = sizes[i].width;
            this.subHeaderHeight[i] = sizes[i].height;
        }
    }

    public void setSubFooterSize(Dimension[] sizes) throws PrinterException {
        if (this.subFooter.length != this.subLevels) {
            throw new PrinterException("subFooterSizes don't match subLevels");
        }
        for (int i = 0; i < this.subLevels; ++i) {
            this.subFooterWidth[i] = sizes[i].width;
            this.subFooterHeight[i] = sizes[i].height;
        }
    }

    public int getLevel() {
        return this.state.level;
    }

    public int currentState() {
        return this.state.advance;
    }

    public int currentPage() {
        return this.state.lastPageIndex + 1;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public void setAutoScale(int autoScale) {
        this.autoScale = autoScale;
    }

    public int getAutoScale() {
        return this.autoScale;
    }

    public void setMoveBefore(int moveBefore) {
        this.state.moveBefore = moveBefore;
    }

    public int getMoveBefore() {
        return this.state.moveBefore;
    }

    public void setMoveAfter(int moveAfter) {
        this.state.moveAfter = moveAfter;
    }

    public int getMoveAfter() {
        return this.state.moveAfter;
    }

    public void setRunBefore(Runnable runBefore) {
        this.state.runBefore = runBefore;
    }

    public Runnable getRunBefore() {
        return this.state.runBefore;
    }

    public void setRunAfter(Runnable runAfter) {
        this.state.runAfter = runAfter;
    }

    public Runnable getRunAfter() {
        return this.state.runAfter;
    }

    public void triggerPrintAgain() {
        this.state.printAgain = true;
    }

    public int getYMax() {
        return this.yMax;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getAdvance() {
        return this.state.advance;
    }

    @Override
    public int getNumberOfPages() {
        if (this.pages == -1) {
            this.init();
            try {
                this.pages = 0;
                while (this.print(null, this.pageFormat, this.pages) == 0) {
                    ++this.pages;
                }
            }
            catch (PrinterException e) {
                this.pages = -1;
            }
            this.initDone = false;
        }
        return this.pages;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.print((Graphics2D)graphics, pageFormat, pageIndex, false);
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex >= this.pages) {
            throw new IndexOutOfBoundsException("requested page " + (pageIndex + 1) + " of " + this.pages);
        }
        if (pageIndex == this.pages - 1) {
            this.source.close();
        }
        return this;
    }

    private int print(Graphics2D g2d, PageFormat pageFormat, int pageIndex, boolean countOnly) throws PrinterException {
        this.init();
        if (this.state.lastPageIndex == pageIndex && this.savedState != null) {
            this.state = this.savedState;
            this.savedState = null;
            this.source.restore();
        } else {
            this.savedState = this.state.clone();
            this.source.save();
        }
        this.state.lastPageIndex = pageIndex;
        if (!(this.state.lastPagePrinted || pageIndex < 0 || this.pages != -1 && pageIndex >= this.pages)) {
            int yDiff;
            int pageWidth;
            int pageHeight;
            PrintHelper.adjustGraphics2D(g2d, pageFormat);
            if (this.autoScale != 0) {
                this.scale = (this.imageable ? pageFormat.getImageableWidth() : pageFormat.getWidth()) / (double)this.getMaxWidth();
                if (this.autoScale == 1 && this.scale > 1.0) {
                    this.scale = 1.0;
                }
            }
            g2d.scale(this.scale, this.scale);
            if (this.imageable) {
                g2d.translate((int)(pageFormat.getImageableX() / this.scale), (int)(pageFormat.getImageableY() / this.scale));
                pageHeight = (int)(pageFormat.getImageableHeight() / this.scale);
                pageWidth = (int)(pageFormat.getImageableWidth() / this.scale);
            } else {
                pageHeight = (int)(pageFormat.getHeight() / this.scale);
                pageWidth = (int)(pageFormat.getWidth() / this.scale);
            }
            this.yOffset = 0;
            this.yMax = 0;
            if (pageIndex == 0) {
                if (this.intro != null) {
                    if (countOnly) {
                        this.yOffset += this.introHeight + this.alignPanelVertically(this.intro, this.introAlignment, this.introHeight, pageHeight);
                    } else {
                        do {
                            this.state.printAgain = false;
                            yDiff = this.source.prepareIntro(this);
                            if (yDiff != 0) {
                                g2d.translate(0, yDiff);
                                this.yOffset += yDiff;
                            }
                            yDiff = this.printPanel(g2d, this.intro, this.introAlignment, this.introWidth, this.introHeight, pageWidth, pageHeight, this.yOffset);
                            g2d.translate(0, yDiff);
                            this.yOffset += yDiff;
                        } while (this.state.printAgain);
                    }
                    this.yMax = this.yOffset;
                }
            } else if (this.header != null) {
                if (countOnly) {
                    this.yOffset += this.headerHeight + this.alignPanelVertically(this.header, this.headerAlignment, this.headerHeight, pageHeight);
                } else {
                    do {
                        this.state.printAgain = false;
                        yDiff = this.source.prepareHeader(this);
                        if (yDiff != 0) {
                            g2d.translate(0, yDiff);
                            this.yOffset += yDiff;
                        }
                        yDiff = this.printPanel(g2d, this.header, this.headerAlignment, this.headerWidth, this.headerHeight, pageWidth, pageHeight, this.yOffset);
                        g2d.translate(0, yDiff);
                        this.yOffset += yDiff;
                    } while (this.state.printAgain);
                }
                this.yMax = this.yOffset;
            }
            while (true) {
                int subHeight;
                int topHeight;
                int n = topHeight = pageIndex == 0 ? this.introHeight : this.headerHeight;
                if (this.lineHeight > pageHeight - topHeight - this.footerHeight) {
                    throw new PrinterException("not even the first data line will not fit onto the page");
                }
                if (this.source.hasNext() && this.yOffset + this.lineHeight + this.footerHeight > pageHeight) break;
                if (this.state.runBefore != null) {
                    this.state.runBefore.run();
                    this.state.runBefore = null;
                }
                if (this.state.pending != -1) {
                    this.state.advance = this.state.pending;
                    this.state.pending = -1;
                } else if (this.state.advance != 0) {
                    this.state.advance = this.source.advance(this);
                }
                if (this.state.advance == -1) {
                    throw new PrinterException("ReportSource.prepare() failed");
                }
                if (this.state.moveBefore != 0) {
                    g2d.translate(0, this.state.moveBefore);
                    this.yOffset += this.state.moveBefore;
                    if (this.yOffset > this.yMax) {
                        this.yMax = this.yOffset;
                    }
                    this.state.moveBefore = 0;
                    this.state.pending = this.state.advance;
                    continue;
                }
                if (this.state.advance == 0) {
                    while (this.state.level > 0) {
                        --this.state.level;
                        subHeight = this.subFooterHeight[this.state.level];
                        if (subHeight <= 0) continue;
                        if (this.yOffset + subHeight >= pageHeight) {
                            this.state.pending = this.state.advance;
                            ++this.state.level;
                            return 0;
                        }
                        if (countOnly) {
                            this.yOffset += subHeight + this.alignPanelVertically(this.subFooter[this.state.level], this.subFooterAlignment[this.state.level], subHeight, pageHeight);
                            continue;
                        }
                        do {
                            this.state.printAgain = false;
                            yDiff = this.source.prepareSubFooter(this, this.state.level + 1);
                            if (yDiff != 0) {
                                g2d.translate(0, yDiff);
                                this.yOffset += yDiff;
                            }
                            yDiff = this.printPanel(g2d, this.subFooter[this.state.level], this.subFooterAlignment[this.state.level], this.subFooterWidth[this.state.level], subHeight, pageWidth, pageHeight, this.yOffset);
                            g2d.translate(0, yDiff);
                            this.yOffset += yDiff;
                        } while (this.state.printAgain);
                    }
                    if (this.trailerHeight > 0) {
                        if (this.yOffset + this.trailerHeight >= pageHeight) {
                            this.state.pending = this.state.advance;
                            break;
                        }
                        if (this.yMax > this.yOffset) {
                            g2d.translate(0, this.yMax - this.yOffset);
                            this.yOffset = this.yMax;
                        }
                        if (countOnly) {
                            this.yOffset += this.trailerHeight + this.alignPanelVertically(this.trailer, this.trailerAlignment, this.trailerHeight, pageHeight);
                        } else {
                            do {
                                this.state.printAgain = false;
                                yDiff = this.source.prepareTrailer(this);
                                if (yDiff != 0) {
                                    g2d.translate(0, yDiff);
                                    this.yOffset += yDiff;
                                }
                                yDiff = this.printPanel(g2d, this.trailer, this.trailerAlignment, this.trailerWidth, this.trailerHeight, pageWidth, pageHeight, this.yOffset);
                                g2d.translate(0, yDiff);
                                this.yOffset += yDiff;
                            } while (this.state.printAgain);
                        }
                    }
                    this.state.lastPagePrinted = true;
                    return 0;
                }
                if (this.state.advance == 1) {
                    if (countOnly) {
                        this.yOffset += this.lineHeight + this.alignPanelVertically(this.line, this.lineAlignment, this.lineHeight, pageHeight);
                    } else {
                        do {
                            this.state.printAgain = false;
                            yDiff = this.source.prepareLine(this);
                            if (yDiff != 0) {
                                g2d.translate(0, yDiff);
                                this.yOffset += yDiff;
                            }
                            boolean clip = false;
                            if (this.yOffset + this.lineHeight + this.footerHeight > pageHeight) {
                                this.lineHeight = pageHeight - this.footerHeight - this.yOffset;
                                if (this.lineHeight <= 0) {
                                    this.lineHeight = 1;
                                }
                                g2d.setClip(0, 0, pageWidth, this.lineHeight);
                                clip = true;
                            }
                            yDiff = this.printPanel(g2d, this.line, this.lineAlignment, this.lineWidth, this.lineHeight, pageWidth, pageHeight, this.yOffset);
                            if (clip) {
                                g2d.setClip(0, 0, pageWidth, pageHeight);
                            }
                            g2d.translate(0, yDiff);
                            this.yOffset += yDiff;
                        } while (this.state.printAgain);
                    }
                } else if (this.state.advance == 2) {
                    if (this.state.level >= this.subLevels) {
                        throw new PrinterException("PUSH beyond " + this.subLevels);
                    }
                    subHeight = this.subHeaderHeight[this.state.level];
                    if (subHeight > 0) {
                        if (this.yOffset + subHeight + this.lineHeight + this.footerHeight >= pageHeight) {
                            this.state.pending = this.state.advance;
                            break;
                        }
                        if (countOnly) {
                            this.yOffset += subHeight + this.source.prepareSubHeader(this, this.state.level + 1) + this.alignPanelVertically(this.subHeader[this.state.level], this.subHeaderAlignment[this.state.level], subHeight, pageHeight);
                        } else {
                            do {
                                this.state.printAgain = false;
                                yDiff = this.source.prepareSubHeader(this, this.state.level + 1);
                                if (yDiff != 0) {
                                    g2d.translate(0, yDiff);
                                    this.yOffset += yDiff;
                                }
                                yDiff = this.printPanel(g2d, this.subHeader[this.state.level], this.subHeaderAlignment[this.state.level], this.subHeaderWidth[this.state.level], subHeight, pageWidth, pageHeight, this.yOffset);
                                g2d.translate(0, yDiff);
                                this.yOffset += yDiff;
                            } while (this.state.printAgain);
                        }
                    } else {
                        this.source.prepareSubHeader(this, this.state.level + 1);
                    }
                    ++this.state.level;
                } else if (this.state.advance == 3) {
                    if (this.state.level <= 0) {
                        throw new PrinterException("POP from level zero");
                    }
                    --this.state.level;
                    subHeight = this.subFooterHeight[this.state.level];
                    if (subHeight > 0) {
                        if (this.yOffset + subHeight >= pageHeight) {
                            this.state.pending = this.state.advance;
                            ++this.state.level;
                            break;
                        }
                        if (countOnly) {
                            this.yOffset += subHeight + this.source.prepareSubFooter(this, this.state.level + 1) + this.alignPanelVertically(this.subFooter[this.state.level], this.subFooterAlignment[this.state.level], subHeight, pageHeight);
                        } else {
                            do {
                                this.state.printAgain = false;
                                yDiff = this.source.prepareSubFooter(this, this.state.level + 1);
                                if (yDiff != 0) {
                                    g2d.translate(0, yDiff);
                                    this.yOffset += yDiff;
                                }
                                yDiff = this.printPanel(g2d, this.subFooter[this.state.level], this.subFooterAlignment[this.state.level], this.subFooterWidth[this.state.level], subHeight, pageWidth, pageHeight, this.yOffset);
                                g2d.translate(0, yDiff);
                                this.yOffset += yDiff;
                            } while (this.state.printAgain);
                        }
                    } else {
                        this.source.prepareSubFooter(this, this.state.level + 1);
                    }
                }
                if (this.yOffset > this.yMax) {
                    this.yMax = this.yOffset;
                }
                if (this.state.moveAfter != 0) {
                    g2d.translate(0, this.state.moveAfter);
                    this.yOffset += this.state.moveAfter;
                    this.state.moveAfter = 0;
                }
                if (this.state.runAfter == null) continue;
                this.state.runAfter.run();
                this.state.runAfter = null;
            }
            if (this.state.advance != 0 || this.state.pending == 0) {
                if (this.footerHeight != 0) {
                    if (this.yMax > this.yOffset) {
                        g2d.translate(0, this.yMax - this.yOffset);
                        this.yOffset = this.yMax;
                    }
                    if (countOnly) {
                        this.yOffset += this.footerHeight + this.alignPanelVertically(this.footer, this.footerAlignment, this.footerHeight, pageHeight);
                    } else {
                        do {
                            this.state.printAgain = false;
                            yDiff = this.source.prepareFooter(this);
                            if (yDiff != 0) {
                                g2d.translate(0, yDiff);
                                this.yOffset += yDiff;
                            }
                            yDiff = this.printPanel(g2d, this.footer, this.footerAlignment, this.footerWidth, this.footerHeight, pageWidth, pageHeight, this.yOffset);
                            g2d.translate(0, yDiff);
                            this.yOffset += yDiff;
                        } while (this.state.printAgain);
                    }
                }
                return 0;
            }
        }
        if (!countOnly && this.pages == -1) {
            this.source.close();
        }
        return 1;
    }

    private void init() {
        if (!this.initDone) {
            this.state = new State();
            this.pages = -1;
            if (this.initDone) {
                this.source.rewind();
            } else {
                this.source.open();
            }
            this.initDone = true;
        }
    }

    private int alignPanelHorizontally(PrintPanel panel, int align, int panelWidth, int pageWidth) {
        switch (align) {
            case 12: 
            case 13: 
            case 14: {
                return pageWidth - panelWidth;
            }
            case 10: 
            case 11: 
            case 15: {
                return (pageWidth - panelWidth) / 2;
            }
        }
        return 0;
    }

    private int alignPanelVertically(PrintPanel panel, int align, int panelHeight, int pageHeight) {
        switch (align) {
            case 14: 
            case 15: 
            case 16: {
                return pageHeight - panelHeight;
            }
            case 10: 
            case 13: 
            case 17: {
                return (pageHeight - panelHeight) / 2;
            }
        }
        return 0;
    }

    private int printPanel(Graphics graphics, PrintPanel panel, int align, int panelWidth, int panelHeight, int pageWidth, int pageHeight, int currentOffset) {
        int xOff = this.alignPanelHorizontally(panel, align, panelWidth, pageWidth);
        int yOff = this.alignPanelVertically(panel, align, panelHeight, pageHeight - currentOffset);
        Graphics2D g2d = (Graphics2D)graphics;
        if (xOff != 0 || yOff != 0) {
            g2d.translate(xOff, yOff);
        }
        panel.print(graphics);
        if (xOff != 0 || yOff != 0) {
            g2d.translate(-xOff, -yOff);
        }
        return yOff + panelHeight;
    }

    private int getMaxWidth() {
        int i;
        int max = this.introWidth;
        if (this.trailerWidth > max) {
            max = this.trailerWidth;
        }
        if (this.headerWidth > max) {
            max = this.headerWidth;
        }
        if (this.footerWidth > max) {
            max = this.footerWidth;
        }
        if (this.lineWidth > max) {
            max = this.lineWidth;
        }
        if (this.subHeaderWidth != null) {
            for (i = 0; i < this.subHeaderWidth.length; ++i) {
                if (this.subHeaderWidth[i] <= max) continue;
                max = this.subHeaderWidth[i];
            }
        }
        if (this.subFooterWidth != null) {
            for (i = 0; i < this.subFooterWidth.length; ++i) {
                if (this.subFooterWidth[i] <= max) continue;
                max = this.subFooterWidth[i];
            }
        }
        return max;
    }

    private class State
    implements Cloneable {
        int lastPageIndex = -1;
        int level = 0;
        int advance = -1;
        int pending = -1;
        boolean lastPagePrinted = false;
        int moveBefore;
        int moveAfter;
        Runnable runBefore;
        Runnable runAfter;
        boolean printAgain;

        private State() {
        }

        public State clone() {
            try {
                return (State)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }
    }
}

