/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.text.DecimalFormat;
import org.tentackle.misc.FormatHelper;
import org.tentackle.swing.print.PrintLabel;

public abstract class NumberPrintLabel
extends PrintLabel {
    protected DecimalFormat format = new DecimalFormat(FormatHelper.getIntegerPattern());
    private boolean blankZero;
    private int scale;

    public NumberPrintLabel(int columns) {
        super(columns, 11);
        this.setPrintValue(0);
    }

    public NumberPrintLabel() {
        this(0);
    }

    @Override
    public void setPrintValue(Object value) {
        this.value = value;
        this.setText(value == null ? null : this.doFormat(value));
    }

    public abstract String doFormat(Object var1);

    public void setFormat(String pattern) {
        this.format = new DecimalFormat(pattern);
        this.scale = 0;
        int dotNdx = pattern.lastIndexOf(46);
        if (dotNdx >= 0) {
            ++dotNdx;
            while (dotNdx < pattern.length() && pattern.charAt(dotNdx) == '0') {
                ++this.scale;
                ++dotNdx;
            }
        }
    }

    public String getFormat() {
        return this.format.toPattern();
    }

    public void setScale(int scale) {
        if (this.scale != scale) {
            FormatHelper.setScale((DecimalFormat)this.format, (int)scale);
            this.scale = scale;
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setBlankZero(boolean blankZero) {
        this.blankZero = blankZero;
    }

    public boolean isBlankZero() {
        return this.blankZero;
    }
}

