/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.WorkerThread;
import org.tentackle.swing.print.PrintSwingPrintBundle;

public final class PrintHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintHelper.class);
    private static final double DOTS_PER_INCH = 72.0;
    private static MediaSize mediaSize;
    private static MediaSizeName mediaSizeName;
    private static MediaPrintableArea area;
    private static Runnable runBeforePrint;
    private static Runnable runAfterPrint;
    private static final Queue<JobRequest> modalJobQueue;
    private static final Queue<JobRequest> nonModalJobQueue;
    private static WorkerThread modalJobThread;
    private static WorkerThread nonModalJobThread;

    public static boolean print(Printable printable, String jobName) {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(mediaSizeName);
        aset.add(area);
        PrinterJob job = PrinterJob.getPrinterJob();
        if (jobName != null) {
            aset.add(new JobName(jobName, Locale.getDefault()));
            job.setJobName(jobName);
        }
        job.setPrintable(printable);
        if (job.printDialog(aset)) {
            try {
                job.print(aset);
                return true;
            }
            catch (PrinterException pe) {
                FormError.showException((String)PrintSwingPrintBundle.getString("PRINTING FAILED!"), (Throwable)pe);
            }
        }
        return false;
    }

    public static PageFormat print(PrinterJob job, String jobName, PrintRequestAttributeSet aset) {
        if (aset.get(Media.class) == null) {
            aset.add(mediaSizeName);
        }
        if (aset.get(MediaPrintableArea.class) == null) {
            aset.add(area);
        }
        if (jobName != null) {
            aset.add(new JobName(jobName, Locale.getDefault()));
            job.setJobName(jobName);
        }
        if (job.printDialog(aset)) {
            return PrintHelper.getPageFormat(aset);
        }
        return null;
    }

    public static boolean adjustGraphics2D(Graphics2D g, PageFormat format) {
        AffineTransform oldTransform;
        if (format.getOrientation() != 1 && ((oldTransform = g.getTransform()).getType() & 8) == 0) {
            g.setTransform(new AffineTransform(format.getMatrix()));
        }
        return false;
    }

    public static PageFormat getPageFormat(PrintRequestAttributeSet aset) {
        PageFormat format = new PageFormat();
        Paper paper = format.getPaper();
        Attribute attrib = aset.get(MediaPrintableArea.class);
        if (attrib != null) {
            MediaPrintableArea mpa = (MediaPrintableArea)attrib;
            paper.setImageableArea((double)mpa.getX(25400) * 72.0, (double)mpa.getY(25400) * 72.0, (double)mpa.getWidth(25400) * 72.0, (double)mpa.getHeight(25400) * 72.0);
        }
        if ((attrib = aset.get(Media.class)) instanceof MediaSizeName) {
            MediaSize size = MediaSize.getMediaSizeForName((MediaSizeName)attrib);
            paper.setSize((double)size.getX(25400) * 72.0, (double)size.getY(25400) * 72.0);
        }
        format.setPaper(paper);
        attrib = aset.get(OrientationRequested.class);
        if (attrib != null) {
            OrientationRequested orientation = (OrientationRequested)attrib;
            if (orientation == OrientationRequested.LANDSCAPE) {
                format.setOrientation(0);
            } else if (orientation == OrientationRequested.PORTRAIT) {
                format.setOrientation(1);
            } else if (orientation == OrientationRequested.REVERSE_LANDSCAPE) {
                format.setOrientation(2);
            } else if (orientation == OrientationRequested.REVERSE_PORTRAIT) {
                format.setOrientation(1);
            }
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkerThread printJob(PrinterJob job, PrintRequestAttributeSet aset, boolean modal) {
        JobRequest request = new JobRequest(job, aset);
        if (modal) {
            Queue<JobRequest> queue = modalJobQueue;
            synchronized (queue) {
                modalJobQueue.add(request);
                if (modalJobThread == null || !modalJobThread.isAlive()) {
                    modalJobThread = new JobThread(true);
                    modalJobThread.start();
                }
                return modalJobThread;
            }
        }
        Queue<JobRequest> queue = nonModalJobQueue;
        synchronized (queue) {
            nonModalJobQueue.add(request);
            if (nonModalJobThread == null || !nonModalJobThread.isAlive()) {
                nonModalJobThread = new JobThread(false);
                nonModalJobThread.start();
            }
            return nonModalJobThread;
        }
    }

    public static WorkerThread printJob(PrinterJob job, PrintRequestAttributeSet aset) {
        return PrintHelper.printJob(job, aset, true);
    }

    public static void setMediaSizeName(MediaSizeName name) {
        mediaSizeName = name;
        mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        area = new MediaPrintableArea(0.5f, 0.5f, mediaSize.getX(25400) - 1.0f, mediaSize.getY(25400) - 1.0f, 25400);
    }

    public static MediaSizeName getMediaSizeName() {
        return mediaSizeName;
    }

    public static void setRunBeforePrint(Runnable run) {
        runBeforePrint = run;
    }

    public static Runnable getRunBeforePrint() {
        return runBeforePrint;
    }

    public static void setRunAfterPrint(Runnable run) {
        runAfterPrint = run;
    }

    public static Runnable getRunAfterPrint() {
        return runAfterPrint;
    }

    private PrintHelper() {
    }

    static {
        PrintHelper.setMediaSizeName(MediaSizeName.ISO_A4);
        modalJobQueue = new LinkedList<JobRequest>();
        nonModalJobQueue = new LinkedList<JobRequest>();
    }

    private static class JobThread
    extends WorkerThread {
        private final Queue<JobRequest> jobQueue;
        private volatile JobRequest request;
        private volatile boolean abortRequested;

        private JobThread(boolean modal) {
            super(null, modal, PrintSwingPrintBundle.getString("PRINTING..."));
            this.jobQueue = modal ? modalJobQueue : nonModalJobQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Queue<JobRequest> queue;
            while (!this.abortRequested) {
                queue = this.jobQueue;
                synchronized (queue) {
                    this.request = this.jobQueue.poll();
                    if (this.request == null) {
                        LOGGER.finer("printing queue is empty", new Object[0]);
                        break;
                    }
                }
                try {
                    LOGGER.fine("printing job {0}", new Object[]{this.request.job.getJobName()});
                    if (runBeforePrint != null) {
                        runBeforePrint.run();
                    }
                    String title = this.request.title;
                    EventQueue.invokeLater(() -> this.getWorkerDialog().setTitle(title));
                    this.request.job.print(this.request.aset);
                }
                catch (Exception e) {
                    if (e instanceof PrinterAbortException) {
                        FormInfo.show((String)PrintSwingPrintBundle.getString("PRINTING ABORTED"));
                        continue;
                    }
                    LOGGER.logStacktrace(Logger.Level.SEVERE, (Throwable)e);
                    FormError.showException((String)PrintSwingPrintBundle.getString("PRINTING FAILED!"), (Throwable)e);
                }
                finally {
                    if (runAfterPrint == null) continue;
                    runAfterPrint.run();
                }
            }
            if (this.abortRequested) {
                queue = this.jobQueue;
                synchronized (queue) {
                    this.jobQueue.clear();
                }
            }
            super.run();
        }

        public void start() {
            super.start();
            if (!EventQueue.isDispatchThread()) {
                FormUtilities.getInstance().waitForEmptyEventQueue();
            }
        }

        public void interrupt() {
            if (this.request != null) {
                LOGGER.fine("printing canceled", new Object[0]);
                this.request.job.cancel();
                this.request = null;
            }
            this.abortRequested = true;
        }
    }

    private static class JobRequest {
        private final PrinterJob job;
        private final PrintRequestAttributeSet aset;
        private String title;

        private JobRequest(PrinterJob job, PrintRequestAttributeSet aset) {
            this.job = job;
            this.aset = aset;
            this.title = job.getJobName();
            this.title = this.title == null ? PrintSwingPrintBundle.getString("PRINTING...") : MessageFormat.format(PrintSwingPrintBundle.getString("PRINTING {0} ..."), this.title);
            LOGGER.fine("queued printing job {0}", new Object[]{job.getJobName()});
        }
    }
}

