/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JPanel;

public class PrintPanel
extends JPanel
implements Printable {
    public PrintPanel() {
        super(false);
        this.setup();
    }

    public PrintPanel(LayoutManager layout) {
        super(layout, false);
        this.setup();
    }

    private void setup() {
        this.setOpaque(false);
        this.setBackground(Color.white);
    }

    @Override
    public void print(Graphics g) {
        super.print(g);
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            Point loc = c.getLocation();
            g.translate(loc.x, loc.y);
            if (c.isVisible()) {
                c.print(g);
            }
            g.translate(-loc.x, -loc.y);
        }
    }

    public Dimension getDynamicSize() {
        Component[] comps = this.getComponents();
        Rectangle bounds = new Rectangle();
        for (int i = 0; i < comps.length; ++i) {
            bounds.add(comps[i].getBounds());
        }
        return bounds.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size == null || size.width <= 1 && size.height <= 1) {
            size = this.getDynamicSize();
        }
        return size;
    }

    public void pack() {
        if (this.getLayout() == null) {
            this.doNullLayout();
        }
        this.setSize(this.getPreferredSize());
        this.doLayout();
    }

    public void packHeightForWidth(int width) {
        if (this.getLayout() == null) {
            this.doNullLayout();
        }
        this.setSize(width, this.getPreferredSize().height);
        this.doLayout();
    }

    public void packWidthForHeight(int height) {
        if (this.getLayout() == null) {
            this.doNullLayout();
        }
        this.setSize(this.getPreferredSize().width, height);
        this.doLayout();
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        this.print(graphics);
        return 0;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (!(c instanceof Container)) continue;
            c.doLayout();
        }
    }

    private void doNullLayout() {
        Component c;
        int i;
        Component[] comps = this.getComponents();
        Dimension size = this.getPreferredSize();
        int minX = size.width;
        int minY = size.height;
        for (i = 0; i < comps.length; ++i) {
            c = comps[i];
            if (c.getX() < minX) {
                minX = c.getX();
            }
            if (c.getY() >= minY) continue;
            minY = c.getY();
        }
        for (i = 0; i < comps.length; ++i) {
            c = comps[i];
            c.setLocation(c.getX() - minX, c.getY() - minY);
        }
    }
}

