/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.tentackle.misc.FormatHelper;
import org.tentackle.swing.print.PrintLabel;

public class DatePrintLabel
extends PrintLabel {
    private SimpleDateFormat format;

    public DatePrintLabel(int columns) {
        super(columns);
        this.setFormat(FormatHelper.getShortDatePattern());
        this.setPrintValue(new Date());
    }

    public DatePrintLabel() {
        this(0);
    }

    @Override
    public void setPrintValue(Object value) {
        this.value = value;
        this.setText(value == null ? null : this.doFormat(value));
    }

    public String doFormat(Object value) {
        return value instanceof Date ? this.format.format((Date)value) : null;
    }

    public void setFormat(String pattern) {
        this.format = new SimpleDateFormat(pattern);
        this.setPrintValue(this.value);
    }

    public String getFormat() {
        return this.format.toPattern();
    }
}

