/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Date;
import javax.swing.border.LineBorder;
import org.tentackle.misc.FormatHelper;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.print.PrintHelper;
import org.tentackle.swing.print.PrintTextArea;

public class FormTablePrintable
implements Printable {
    private FormTable table;
    private String title;
    private String intro;
    private Date printDate;

    public FormTablePrintable(FormTable table, String title, String intro) {
        this.table = table;
        this.title = title;
        this.intro = intro;
    }

    public FormTablePrintable(FormTable table) {
        this(table, null, null);
    }

    public void doPrint() {
        Window parent;
        if (this.title == null && (parent = FormUtilities.getInstance().getParentWindow((Component)this.table)) instanceof FormWindow) {
            this.title = ((FormWindow)parent).getTitle();
        }
        this.printDate = new Date();
        PrintHelper.print(this, this.title);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.processPrinting(g, pageFormat, pageIndex, false);
    }

    private int processPrinting(Graphics g, PageFormat pageFormat, int pageIndex, boolean countOnly) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(g2.getFont().deriveFont(1));
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(Color.black);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int tableWidth = this.table.getWidth();
        double pageHeight = pageFormat.getImageableHeight();
        double pageWidth = pageFormat.getImageableWidth();
        double scale = (double)tableWidth > pageWidth ? pageWidth / (double)tableWidth : 1.0;
        double introHeight = 0.0;
        PrintTextArea introField = null;
        if (this.intro != null) {
            introHeight = (double)(fontHeight + fontDescent) * scale * 3.0;
            if (pageIndex == 0) {
                introField = new PrintTextArea();
                introField.setBorder(new LineBorder(Color.GRAY));
                introField.setWrapStyleWord(true);
                introField.setLineWrap(true);
                introField.setSize(new Dimension((int)(pageWidth / scale), (int)introHeight));
            }
        }
        double pageTitleHeight = this.title == null ? 0.0 : (double)fontHeight * scale * 2.0;
        double pageHeaderHeight = (double)this.table.getTableHeader().getHeight() * scale;
        double pageFootHeight = (double)fontHeight * scale * 2.0;
        double pageTableHeight = pageHeight - pageTitleHeight - pageHeaderHeight - pageFootHeight;
        double currentPageTableHeight = pageTableHeight - introHeight;
        int rows = this.table.getRowCount();
        int pageNo = 0;
        double dataSkip = 0.0;
        double dataHeight = 0.0;
        double pageSkip = 0.0;
        double yInTable = 0.0;
        for (int row = 0; row < rows; ++row) {
            double rowHeight = (double)this.table.getRowHeight(row) * scale;
            if (yInTable - pageSkip + rowHeight > currentPageTableHeight) {
                if (pageNo == pageIndex) {
                    dataHeight = yInTable - dataSkip;
                }
                currentPageTableHeight = pageTableHeight;
                pageSkip = yInTable;
                if (++pageNo == pageIndex) {
                    dataSkip = pageSkip;
                }
            }
            yInTable += rowHeight;
        }
        if (pageNo == pageIndex) {
            dataHeight = yInTable - dataSkip;
        }
        ++pageNo;
        if (countOnly) {
            return pageNo;
        }
        if (pageIndex >= pageNo) {
            return 1;
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2.scale(scale, scale);
        if (this.title != null) {
            int left = (int)(pageWidth / 2.0 / scale) - fm.stringWidth(this.title) / 2;
            if (left < 0) {
                left = 0;
            }
            g2.drawString(this.title, left, fontHeight - fontDescent);
        }
        g2.translate(0.0, pageTitleHeight / scale);
        if (introField != null) {
            introField.setPrintValue(this.intro);
            introField.paint(g2);
            g2.translate(0.0, introHeight / scale);
        }
        this.table.getTableHeader().paint(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(0.0, pageHeaderHeight - dataSkip);
        g2.setClip(0, (int)Math.ceil(dataSkip), (int)Math.ceil(pageWidth), (int)Math.ceil(dataHeight));
        g2.scale(scale, scale);
        this.table.paint((Graphics)g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(0.0, dataSkip + pageTableHeight - (pageIndex == 0 ? introHeight : 0.0) + (double)fontHeight);
        g2.setClip(0, 0, (int)Math.ceil(pageWidth), (int)Math.ceil(pageHeight));
        g2.scale(scale, scale);
        g2.drawString(FormatHelper.formatShortDate((Date)this.printDate), 0, fontHeight - fontDescent);
        String footer = "- " + (pageIndex + 1) + " -";
        g2.drawString(footer, tableWidth / 2 - fm.stringWidth(footer) / 2, fontHeight - fontDescent);
        return 0;
    }
}

