/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JTextArea;
import org.tentackle.swing.print.PrintComponent;

public class PrintTextArea
extends JTextArea
implements PrintComponent {
    private Object value;
    private boolean autoHeight;
    private boolean autoWidth;

    public PrintTextArea(String text, int rows, int columns) {
        super(rows, columns);
        Font font = this.getFont();
        this.setFont(new Font(font.getName(), 0, font.getSize()));
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setPrintValue(text);
        this.setOpaque(false);
        this.setBorder(null);
    }

    public PrintTextArea(String text) {
        this(text, 0, 0);
    }

    public PrintTextArea() {
        this((String)null);
    }

    public void setAutoHeight(boolean autoHeight) {
        this.autoHeight = autoHeight;
    }

    public boolean isAutoHeight() {
        return this.autoHeight;
    }

    public void setAutoWidth(boolean autoWidth) {
        this.autoWidth = autoWidth;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    @Override
    public Object getPrintValue() {
        return this.value;
    }

    @Override
    public void setPrintValue(Object value) {
        this.value = value;
        this.setText(value == null ? null : value.toString());
        if (this.autoHeight && this.autoWidth) {
            this.setSize(this.getPreferredSize());
        } else if (this.autoHeight) {
            this.setSize(this.getWidth(), this.getPreferredSize().height);
        } else if (this.autoWidth) {
            this.setSize(this.getPreferredSize().width, this.getHeight());
        }
    }
}

