/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.JLabel;
import org.tentackle.swing.print.PrintComponent;

public class PrintLabel
extends JLabel
implements PrintComponent {
    protected Object value;
    private int preferredHeight;
    private int preferredWidth;
    private int columnWidth;
    private int columns;

    public PrintLabel(String text, int columns, int horizontalAlignment) {
        super(text, null, horizontalAlignment);
        this.setColumns(columns);
        Font font = this.getFont();
        this.setFont(new Font(font.getName(), 0, font.getSize()));
        this.setForeground(Color.black);
        this.setBackground(Color.white);
    }

    public PrintLabel(int columns, int horizontalAlignment) {
        this("", columns, horizontalAlignment);
    }

    public PrintLabel(int columns) {
        this(0, 10);
    }

    public PrintLabel() {
        this(0);
    }

    public void setColumns(int columns) {
        if (columns != this.columns) {
            if (columns < 0) {
                throw new IllegalArgumentException("columns less than zero.");
            }
            this.columns = columns;
            this.invalidate();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.preferredHeight != 0) {
            size.height = this.preferredHeight;
        }
        if (this.preferredWidth != 0) {
            size.width = this.preferredWidth;
        } else if (this.columns != 0) {
            size.width = this.columns * this.getColumnWidth();
        }
        return size;
    }

    public void setPreferredHeight(int height) {
        this.preferredHeight = height;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.columns != 0) {
            Dimension dim = this.getPreferredSize();
            width = dim.width;
            height = dim.height;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        if (this.columns != 0) {
            Dimension dim = this.getPreferredSize();
            r = new Rectangle(r.x, r.y, dim.width, dim.height);
        }
        super.setBounds(r);
    }

    @Override
    public void setSize(Dimension d) {
        if (this.columns != 0) {
            d = this.getPreferredSize();
        }
        super.setSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        if (this.columns != 0) {
            Dimension d = this.getPreferredSize();
            width = d.width;
            height = d.height;
        }
        super.setSize(width, height);
    }

    @Override
    public void setPrintValue(Object value) {
        this.value = value;
        this.setText(value == null ? null : value.toString());
    }

    @Override
    public Object getPrintValue() {
        return this.value;
    }
}

