/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormDialog;
import org.tentackle.swing.FormLabel;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.rdc.LoginDialog;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;

public class DefaultLoginDialog
extends FormDialog
implements LoginDialog {
    private static final long serialVersionUID = -1244250738977558564L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLoginDialog.class);
    private SessionInfo sessionInfo;
    private boolean waitLogin;
    private boolean ok;
    private boolean promptLogin;
    private boolean capsLockInitialized;
    private boolean capsLock;
    private volatile boolean locked;
    private KeyListener capsLockDetector = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 20) {
                DefaultLoginDialog.this.setCapsLock(!DefaultLoginDialog.this.capsLock);
            }
            if (!DefaultLoginDialog.this.capsLockInitialized) {
                if (Character.isUpperCase(e.getKeyChar()) && !e.isShiftDown()) {
                    DefaultLoginDialog.this.setCapsLock(true);
                }
                DefaultLoginDialog.this.capsLockInitialized = true;
            }
        }
    };
    private FormButton cancelLoginButton;
    private FormButton cancelStatusButton;
    private FormLabel capsLockLabel;
    private JLabel imageLabel;
    private FormLabel jLabel1;
    private FormLabel jLabel2;
    private JLayeredPane layeredPane;
    private FormPanel loginPanel;
    private JLabel logoLabel;
    private FormPanel logoPanel;
    private StringFormField nameField;
    private FormButton okButton;
    private JPasswordField passField;
    private FormLabel statusLabel;
    private FormPanel statusPanel;

    public DefaultLoginDialog(SessionInfo sessionInfo, boolean promptLogin, Icon logo) {
        this.sessionInfo = sessionInfo == null ? Pdo.createSessionInfo(null, null, null) : sessionInfo;
        this.promptLogin = promptLogin;
        this.initComponents();
        if (logo == null) {
            logo = new ImageIcon(this.getClass().getResource("/org/tentackle/appworx/images/loginLogo.png"));
        }
        Dimension size = this.imageLabel.getPreferredSize();
        int width = size.width;
        int height = size.height;
        this.layeredPane.setPreferredSize(size);
        this.imageLabel.setBounds(0, 0, width, height);
        this.loginPanel.setBounds(0, 0, width, height);
        this.logoPanel.setBounds(0, 0, width, height);
        this.statusPanel.setBounds(0, 0, width, height);
        this.statusPanel.setVisible(false);
        int logoWidth = logo.getIconWidth();
        int logoHeight = logo.getIconHeight();
        this.logoLabel.setIcon(logo);
        this.logoLabel.setBounds((width / 2 - logoWidth) / 2, (height - logoHeight) / 2, logoWidth, logoHeight);
        try {
            Toolkit.getDefaultToolkit().setLockingKeyState(20, false);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.info("turning off CAPS LOCK not supported for this platform", new Object[0]);
        }
        this.nameField.addKeyListener(this.capsLockDetector);
        this.passField.addKeyListener(this.capsLockDetector);
        this.setCapsLock(false);
    }

    public DefaultLoginDialog(SessionInfo ui, Icon logo) {
        this(ui, ui == null || ui.getUserName() == null || ui.getPassword() == null, logo);
    }

    public DefaultLoginDialog() {
        this(null, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionInfo getSessionInfo() {
        boolean bl = this.locked = !EventQueue.isDispatchThread();
        if (this.locked) {
            EventQueue.invokeLater(() -> this.prepareDialog());
            this.waitLogin = true;
            DefaultLoginDialog defaultLoginDialog = this;
            synchronized (defaultLoginDialog) {
                while (this.waitLogin) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            FormUtilities.getInstance().removeWindow((Window)((Object)this));
            EventQueue.invokeLater(() -> {
                this.setLoginPanelVisible(false);
                this.statusPanel.setVisible(true);
            });
        } else {
            this.prepareDialog();
        }
        if (this.ok) {
            char[] pass = this.passField.getPassword();
            if (pass != null && pass.length == 0) {
                pass = null;
            }
            this.sessionInfo.setPassword(pass);
            this.sessionInfo.setUserName(this.nameField.getText());
            return this.sessionInfo;
        }
        return null;
    }

    @Override
    public void showStatus(String status) {
        if (this.locked) {
            EventQueue.invokeLater(() -> this.setStatus(status));
        } else {
            this.setStatus(status);
        }
    }

    public StringFormField getUsernameField() {
        return this.nameField;
    }

    public JPasswordField getPasswordField() {
        return this.passField;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.waitLogin = false;
        }
        super.processWindowEvent(e);
    }

    private void setStatus(String status) {
        if (!this.statusPanel.isVisible()) {
            this.statusPanel.setVisible(true);
        }
        this.capsLockLabel.setText("");
        this.statusLabel.setText(status);
    }

    private void setLoginPanelVisible(boolean visible) {
        this.loginPanel.setVisible(visible);
        this.cancelStatusButton.setVisible(visible);
    }

    private void setCapsLock(boolean capsLock) {
        this.capsLock = capsLock;
        this.capsLockLabel.setText(capsLock ? RdcSwingRdcBundle.getString("CAPS LOCK!") : "");
        if (capsLock && this.statusPanel.isVisible()) {
            this.statusPanel.setVisible(false);
        }
    }

    private void prepareDialog() {
        this.nameField.setText(this.sessionInfo.getUserName());
        this.passField.setText(null);
        this.passField.setCaretPosition(0);
        if (this.promptLogin) {
            this.setLoginPanelVisible(true);
            this.nameField.requestFocusLater();
        } else {
            this.setLoginPanelVisible(false);
            this.statusPanel.setVisible(true);
            this.promptLogin = true;
        }
        this.pack();
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash != null) {
            splash.close();
        }
        this.setModal(!this.locked);
        this.ok = false;
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOk(boolean ok) {
        this.ok = ok;
        this.waitLogin = false;
        if (!this.locked) {
            this.dispose();
        } else {
            DefaultLoginDialog defaultLoginDialog = this;
            synchronized (defaultLoginDialog) {
                this.notifyAll();
            }
        }
    }

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.imageLabel = new JLabel();
        this.loginPanel = new FormPanel();
        this.jLabel1 = new FormLabel();
        this.jLabel2 = new FormLabel();
        this.nameField = new StringFormField();
        this.passField = new JPasswordField();
        this.okButton = new FormButton();
        this.cancelLoginButton = new FormButton();
        this.capsLockLabel = new FormLabel();
        this.statusPanel = new FormPanel();
        this.statusLabel = new FormLabel();
        this.cancelStatusButton = new FormButton();
        this.logoPanel = new FormPanel();
        this.logoLabel = new JLabel();
        this.setAutoPosition(true);
        this.setUndecorated(true);
        this.layeredPane.setBackground(new Color(2, 2, 206));
        this.layeredPane.setOpaque(true);
        this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/tentackle/swing/rdc/images/login.png")));
        this.layeredPane.add(this.imageLabel);
        this.imageLabel.setBounds(0, 0, 500, 350);
        this.loginPanel.setOpaque(false);
        this.jLabel1.setForeground(new Color(204, 204, 255));
        this.jLabel1.setText(RdcSwingRdcBundle.getTranslation("USERNAME:"));
        this.jLabel1.setFont(new Font("SansSerif", 1, 12));
        this.jLabel2.setForeground(new Color(204, 204, 255));
        this.jLabel2.setText(RdcSwingRdcBundle.getTranslation("PASSWORD:"));
        this.jLabel2.setFont(new Font("SansSerif", 1, 12));
        this.nameField.setAutoSelect(true);
        this.nameField.setBackground(new Color(204, 204, 255));
        this.nameField.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 255), 2));
        this.nameField.setColumns(8);
        this.nameField.setFont(new Font("SansSerif", 1, 12));
        this.nameField.setName("username");
        this.passField.setBackground(new Color(204, 204, 255));
        this.passField.setColumns(8);
        this.passField.setFont(new Font("SansSerif", 1, 12));
        this.passField.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 255), 2));
        this.passField.setName("password");
        this.passField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultLoginDialog.this.passFieldActionPerformed(evt);
            }
        });
        this.okButton.setBackground(new Color(204, 204, 255));
        this.okButton.setText(RdcSwingRdcBundle.getTranslation("LOGIN"));
        this.okButton.setMargin(new Insets(0, 4, 0, 4));
        this.okButton.setName("login");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultLoginDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelLoginButton.setBackground(new Color(204, 204, 255));
        this.cancelLoginButton.setText(RdcSwingRdcBundle.getTranslation("CANCEL"));
        this.cancelLoginButton.setMargin(new Insets(0, 4, 0, 4));
        this.cancelLoginButton.setName("cancelLogin");
        this.cancelLoginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultLoginDialog.this.cancelLoginButtonActionPerformed(evt);
            }
        });
        this.capsLockLabel.setForeground(Color.orange);
        this.capsLockLabel.setText(RdcSwingRdcBundle.getTranslation("CAPS LOCK"));
        GroupLayout loginPanelLayout = new GroupLayout((Container)this.loginPanel);
        this.loginPanel.setLayout((LayoutManager)loginPanelLayout);
        loginPanelLayout.setHorizontalGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loginPanelLayout.createSequentialGroup().addContainerGap().addGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, loginPanelLayout.createSequentialGroup().addGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.jLabel1, -2, -1, -2).addComponent((Component)this.jLabel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.okButton, -2, -1, -2).addGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.nameField, -2, -1, -2).addComponent(this.passField, -2, -1, -2))).addGap(41, 41, 41)).addGroup(loginPanelLayout.createSequentialGroup().addComponent((Component)this.cancelLoginButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.capsLockLabel, -1, 410, Short.MAX_VALUE).addContainerGap()))));
        loginPanelLayout.setVerticalGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, loginPanelLayout.createSequentialGroup().addContainerGap(137, Short.MAX_VALUE).addGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.nameField, -2, -1, -2).addComponent((Component)this.jLabel1, -2, -1, -2)).addGap(23, 23, 23).addGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passField, -2, -1, -2).addComponent((Component)this.jLabel2, -2, -1, -2)).addGap(26, 26, 26).addComponent((Component)this.okButton, -2, -1, -2).addGap(77, 77, 77).addGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.cancelLoginButton, -2, -1, -2).addComponent((Component)this.capsLockLabel, -2, -1, -2)).addContainerGap()));
        this.layeredPane.add((Component)this.loginPanel);
        this.loginPanel.setBounds(0, 0, 500, 355);
        this.layeredPane.setLayer((Component)this.loginPanel, JLayeredPane.PALETTE_LAYER);
        this.statusPanel.setOpaque(false);
        this.statusLabel.setForeground(Color.orange);
        this.statusLabel.setText(RdcSwingRdcBundle.getTranslation("LOGIN..."));
        this.cancelStatusButton.setBackground(new Color(204, 204, 255));
        this.cancelStatusButton.setText(RdcSwingRdcBundle.getTranslation("CANCEL"));
        this.cancelStatusButton.setMargin(new Insets(0, 4, 0, 4));
        this.cancelStatusButton.setName("cancelStatus");
        this.cancelStatusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultLoginDialog.this.cancelStatusButtonActionPerformed(evt);
            }
        });
        GroupLayout statusPanelLayout = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.cancelStatusButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.statusLabel, -1, 410, Short.MAX_VALUE).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap(317, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.cancelStatusButton, -2, -1, -2).addComponent((Component)this.statusLabel, -2, -1, -2)).addContainerGap()));
        this.layeredPane.add((Component)this.statusPanel);
        this.statusPanel.setBounds(0, 0, 500, 350);
        this.layeredPane.setLayer((Component)this.statusPanel, JLayeredPane.MODAL_LAYER);
        this.logoPanel.setOpaque(false);
        this.logoPanel.setLayout(null);
        this.logoLabel.setIconTextGap(0);
        this.logoPanel.add((Component)this.logoLabel);
        this.logoLabel.setBounds(60, 110, 130, 145);
        this.layeredPane.add((Component)this.logoPanel);
        this.logoPanel.setBounds(0, 0, 500, 350);
        this.layeredPane.setLayer((Component)this.logoPanel, JLayeredPane.POPUP_LAYER);
        this.getContentPane().add((Component)this.layeredPane, "Center");
        this.pack();
    }

    private void cancelStatusButtonActionPerformed(ActionEvent evt) {
        this.setOk(false);
    }

    private void cancelLoginButtonActionPerformed(ActionEvent evt) {
        this.setOk(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setOk(true);
    }

    private void passFieldActionPerformed(ActionEvent evt) {
        this.okButton.doClick();
    }
}

