/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityResult;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.FormQuestion;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.rdc.PdoEditDialog;
import org.tentackle.swing.rdc.PdoEditDialogPool$Singleton;
import org.tentackle.swing.rdc.Rdc;

public class PdoEditDialogPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdoEditDialogPool.class);
    private final List<PdoEditDialog<?>> dialogList = new ArrayList();
    private boolean pdoEditedOnlyOnce = true;
    private boolean enabled = true;

    public static PdoEditDialogPool getInstance() {
        return PdoEditDialogPool$Singleton.INSTANCE;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isPdoEditedOnlyOnce() {
        return this.pdoEditedOnlyOnce;
    }

    public void setPdoEditedOnlyOnce(boolean pdoEditedOnlyOnce) {
        this.pdoEditedOnlyOnce = pdoEditedOnlyOnce;
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> isObjectBeingEdited(T object, PdoEditDialog<T> exceptMe, Comparator<? super PersistentDomainObject<?>> comp) {
        if (object != null && !object.isNew()) {
            for (PdoEditDialog<?> d : this.dialogList) {
                Object editedObject;
                if (exceptMe == d || !d.isVisible() || !d.isChangeable() || d.getPdoClass() != object.getEffectiveClass() || (editedObject = d.getPdo()) == null || !(comp != null ? comp.compare((PersistentDomainObject<?>)editedObject, object) == 0 : editedObject.equals(object))) continue;
                return d;
            }
        }
        return null;
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> isObjectBeingEdited(T object, PdoEditDialog<T> exceptMe) {
        return this.isObjectBeingEdited(object, exceptMe, null);
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> isObjectBeingEdited(T object) {
        return this.isObjectBeingEdited(object, null, null);
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> getDialog(Class<T> objectClass, boolean modal, boolean changeable) {
        if (this.enabled) {
            for (PdoEditDialog<?> d : this.dialogList) {
                if (d == null || d.isModal() != modal || d.isVisible() || d.isChangeable() != changeable || !d.getPdoClass().equals(objectClass)) continue;
                return d;
            }
        }
        return null;
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> createPdoEditDialog(Component comp, T pdo, boolean modal) {
        PdoEditDialog<T> dialog = null;
        if (pdo != null) {
            dialog = Rdc.createGuiProvider(pdo).createDialog(comp, modal);
        }
        if (dialog == null) {
            dialog = Rdc.createPdoEditDialog(FormUtilities.getInstance().getParentWindow(comp), pdo, modal);
        }
        return dialog;
    }

    public void addDialog(PdoEditDialog<?> d) {
        if (d != null && d.getPdoClass() != null && d.getPdoPanel() != null) {
            this.dialogList.add(d);
        }
    }

    public void removeDialog(PdoEditDialog<?> d) {
        d.setVisible(false);
        d.getContentPane().removeAll();
        this.dialogList.remove(d);
    }

    public void clear() {
        for (PdoEditDialog<?> d : this.dialogList) {
            this.removeDialog(d);
        }
        this.dialogList.clear();
    }

    public void disposeAllDialogs() {
        for (PdoEditDialog<?> d : this.dialogList) {
            if (!d.isVisible()) continue;
            d.dispose();
        }
    }

    public <T extends PersistentDomainObject<T>> T useModalDialog(Component comp, T object, boolean changeable, boolean noPersistence) {
        if (object != null) {
            PdoEditDialog<T> d = null;
            if (this.pdoEditedOnlyOnce && changeable && (d = this.isObjectBeingEdited(object)) != null) {
                if (!d.isModal()) {
                    d.dispose();
                    d.setModal(true);
                } else {
                    d.toFront();
                }
            }
            if (d == null) {
                d = this.getDialog(object.getEffectiveClass(), true, changeable);
            }
            if (d == null) {
                d = this.createPdoEditDialog(comp, object, true);
                if (!changeable) {
                    d.setChangeable(false);
                }
                this.addDialog(d);
            } else {
                d.setPdo(object);
            }
            object = d.showDialog(noPersistence);
        }
        return object;
    }

    public <T extends PersistentDomainObject<T>> T useModalDialog(Component comp, T object, boolean changeable) {
        return this.useModalDialog(comp, object, changeable, false);
    }

    public <T extends PersistentDomainObject<T>> T useModalDialog(T object, boolean changeable) {
        return this.useModalDialog(null, object, changeable, false);
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> useNonModalDialog(Component comp, T pdo, boolean changeable, boolean noPersistence, boolean disposeOnDeleteOrSave) {
        if (pdo != null) {
            PdoEditDialog<T> d = null;
            if (this.pdoEditedOnlyOnce && changeable && (d = this.isObjectBeingEdited(pdo)) != null) {
                if (d.isModal()) {
                    throw new IllegalStateException("dialog is modal?");
                }
                d.toFront();
            }
            if (d == null) {
                d = this.getDialog(pdo.getEffectiveClass(), false, changeable);
            }
            if (d == null) {
                d = this.createPdoEditDialog(comp, pdo, false);
                if (!changeable) {
                    d.setChangeable(false);
                }
                this.addDialog(d);
            } else {
                d.setPdo(pdo);
            }
            d.setDisposeOnDeleteOrSave(disposeOnDeleteOrSave);
            if (!d.isVisible()) {
                d.showDialog(noPersistence);
            }
            return d;
        }
        return null;
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> useNonModalDialog(T object, boolean changeable, boolean disposeOnDeleteOrSave) {
        return this.useNonModalDialog(null, object, changeable, false, disposeOnDeleteOrSave);
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> useNonModalDialog(Component comp, T object, boolean changeable) {
        return this.useNonModalDialog(comp, object, changeable, false, false);
    }

    public <T extends PersistentDomainObject<T>> PdoEditDialog<T> useNonModalDialog(T object, boolean changeable) {
        return this.useNonModalDialog(null, object, changeable, false, false);
    }

    public <T extends PersistentDomainObject<T>> void view(T object, Component comp) {
        this.useNonModalDialog(comp, object, false);
    }

    public <T extends PersistentDomainObject<T>> void view(T object) {
        this.useNonModalDialog(null, object, false);
    }

    public <T extends PersistentDomainObject<T>> void viewModal(T object, Component comp) {
        this.useModalDialog(comp, object, false);
    }

    public <T extends PersistentDomainObject<T>> void viewModal(T object) {
        this.useModalDialog(null, object, false);
    }

    public <T extends PersistentDomainObject<T>> void edit(T object, Component comp, boolean disposeOnDeleteOrSave) {
        this.useNonModalDialog(comp, object, true, false, disposeOnDeleteOrSave);
    }

    public <T extends PersistentDomainObject<T>> void edit(T object, boolean disposeOnDeleteOrSave) {
        this.edit(object, null, disposeOnDeleteOrSave);
    }

    public <T extends PersistentDomainObject<T>> void edit(T object) {
        this.edit(object, false);
    }

    public <T extends PersistentDomainObject<T>> T editModal(T object, Component comp) {
        return this.useModalDialog(comp, object, true);
    }

    public <T extends PersistentDomainObject<T>> T editModal(T object) {
        return this.useModalDialog(null, object, true);
    }

    public boolean delete(PersistentDomainObject<?> object) {
        if (FormQuestion.yesNo((String)MessageFormat.format("Are you sure to delete {0} {1}?", object.getSingular(), object))) {
            try {
                if (!object.isRemovable()) {
                    throw new PdoRuntimeException("object is not allowed to be removed");
                }
                SecurityResult sr = SecurityFactory.getInstance().getSecurityManager().evaluate(object.getBaseContext(), (Permission)SecurityFactory.getInstance().getWritePermission(), object.getClassId(), object.getId());
                if (!sr.isAccepted()) {
                    throw new PdoRuntimeException(sr.explain("you are not allowed to remove this object"));
                }
                try {
                    object.delete();
                }
                catch (RuntimeException e) {
                    throw new PdoRuntimeException("couldn't delete", (Throwable)e);
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.logStacktrace(Logger.Level.WARNING, (Throwable)e);
                FormInfo.show((String)e.getMessage());
            }
        }
        return false;
    }
}

