/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.bind.Bindable;
import org.tentackle.bind.Binder;
import org.tentackle.log.Logger;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.FormPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.rdc.InteractiveError;
import org.tentackle.swing.rdc.InteractiveErrorFactory;
import org.tentackle.swing.rdc.PdoEditDialog;
import org.tentackle.swing.rdc.TooltipAndErrorPanel;
import org.tentackle.validate.ValidationResult;

public class PdoPanel<T extends PersistentDomainObject<T>>
extends FormPanel
implements DomainContextProvider,
Printable,
Pageable {
    protected PdoEditDialog<T> dialog;
    private PageFormat defaultPageFormat;

    @Bindable
    public boolean setPdo(T object) {
        return false;
    }

    @Bindable
    public T getPdo() {
        return null;
    }

    public DomainContext getDomainContext() {
        T pdo = this.getPdo();
        return pdo == null ? null : pdo.getDomainContext();
    }

    public List<InteractiveError> verifyObject() {
        ArrayList<InteractiveError> errorList = new ArrayList<InteractiveError>();
        try {
            if (this.getPdo().findDuplicate() != null) {
                errorList.add(InteractiveErrorFactory.getInstance().createInteractiveError(MessageFormat.format("{0} {1} already exists", this.getPdo().getSingular(), this.getPdo().toString()), Logger.Level.WARNING, null, null, null));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return errorList;
    }

    public boolean prepareSave() {
        TooltipAndErrorPanel ttep;
        List<InteractiveError> errorList = this.verifyObject();
        if (this.dialog != null && (ttep = this.dialog.getTooltipAndErrorPanel()) != null) {
            ttep.setErrors(errorList);
        }
        return errorList.isEmpty();
    }

    public boolean prepareCancel() {
        return true;
    }

    public boolean prepareNew() {
        return true;
    }

    public boolean prepareSearch() {
        return true;
    }

    public boolean prepareDelete() {
        return true;
    }

    public boolean announceDelete() {
        return true;
    }

    public boolean announceSave() {
        return true;
    }

    public InteractiveError createInteractiveError(ValidationResult validationResult) {
        return InteractiveErrorFactory.getInstance().createInteractiveError(null, (Binder)this.getBinder(), validationResult);
    }

    public List<InteractiveError> createInteractiveErrors(List<ValidationResult> validationResults) {
        ArrayList<InteractiveError> errors = new ArrayList<InteractiveError>();
        for (ValidationResult validationResult : validationResults) {
            errors.add(this.createInteractiveError(validationResult));
        }
        return errors;
    }

    public void setPdoEditDialog(PdoEditDialog<T> dialog) {
        this.dialog = dialog;
    }

    public PdoEditDialog<T> getPdoEditDialog() {
        return this.dialog;
    }

    public void setInitialFocus() {
    }

    public String getTitle() {
        T obj;
        String title = super.getTitle();
        if (title == null && (obj = this.getPdo()) != null) {
            String contextName = obj.getBaseContext().toString();
            title = obj.isNew() ? (contextName == null || contextName.length() == 0 ? obj.getPlural() : obj.getPlural() + " in " + contextName) : obj.getSingular() + " " + (contextName == null || contextName.length() == 0 ? obj.toString() : obj.toString() + " in " + contextName);
        }
        return title;
    }

    public void pack() {
        if (this.dialog != null) {
            this.dialog.pack();
        } else {
            FormUtilities.getInstance().packParentWindow((Component)((Object)this));
        }
    }

    public Pageable getPageable(PrinterJob printJob) {
        this.defaultPageFormat = printJob.defaultPage();
        return null;
    }

    public Printable getPrintable(PrinterJob printJob) {
        this.defaultPageFormat = printJob.defaultPage();
        return this;
    }

    public void markPrinted() {
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double scale;
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double scaleX = pageFormat.getImageableWidth() / (double)this.getWidth();
        double scaleY = pageFormat.getImageableHeight() / (double)this.getHeight();
        double d = scale = scaleX < scaleY ? scaleX : scaleY;
        if (scale < 1.0) {
            g2d.scale(scale, scale);
        }
        this.paint(g2d);
        return 0;
    }

    @Override
    public Printable getPrintable(int pageIndex) {
        return this;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        return this.defaultPageFormat;
    }

    @Override
    public int getNumberOfPages() {
        return -1;
    }
}

