/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import javax.swing.ImageIcon;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.swing.rdc.GuiProvider;
import org.tentackle.swing.rdc.PdoTreeExtension;
import org.tentackle.swing.rdc.Rdc;

public class PdoTreeObject {
    private Object object;
    private Object parentObject;
    private GuiProvider pdod;
    private boolean isPdoTreeExtension;
    private boolean expanded;
    private boolean stopTreeWillExpand;
    private boolean stopExpandPath;
    private ImageIcon icon;
    private String toolTipText;
    private boolean toolTipTextLoaded;
    private String treeText;
    private boolean treeTextLoaded;

    public PdoTreeObject(Object object, Object parentObject) {
        this.parentObject = parentObject;
        this.setObject(object);
    }

    public Object getParentObject() {
        return this.parentObject;
    }

    public boolean equals(Object obj) {
        try {
            return obj instanceof PdoTreeObject && this.object.equals(((PdoTreeObject)obj).object);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.object != null ? this.object.hashCode() : 0);
        return hash;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getToolTipText() {
        if (!this.toolTipTextLoaded) {
            this.toolTipText = null;
            if (this.pdod != null) {
                this.toolTipText = this.pdod.getToolTipText(this.parentObject);
            } else if (this.isPdoTreeExtension) {
                this.toolTipText = ((PdoTreeExtension)this.object).getToolTipText();
            }
            this.toolTipTextLoaded = true;
        }
        if (this.toolTipText != null && this.toString() != null && this.treeText.equals(this.toolTipText)) {
            return null;
        }
        return this.toolTipText;
    }

    public String toString() {
        if (!this.treeTextLoaded) {
            if (this.pdod != null) {
                this.treeText = this.pdod.getTreeText(this.parentObject);
            } else {
                try {
                    this.treeText = this.object.toString();
                }
                catch (Exception e2) {
                    this.treeText = this.object == null ? "<NULL>" : "<" + e2.getMessage() + ">";
                }
            }
            this.treeTextLoaded = true;
        }
        return this.treeText;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public Class<?> getObjectClass() {
        if (this.object instanceof EffectiveClassProvider) {
            return ((EffectiveClassProvider)this.object).getEffectiveClass();
        }
        return this.object.getClass();
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
        this.toolTipTextLoaded = false;
        this.treeTextLoaded = false;
        if (object instanceof PersistentDomainObject) {
            this.pdod = Rdc.createGuiProvider((PersistentDomainObject)object);
            this.isPdoTreeExtension = false;
            this.stopExpandPath = Rdc.createGuiProvider((PersistentDomainObject)object).stopTreeExpansion();
            this.icon = this.pdod.getIcon();
        } else {
            this.isPdoTreeExtension = object instanceof PdoTreeExtension;
            if (this.isPdoTreeExtension) {
                this.icon = ((PdoTreeExtension)object).getIcon();
            }
        }
    }

    public boolean isStopTreeWillExpand() {
        return this.stopTreeWillExpand;
    }

    public void setStopTreeWillExpand(boolean stopExpansion) {
        this.stopTreeWillExpand = stopExpansion;
    }

    public boolean isStopExpandPath() {
        return this.stopExpandPath;
    }

    public void setStopExpandPath(boolean stopExpandPath) {
        this.stopExpandPath = stopExpandPath;
    }

    public String getTreeText() {
        return this.treeText;
    }

    public void setTreeText(String treeText) {
        this.treeText = treeText;
        this.treeTextLoaded = true;
    }
}

