/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import org.tentackle.log.Logger;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.rdc.InteractiveError;
import org.tentackle.validate.ValidationResult;

public class DefaultInteractiveError
implements InteractiveError {
    private Logger.Level level;
    private String text;
    private String errorCode;
    private ValidationResult validationResult;
    private Object uiComponent;

    public DefaultInteractiveError(String text, Logger.Level level, String errorCode, ValidationResult validationResult, Object uiComponent) {
        this.setText(text);
        this.setLevel(level);
        this.setErrorCode(errorCode);
        this.setValidationResult(validationResult);
        this.setUiComponent(uiComponent);
    }

    public DefaultInteractiveError(InteractiveError error) {
        this(error.getText(), error.getLevel(), error.getErrorCode(), error.getValidationResult(), error.getUiComponent());
    }

    public DefaultInteractiveError() {
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public Logger.Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Logger.Level level) {
        this.level = level;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public FormComponent getFormComponent() {
        return this.uiComponent instanceof FormComponent ? (FormComponent)this.uiComponent : null;
    }

    @Override
    public Object getUiComponent() {
        return this.uiComponent;
    }

    @Override
    public void setUiComponent(Object uiComponent) {
        this.uiComponent = uiComponent;
    }

    @Override
    public void showComponent() {
        FormComponent comp = this.getFormComponent();
        if (comp != null) {
            comp.requestFocusLater();
        }
    }

    @Override
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Override
    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
        this.text = validationResult.getMessage();
        this.errorCode = validationResult.getErrorCode();
        this.level = validationResult.hasFailed() ? Logger.Level.SEVERE : Logger.Level.WARNING;
    }
}

