/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.rdc;

import java.text.MessageFormat;
import java.util.List;
import org.tentackle.misc.ScrollableResource;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.swing.FormInfo;
import org.tentackle.swing.rdc.AbstractPdoSearch;
import org.tentackle.swing.rdc.DefaultSearchPanel;
import org.tentackle.swing.rdc.RdcSwingRdcBundle;

public class DefaultSearch<T extends PersistentDomainObject<T>>
extends AbstractPdoSearch<T> {
    private String pattern;
    private int minPatternLength;
    private DefaultSearchPanel searchPanel;

    public DefaultSearch(Class<T> pdoClass, DomainContext context, int fetchSize, int warnRowCount, int maxRowCount) {
        super(pdoClass, context, fetchSize, warnRowCount, maxRowCount);
    }

    public DefaultSearch(Class<T> pdoClass, DomainContext context) {
        super(pdoClass, context);
    }

    public DefaultSearch(T pdo) {
        super(pdo.getEffectiveClass(), pdo.getDomainContext());
        this.presetSearchCriteria(pdo);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.getSearchPanel().setPattern(pattern);
    }

    public int getMinPatternLength() {
        return this.minPatternLength;
    }

    public void setMinPatternLength(int minPatternLength) {
        this.minPatternLength = minPatternLength;
    }

    @Override
    public DefaultSearchPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new DefaultSearchPanel();
        }
        return this.searchPanel;
    }

    @Override
    public String getSearchCriteriaAsString() {
        return MessageFormat.format(RdcSwingRdcBundle.getString("PATTERN={0}"), this.pattern == null || this.pattern.isEmpty() ? RdcSwingRdcBundle.getString("<ALL>") : this.pattern);
    }

    @Override
    public boolean isSearchCriteriaValid() {
        return this.validatePattern();
    }

    @Override
    public boolean isSearchRetrievingAll() {
        return this.pattern == null || this.pattern.isEmpty();
    }

    @Override
    public boolean isResultValid(List<T> list) {
        return true;
    }

    @Override
    public ScrollableResource<T> findByCriteria(T proxy) {
        return proxy.selectByNormTextAsCursor(StringHelper.toLikeString((String)StringHelper.normalize((String)this.pattern)));
    }

    @Override
    public void resetSearchCriteria() {
        this.pattern = null;
    }

    @Override
    public void presetSearchCriteria(T template) {
    }

    public boolean validatePattern() {
        this.pattern = this.getSearchPanel().getPattern();
        if (this.minPatternLength > 0 && (this.pattern == null || this.pattern.length() < this.minPatternLength)) {
            FormInfo.show((String)MessageFormat.format(RdcSwingRdcBundle.getString("SEARCH PATTERN MUST CONTAIN AT LEAST {0} CHARACTERS"), this.minPatternLength));
            return false;
        }
        return true;
    }
}

